/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Signer;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static boolean checkSigningKey(@NonNull Repository repository, Signer signer, @NonNull GpgConfig config, @NonNull PersonIdent personIdent) {
        if (signer != null) {
            try {
                CredentialsProvider credentials = new CredentialsProvider(){

                    public boolean supports(CredentialItem ... items) {
                        return true;
                    }

                    public boolean isInteractive() {
                        return false;
                    }

                    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                        return false;
                    }
                };
                return signer.canLocateSigningKey(repository, config, personIdent, config.getSigningKey(), credentials);
            }
            catch (CanceledException e) {
                return true;
            }
        }
        return false;
    }
}

