/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search.internal.core.SearchCorePlugin;
import org.eclipse.search.internal.core.text.TextSearchEngineRegistry;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SorterDescriptor;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text2.TextSearchQueryProviderRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SearchPlugin
extends AbstractUIPlugin {
    public static final String SEARCH_PAGE_EXTENSION_POINT = "searchPages";
    public static final String SORTER_EXTENSION_POINT = "searchResultSorters";
    public static final String FILTERED_SEARCH_MARKER = "org.eclipse.search.filteredsearchmarker";
    public static final String SEARCH_ANNOTATION_TYPE = "org.eclipse.search.results";
    public static final String FILTERED_SEARCH_ANNOTATION_TYPE = "org.eclipse.search.filteredResults";
    public static final int INTERNAL_ERROR = 1;
    private static SearchPlugin fgSearchPlugin;
    private List<SearchPageDescriptor> fPageDescriptors;
    private List<SorterDescriptor> fSorterDescriptors;
    private TextSearchQueryProviderRegistry fTextSearchQueryProviderRegistry;

    public SearchPlugin() {
        Assert.isTrue((fgSearchPlugin == null ? 1 : 0) != 0);
        fgSearchPlugin = this;
        this.fTextSearchQueryProviderRegistry = null;
    }

    public static SearchPlugin getDefault() {
        return fgSearchPlugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(() -> SearchPlugin.setActiveWorkbenchWindow(windowRef));
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        Shell[] shells;
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            shell = shell.getParent();
        }
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell2 = shellArray[n2];
            Object data = shell2.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            ++n2;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SearchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void beep() {
        SearchPlugin.getActiveWorkbenchShell().getDisplay().beep();
    }

    public static IWorkbenchPage getActivePage() {
        return SearchPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    static boolean setAutoBuilding(boolean state) {
        IWorkspaceDescription workspaceDesc = SearchPlugin.getWorkspace().getDescription();
        boolean isAutobuilding = workspaceDesc.isAutoBuilding();
        if (isAutobuilding != state) {
            workspaceDesc.setAutoBuilding(state);
            try {
                SearchPlugin.getWorkspace().setDescription(workspaceDesc);
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, SearchMessages.Search_Error_setDescription_title, SearchMessages.Search_Error_setDescription_message);
            }
        }
        return isAutobuilding;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        InternalSearchUI.shutdown();
        super.stop(context);
        fgSearchPlugin = null;
    }

    public List<SearchPageDescriptor> getSearchPageDescriptors() {
        if (this.fPageDescriptors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search", SEARCH_PAGE_EXTENSION_POINT);
            this.fPageDescriptors = this.createSearchPageDescriptors(elements);
        }
        return this.fPageDescriptors;
    }

    public List<SearchPageDescriptor> getEnabledSearchPageDescriptors(String pageId) {
        Iterator<SearchPageDescriptor> iter = this.getSearchPageDescriptors().iterator();
        ArrayList<SearchPageDescriptor> enabledDescriptors = new ArrayList<SearchPageDescriptor>(5);
        while (iter.hasNext()) {
            SearchPageDescriptor desc = iter.next();
            if (!desc.isEnabled() && !desc.getId().equals(pageId)) continue;
            enabledDescriptors.add(desc);
        }
        return enabledDescriptors;
    }

    private List<SearchPageDescriptor> createSearchPageDescriptors(IConfigurationElement[] elements) {
        ArrayList<SearchPageDescriptor> result = new ArrayList<SearchPageDescriptor>(5);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("page".equals(element.getName())) {
                SearchPageDescriptor desc = new SearchPageDescriptor(element);
                result.add(desc);
            }
            ++n2;
        }
        Collections.sort(result);
        return result;
    }

    public List<SorterDescriptor> getSorterDescriptors() {
        if (this.fSorterDescriptors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search", SORTER_EXTENSION_POINT);
            this.fSorterDescriptors = this.createSorterDescriptors(elements);
        }
        return this.fSorterDescriptors;
    }

    public TextSearchEngineRegistry getTextSearchEngineRegistry() {
        return SearchCorePlugin.getDefault().getTextSearchEngineRegistry();
    }

    public TextSearchQueryProviderRegistry getTextSearchQueryProviderRegistry() {
        if (this.fTextSearchQueryProviderRegistry == null) {
            this.fTextSearchQueryProviderRegistry = new TextSearchQueryProviderRegistry();
        }
        return this.fTextSearchQueryProviderRegistry;
    }

    private List<SorterDescriptor> createSorterDescriptors(IConfigurationElement[] elements) {
        ArrayList<SorterDescriptor> result = new ArrayList<SorterDescriptor>(5);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("sorter".equals(element.getName())) {
                result.add(new SorterDescriptor(element));
            }
            ++n2;
        }
        return result;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void log(IStatus status) {
        SearchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        SearchPlugin.log((IStatus)new Status(4, "org.eclipse.search", 1, SearchMessages.SearchPlugin_internal_error, e));
    }

    public static String getID() {
        return "org.eclipse.search";
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        private WindowRef() {
        }
    }
}

