/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.MemoryStats;

final class ImmutableMemoryStats
implements MemoryStats {
    @Nullable
    private final MemoryStats.Stats stats;
    @Nullable
    private final Long maxUsage;
    @Nullable
    private final Long usage;
    @Nullable
    private final Long failcnt;
    @Nullable
    private final Long limit;

    private ImmutableMemoryStats(@Nullable MemoryStats.Stats stats, @Nullable Long maxUsage, @Nullable Long usage, @Nullable Long failcnt, @Nullable Long limit) {
        this.stats = stats;
        this.maxUsage = maxUsage;
        this.usage = usage;
        this.failcnt = failcnt;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="stats")
    @Nullable
    public MemoryStats.Stats stats() {
        return this.stats;
    }

    @Override
    @JsonProperty(value="max_usage")
    @Nullable
    public Long maxUsage() {
        return this.maxUsage;
    }

    @Override
    @JsonProperty(value="usage")
    @Nullable
    public Long usage() {
        return this.usage;
    }

    @Override
    @JsonProperty(value="failcnt")
    @Nullable
    public Long failcnt() {
        return this.failcnt;
    }

    @Override
    @JsonProperty(value="limit")
    @Nullable
    public Long limit() {
        return this.limit;
    }

    public final ImmutableMemoryStats withStats(@Nullable MemoryStats.Stats value) {
        if (this.stats == value) {
            return this;
        }
        return new ImmutableMemoryStats(value, this.maxUsage, this.usage, this.failcnt, this.limit);
    }

    public final ImmutableMemoryStats withMaxUsage(@Nullable Long value) {
        if (Objects.equals(this.maxUsage, value)) {
            return this;
        }
        return new ImmutableMemoryStats(this.stats, value, this.usage, this.failcnt, this.limit);
    }

    public final ImmutableMemoryStats withUsage(@Nullable Long value) {
        if (Objects.equals(this.usage, value)) {
            return this;
        }
        return new ImmutableMemoryStats(this.stats, this.maxUsage, value, this.failcnt, this.limit);
    }

    public final ImmutableMemoryStats withFailcnt(@Nullable Long value) {
        if (Objects.equals(this.failcnt, value)) {
            return this;
        }
        return new ImmutableMemoryStats(this.stats, this.maxUsage, this.usage, value, this.limit);
    }

    public final ImmutableMemoryStats withLimit(@Nullable Long value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableMemoryStats(this.stats, this.maxUsage, this.usage, this.failcnt, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMemoryStats && this.equalsByValue((ImmutableMemoryStats)another);
    }

    private boolean equalsByValue(ImmutableMemoryStats another) {
        return Objects.equals(this.stats, another.stats) && Objects.equals(this.maxUsage, another.maxUsage) && Objects.equals(this.usage, another.usage) && Objects.equals(this.failcnt, another.failcnt) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.stats);
        h += (h << 5) + Objects.hashCode(this.maxUsage);
        h += (h << 5) + Objects.hashCode(this.usage);
        h += (h << 5) + Objects.hashCode(this.failcnt);
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        return "MemoryStats{stats=" + String.valueOf(this.stats) + ", maxUsage=" + this.maxUsage + ", usage=" + this.usage + ", failcnt=" + this.failcnt + ", limit=" + this.limit + "}";
    }

    public static ImmutableMemoryStats copyOf(MemoryStats instance) {
        if (instance instanceof ImmutableMemoryStats) {
            return (ImmutableMemoryStats)instance;
        }
        return ImmutableMemoryStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private MemoryStats.Stats stats;
        private Long maxUsage;
        private Long usage;
        private Long failcnt;
        private Long limit;

        private Builder() {
        }

        public final Builder from(MemoryStats instance) {
            Long limitValue;
            Long failcntValue;
            Long usageValue;
            Long maxUsageValue;
            Objects.requireNonNull(instance, "instance");
            MemoryStats.Stats statsValue = instance.stats();
            if (statsValue != null) {
                this.stats(statsValue);
            }
            if ((maxUsageValue = instance.maxUsage()) != null) {
                this.maxUsage(maxUsageValue);
            }
            if ((usageValue = instance.usage()) != null) {
                this.usage(usageValue);
            }
            if ((failcntValue = instance.failcnt()) != null) {
                this.failcnt(failcntValue);
            }
            if ((limitValue = instance.limit()) != null) {
                this.limit(limitValue);
            }
            return this;
        }

        @JsonProperty(value="stats")
        public final Builder stats(@Nullable MemoryStats.Stats stats) {
            this.stats = stats;
            return this;
        }

        @JsonProperty(value="max_usage")
        public final Builder maxUsage(@Nullable Long maxUsage) {
            this.maxUsage = maxUsage;
            return this;
        }

        @JsonProperty(value="usage")
        public final Builder usage(@Nullable Long usage) {
            this.usage = usage;
            return this;
        }

        @JsonProperty(value="failcnt")
        public final Builder failcnt(@Nullable Long failcnt) {
            this.failcnt = failcnt;
            return this;
        }

        @JsonProperty(value="limit")
        public final Builder limit(@Nullable Long limit) {
            this.limit = limit;
            return this;
        }

        public ImmutableMemoryStats build() {
            return new ImmutableMemoryStats(this.stats, this.maxUsage, this.usage, this.failcnt, this.limit);
        }
    }

    static final class Stats
    implements MemoryStats.Stats {
        private final Long activeFile;
        private final Long totalActiveFile;
        private final Long inactiveFile;
        private final Long totalInactiveFile;
        private final Long cache;
        private final Long totalCache;
        private final Long activeAnon;
        private final Long totalActiveAnon;
        private final Long inactiveAnon;
        private final Long totalInactiveAnon;
        private final BigInteger hierarchicalMemoryLimit;
        private final Long mappedFile;
        private final Long totalMappedFile;
        private final Long pgmajfault;
        private final Long totalPgmajfault;
        private final Long pgpgin;
        private final Long totalPgpgin;
        private final Long pgpgout;
        private final Long totalPgpgout;
        private final Long pgfault;
        private final Long totalPgfault;
        private final Long rss;
        private final Long totalRss;
        private final Long rssHuge;
        private final Long totalRssHuge;
        private final Long unevictable;
        private final Long totalUnevictable;
        @Nullable
        private final Long totalWriteback;
        @Nullable
        private final Long writeback;

        private Stats(Long activeFile, Long totalActiveFile, Long inactiveFile, Long totalInactiveFile, Long cache, Long totalCache, Long activeAnon, Long totalActiveAnon, Long inactiveAnon, Long totalInactiveAnon, BigInteger hierarchicalMemoryLimit, Long mappedFile, Long totalMappedFile, Long pgmajfault, Long totalPgmajfault, Long pgpgin, Long totalPgpgin, Long pgpgout, Long totalPgpgout, Long pgfault, Long totalPgfault, Long rss, Long totalRss, Long rssHuge, Long totalRssHuge, Long unevictable, Long totalUnevictable, @Nullable Long totalWriteback, @Nullable Long writeback) {
            this.activeFile = activeFile;
            this.totalActiveFile = totalActiveFile;
            this.inactiveFile = inactiveFile;
            this.totalInactiveFile = totalInactiveFile;
            this.cache = cache;
            this.totalCache = totalCache;
            this.activeAnon = activeAnon;
            this.totalActiveAnon = totalActiveAnon;
            this.inactiveAnon = inactiveAnon;
            this.totalInactiveAnon = totalInactiveAnon;
            this.hierarchicalMemoryLimit = hierarchicalMemoryLimit;
            this.mappedFile = mappedFile;
            this.totalMappedFile = totalMappedFile;
            this.pgmajfault = pgmajfault;
            this.totalPgmajfault = totalPgmajfault;
            this.pgpgin = pgpgin;
            this.totalPgpgin = totalPgpgin;
            this.pgpgout = pgpgout;
            this.totalPgpgout = totalPgpgout;
            this.pgfault = pgfault;
            this.totalPgfault = totalPgfault;
            this.rss = rss;
            this.totalRss = totalRss;
            this.rssHuge = rssHuge;
            this.totalRssHuge = totalRssHuge;
            this.unevictable = unevictable;
            this.totalUnevictable = totalUnevictable;
            this.totalWriteback = totalWriteback;
            this.writeback = writeback;
        }

        @Override
        @JsonProperty(value="active_file")
        public Long activeFile() {
            return this.activeFile;
        }

        @Override
        @JsonProperty(value="total_active_file")
        public Long totalActiveFile() {
            return this.totalActiveFile;
        }

        @Override
        @JsonProperty(value="inactive_file")
        public Long inactiveFile() {
            return this.inactiveFile;
        }

        @Override
        @JsonProperty(value="total_inactive_file")
        public Long totalInactiveFile() {
            return this.totalInactiveFile;
        }

        @Override
        @JsonProperty(value="cache")
        public Long cache() {
            return this.cache;
        }

        @Override
        @JsonProperty(value="total_cache")
        public Long totalCache() {
            return this.totalCache;
        }

        @Override
        @JsonProperty(value="active_anon")
        public Long activeAnon() {
            return this.activeAnon;
        }

        @Override
        @JsonProperty(value="total_active_anon")
        public Long totalActiveAnon() {
            return this.totalActiveAnon;
        }

        @Override
        @JsonProperty(value="inactive_anon")
        public Long inactiveAnon() {
            return this.inactiveAnon;
        }

        @Override
        @JsonProperty(value="total_inactive_anon")
        public Long totalInactiveAnon() {
            return this.totalInactiveAnon;
        }

        @Override
        @JsonProperty(value="hierarchical_memory_limit")
        public BigInteger hierarchicalMemoryLimit() {
            return this.hierarchicalMemoryLimit;
        }

        @Override
        @JsonProperty(value="mapped_file")
        public Long mappedFile() {
            return this.mappedFile;
        }

        @Override
        @JsonProperty(value="total_mapped_file")
        public Long totalMappedFile() {
            return this.totalMappedFile;
        }

        @Override
        @JsonProperty(value="pgmajfault")
        public Long pgmajfault() {
            return this.pgmajfault;
        }

        @Override
        @JsonProperty(value="total_pgmajfault")
        public Long totalPgmajfault() {
            return this.totalPgmajfault;
        }

        @Override
        @JsonProperty(value="pgpgin")
        public Long pgpgin() {
            return this.pgpgin;
        }

        @Override
        @JsonProperty(value="total_pgpgin")
        public Long totalPgpgin() {
            return this.totalPgpgin;
        }

        @Override
        @JsonProperty(value="pgpgout")
        public Long pgpgout() {
            return this.pgpgout;
        }

        @Override
        @JsonProperty(value="total_pgpgout")
        public Long totalPgpgout() {
            return this.totalPgpgout;
        }

        @Override
        @JsonProperty(value="pgfault")
        public Long pgfault() {
            return this.pgfault;
        }

        @Override
        @JsonProperty(value="total_pgfault")
        public Long totalPgfault() {
            return this.totalPgfault;
        }

        @Override
        @JsonProperty(value="rss")
        public Long rss() {
            return this.rss;
        }

        @Override
        @JsonProperty(value="total_rss")
        public Long totalRss() {
            return this.totalRss;
        }

        @Override
        @JsonProperty(value="rss_huge")
        public Long rssHuge() {
            return this.rssHuge;
        }

        @Override
        @JsonProperty(value="total_rss_huge")
        public Long totalRssHuge() {
            return this.totalRssHuge;
        }

        @Override
        @JsonProperty(value="unevictable")
        public Long unevictable() {
            return this.unevictable;
        }

        @Override
        @JsonProperty(value="total_unevictable")
        public Long totalUnevictable() {
            return this.totalUnevictable;
        }

        @Override
        @JsonProperty(value="total_writeback")
        @Nullable
        public Long totalWriteback() {
            return this.totalWriteback;
        }

        @Override
        @JsonProperty(value="writeback")
        @Nullable
        public Long writeback() {
            return this.writeback;
        }

        public final Stats withActiveFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "activeFile");
            if (this.activeFile.equals(newValue)) {
                return this;
            }
            return new Stats(newValue, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalActiveFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalActiveFile");
            if (this.totalActiveFile.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, newValue, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withInactiveFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "inactiveFile");
            if (this.inactiveFile.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, newValue, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalInactiveFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalInactiveFile");
            if (this.totalInactiveFile.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, newValue, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withCache(Long value) {
            Long newValue = Objects.requireNonNull(value, "cache");
            if (this.cache.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, newValue, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalCache(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalCache");
            if (this.totalCache.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, newValue, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withActiveAnon(Long value) {
            Long newValue = Objects.requireNonNull(value, "activeAnon");
            if (this.activeAnon.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, newValue, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalActiveAnon(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalActiveAnon");
            if (this.totalActiveAnon.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, newValue, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withInactiveAnon(Long value) {
            Long newValue = Objects.requireNonNull(value, "inactiveAnon");
            if (this.inactiveAnon.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, newValue, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalInactiveAnon(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalInactiveAnon");
            if (this.totalInactiveAnon.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, newValue, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withHierarchicalMemoryLimit(BigInteger value) {
            BigInteger newValue = Objects.requireNonNull(value, "hierarchicalMemoryLimit");
            if (this.hierarchicalMemoryLimit.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, newValue, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withMappedFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "mappedFile");
            if (this.mappedFile.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, newValue, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalMappedFile(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalMappedFile");
            if (this.totalMappedFile.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, newValue, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withPgmajfault(Long value) {
            Long newValue = Objects.requireNonNull(value, "pgmajfault");
            if (this.pgmajfault.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, newValue, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalPgmajfault(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalPgmajfault");
            if (this.totalPgmajfault.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, newValue, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withPgpgin(Long value) {
            Long newValue = Objects.requireNonNull(value, "pgpgin");
            if (this.pgpgin.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, newValue, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalPgpgin(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalPgpgin");
            if (this.totalPgpgin.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, newValue, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withPgpgout(Long value) {
            Long newValue = Objects.requireNonNull(value, "pgpgout");
            if (this.pgpgout.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, newValue, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalPgpgout(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalPgpgout");
            if (this.totalPgpgout.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, newValue, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withPgfault(Long value) {
            Long newValue = Objects.requireNonNull(value, "pgfault");
            if (this.pgfault.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, newValue, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalPgfault(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalPgfault");
            if (this.totalPgfault.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, newValue, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withRss(Long value) {
            Long newValue = Objects.requireNonNull(value, "rss");
            if (this.rss.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, newValue, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalRss(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalRss");
            if (this.totalRss.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, newValue, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withRssHuge(Long value) {
            Long newValue = Objects.requireNonNull(value, "rssHuge");
            if (this.rssHuge.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, newValue, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalRssHuge(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalRssHuge");
            if (this.totalRssHuge.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, newValue, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withUnevictable(Long value) {
            Long newValue = Objects.requireNonNull(value, "unevictable");
            if (this.unevictable.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, newValue, this.totalUnevictable, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalUnevictable(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalUnevictable");
            if (this.totalUnevictable.equals(newValue)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, newValue, this.totalWriteback, this.writeback);
        }

        public final Stats withTotalWriteback(@Nullable Long value) {
            if (Objects.equals(this.totalWriteback, value)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, value, this.writeback);
        }

        public final Stats withWriteback(@Nullable Long value) {
            if (Objects.equals(this.writeback, value)) {
                return this;
            }
            return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Stats && this.equalsByValue((Stats)another);
        }

        private boolean equalsByValue(Stats another) {
            return this.activeFile.equals(another.activeFile) && this.totalActiveFile.equals(another.totalActiveFile) && this.inactiveFile.equals(another.inactiveFile) && this.totalInactiveFile.equals(another.totalInactiveFile) && this.cache.equals(another.cache) && this.totalCache.equals(another.totalCache) && this.activeAnon.equals(another.activeAnon) && this.totalActiveAnon.equals(another.totalActiveAnon) && this.inactiveAnon.equals(another.inactiveAnon) && this.totalInactiveAnon.equals(another.totalInactiveAnon) && this.hierarchicalMemoryLimit.equals(another.hierarchicalMemoryLimit) && this.mappedFile.equals(another.mappedFile) && this.totalMappedFile.equals(another.totalMappedFile) && this.pgmajfault.equals(another.pgmajfault) && this.totalPgmajfault.equals(another.totalPgmajfault) && this.pgpgin.equals(another.pgpgin) && this.totalPgpgin.equals(another.totalPgpgin) && this.pgpgout.equals(another.pgpgout) && this.totalPgpgout.equals(another.totalPgpgout) && this.pgfault.equals(another.pgfault) && this.totalPgfault.equals(another.totalPgfault) && this.rss.equals(another.rss) && this.totalRss.equals(another.totalRss) && this.rssHuge.equals(another.rssHuge) && this.totalRssHuge.equals(another.totalRssHuge) && this.unevictable.equals(another.unevictable) && this.totalUnevictable.equals(another.totalUnevictable) && Objects.equals(this.totalWriteback, another.totalWriteback) && Objects.equals(this.writeback, another.writeback);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.activeFile.hashCode();
            h += (h << 5) + this.totalActiveFile.hashCode();
            h += (h << 5) + this.inactiveFile.hashCode();
            h += (h << 5) + this.totalInactiveFile.hashCode();
            h += (h << 5) + this.cache.hashCode();
            h += (h << 5) + this.totalCache.hashCode();
            h += (h << 5) + this.activeAnon.hashCode();
            h += (h << 5) + this.totalActiveAnon.hashCode();
            h += (h << 5) + this.inactiveAnon.hashCode();
            h += (h << 5) + this.totalInactiveAnon.hashCode();
            h += (h << 5) + this.hierarchicalMemoryLimit.hashCode();
            h += (h << 5) + this.mappedFile.hashCode();
            h += (h << 5) + this.totalMappedFile.hashCode();
            h += (h << 5) + this.pgmajfault.hashCode();
            h += (h << 5) + this.totalPgmajfault.hashCode();
            h += (h << 5) + this.pgpgin.hashCode();
            h += (h << 5) + this.totalPgpgin.hashCode();
            h += (h << 5) + this.pgpgout.hashCode();
            h += (h << 5) + this.totalPgpgout.hashCode();
            h += (h << 5) + this.pgfault.hashCode();
            h += (h << 5) + this.totalPgfault.hashCode();
            h += (h << 5) + this.rss.hashCode();
            h += (h << 5) + this.totalRss.hashCode();
            h += (h << 5) + this.rssHuge.hashCode();
            h += (h << 5) + this.totalRssHuge.hashCode();
            h += (h << 5) + this.unevictable.hashCode();
            h += (h << 5) + this.totalUnevictable.hashCode();
            h += (h << 5) + Objects.hashCode(this.totalWriteback);
            h += (h << 5) + Objects.hashCode(this.writeback);
            return h;
        }

        public String toString() {
            return "Stats{activeFile=" + this.activeFile + ", totalActiveFile=" + this.totalActiveFile + ", inactiveFile=" + this.inactiveFile + ", totalInactiveFile=" + this.totalInactiveFile + ", cache=" + this.cache + ", totalCache=" + this.totalCache + ", activeAnon=" + this.activeAnon + ", totalActiveAnon=" + this.totalActiveAnon + ", inactiveAnon=" + this.inactiveAnon + ", totalInactiveAnon=" + this.totalInactiveAnon + ", hierarchicalMemoryLimit=" + String.valueOf(this.hierarchicalMemoryLimit) + ", mappedFile=" + this.mappedFile + ", totalMappedFile=" + this.totalMappedFile + ", pgmajfault=" + this.pgmajfault + ", totalPgmajfault=" + this.totalPgmajfault + ", pgpgin=" + this.pgpgin + ", totalPgpgin=" + this.totalPgpgin + ", pgpgout=" + this.pgpgout + ", totalPgpgout=" + this.totalPgpgout + ", pgfault=" + this.pgfault + ", totalPgfault=" + this.totalPgfault + ", rss=" + this.rss + ", totalRss=" + this.totalRss + ", rssHuge=" + this.rssHuge + ", totalRssHuge=" + this.totalRssHuge + ", unevictable=" + this.unevictable + ", totalUnevictable=" + this.totalUnevictable + ", totalWriteback=" + this.totalWriteback + ", writeback=" + this.writeback + "}";
        }

        public static Stats copyOf(MemoryStats.Stats instance) {
            if (instance instanceof Stats) {
                return (Stats)instance;
            }
            return Stats.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_ACTIVE_FILE = 1L;
            private static final long INIT_BIT_TOTAL_ACTIVE_FILE = 2L;
            private static final long INIT_BIT_INACTIVE_FILE = 4L;
            private static final long INIT_BIT_TOTAL_INACTIVE_FILE = 8L;
            private static final long INIT_BIT_CACHE = 16L;
            private static final long INIT_BIT_TOTAL_CACHE = 32L;
            private static final long INIT_BIT_ACTIVE_ANON = 64L;
            private static final long INIT_BIT_TOTAL_ACTIVE_ANON = 128L;
            private static final long INIT_BIT_INACTIVE_ANON = 256L;
            private static final long INIT_BIT_TOTAL_INACTIVE_ANON = 512L;
            private static final long INIT_BIT_HIERARCHICAL_MEMORY_LIMIT = 1024L;
            private static final long INIT_BIT_MAPPED_FILE = 2048L;
            private static final long INIT_BIT_TOTAL_MAPPED_FILE = 4096L;
            private static final long INIT_BIT_PGMAJFAULT = 8192L;
            private static final long INIT_BIT_TOTAL_PGMAJFAULT = 16384L;
            private static final long INIT_BIT_PGPGIN = 32768L;
            private static final long INIT_BIT_TOTAL_PGPGIN = 65536L;
            private static final long INIT_BIT_PGPGOUT = 131072L;
            private static final long INIT_BIT_TOTAL_PGPGOUT = 262144L;
            private static final long INIT_BIT_PGFAULT = 524288L;
            private static final long INIT_BIT_TOTAL_PGFAULT = 0x100000L;
            private static final long INIT_BIT_RSS = 0x200000L;
            private static final long INIT_BIT_TOTAL_RSS = 0x400000L;
            private static final long INIT_BIT_RSS_HUGE = 0x800000L;
            private static final long INIT_BIT_TOTAL_RSS_HUGE = 0x1000000L;
            private static final long INIT_BIT_UNEVICTABLE = 0x2000000L;
            private static final long INIT_BIT_TOTAL_UNEVICTABLE = 0x4000000L;
            private long initBits = 0x7FFFFFFL;
            private Long activeFile;
            private Long totalActiveFile;
            private Long inactiveFile;
            private Long totalInactiveFile;
            private Long cache;
            private Long totalCache;
            private Long activeAnon;
            private Long totalActiveAnon;
            private Long inactiveAnon;
            private Long totalInactiveAnon;
            private BigInteger hierarchicalMemoryLimit;
            private Long mappedFile;
            private Long totalMappedFile;
            private Long pgmajfault;
            private Long totalPgmajfault;
            private Long pgpgin;
            private Long totalPgpgin;
            private Long pgpgout;
            private Long totalPgpgout;
            private Long pgfault;
            private Long totalPgfault;
            private Long rss;
            private Long totalRss;
            private Long rssHuge;
            private Long totalRssHuge;
            private Long unevictable;
            private Long totalUnevictable;
            private Long totalWriteback;
            private Long writeback;

            private Builder() {
            }

            public final Builder from(MemoryStats.Stats instance) {
                Long writebackValue;
                Objects.requireNonNull(instance, "instance");
                this.activeFile(instance.activeFile());
                this.totalActiveFile(instance.totalActiveFile());
                this.inactiveFile(instance.inactiveFile());
                this.totalInactiveFile(instance.totalInactiveFile());
                this.cache(instance.cache());
                this.totalCache(instance.totalCache());
                this.activeAnon(instance.activeAnon());
                this.totalActiveAnon(instance.totalActiveAnon());
                this.inactiveAnon(instance.inactiveAnon());
                this.totalInactiveAnon(instance.totalInactiveAnon());
                this.hierarchicalMemoryLimit(instance.hierarchicalMemoryLimit());
                this.mappedFile(instance.mappedFile());
                this.totalMappedFile(instance.totalMappedFile());
                this.pgmajfault(instance.pgmajfault());
                this.totalPgmajfault(instance.totalPgmajfault());
                this.pgpgin(instance.pgpgin());
                this.totalPgpgin(instance.totalPgpgin());
                this.pgpgout(instance.pgpgout());
                this.totalPgpgout(instance.totalPgpgout());
                this.pgfault(instance.pgfault());
                this.totalPgfault(instance.totalPgfault());
                this.rss(instance.rss());
                this.totalRss(instance.totalRss());
                this.rssHuge(instance.rssHuge());
                this.totalRssHuge(instance.totalRssHuge());
                this.unevictable(instance.unevictable());
                this.totalUnevictable(instance.totalUnevictable());
                Long totalWritebackValue = instance.totalWriteback();
                if (totalWritebackValue != null) {
                    this.totalWriteback(totalWritebackValue);
                }
                if ((writebackValue = instance.writeback()) != null) {
                    this.writeback(writebackValue);
                }
                return this;
            }

            @JsonProperty(value="active_file")
            public final Builder activeFile(Long activeFile) {
                this.activeFile = Objects.requireNonNull(activeFile, "activeFile");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="total_active_file")
            public final Builder totalActiveFile(Long totalActiveFile) {
                this.totalActiveFile = Objects.requireNonNull(totalActiveFile, "totalActiveFile");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="inactive_file")
            public final Builder inactiveFile(Long inactiveFile) {
                this.inactiveFile = Objects.requireNonNull(inactiveFile, "inactiveFile");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @JsonProperty(value="total_inactive_file")
            public final Builder totalInactiveFile(Long totalInactiveFile) {
                this.totalInactiveFile = Objects.requireNonNull(totalInactiveFile, "totalInactiveFile");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @JsonProperty(value="cache")
            public final Builder cache(Long cache) {
                this.cache = Objects.requireNonNull(cache, "cache");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @JsonProperty(value="total_cache")
            public final Builder totalCache(Long totalCache) {
                this.totalCache = Objects.requireNonNull(totalCache, "totalCache");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            @JsonProperty(value="active_anon")
            public final Builder activeAnon(Long activeAnon) {
                this.activeAnon = Objects.requireNonNull(activeAnon, "activeAnon");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            @JsonProperty(value="total_active_anon")
            public final Builder totalActiveAnon(Long totalActiveAnon) {
                this.totalActiveAnon = Objects.requireNonNull(totalActiveAnon, "totalActiveAnon");
                this.initBits &= 0xFFFFFFFFFFFFFF7FL;
                return this;
            }

            @JsonProperty(value="inactive_anon")
            public final Builder inactiveAnon(Long inactiveAnon) {
                this.inactiveAnon = Objects.requireNonNull(inactiveAnon, "inactiveAnon");
                this.initBits &= 0xFFFFFFFFFFFFFEFFL;
                return this;
            }

            @JsonProperty(value="total_inactive_anon")
            public final Builder totalInactiveAnon(Long totalInactiveAnon) {
                this.totalInactiveAnon = Objects.requireNonNull(totalInactiveAnon, "totalInactiveAnon");
                this.initBits &= 0xFFFFFFFFFFFFFDFFL;
                return this;
            }

            @JsonProperty(value="hierarchical_memory_limit")
            public final Builder hierarchicalMemoryLimit(BigInteger hierarchicalMemoryLimit) {
                this.hierarchicalMemoryLimit = Objects.requireNonNull(hierarchicalMemoryLimit, "hierarchicalMemoryLimit");
                this.initBits &= 0xFFFFFFFFFFFFFBFFL;
                return this;
            }

            @JsonProperty(value="mapped_file")
            public final Builder mappedFile(Long mappedFile) {
                this.mappedFile = Objects.requireNonNull(mappedFile, "mappedFile");
                this.initBits &= 0xFFFFFFFFFFFFF7FFL;
                return this;
            }

            @JsonProperty(value="total_mapped_file")
            public final Builder totalMappedFile(Long totalMappedFile) {
                this.totalMappedFile = Objects.requireNonNull(totalMappedFile, "totalMappedFile");
                this.initBits &= 0xFFFFFFFFFFFFEFFFL;
                return this;
            }

            @JsonProperty(value="pgmajfault")
            public final Builder pgmajfault(Long pgmajfault) {
                this.pgmajfault = Objects.requireNonNull(pgmajfault, "pgmajfault");
                this.initBits &= 0xFFFFFFFFFFFFDFFFL;
                return this;
            }

            @JsonProperty(value="total_pgmajfault")
            public final Builder totalPgmajfault(Long totalPgmajfault) {
                this.totalPgmajfault = Objects.requireNonNull(totalPgmajfault, "totalPgmajfault");
                this.initBits &= 0xFFFFFFFFFFFFBFFFL;
                return this;
            }

            @JsonProperty(value="pgpgin")
            public final Builder pgpgin(Long pgpgin) {
                this.pgpgin = Objects.requireNonNull(pgpgin, "pgpgin");
                this.initBits &= 0xFFFFFFFFFFFF7FFFL;
                return this;
            }

            @JsonProperty(value="total_pgpgin")
            public final Builder totalPgpgin(Long totalPgpgin) {
                this.totalPgpgin = Objects.requireNonNull(totalPgpgin, "totalPgpgin");
                this.initBits &= 0xFFFFFFFFFFFEFFFFL;
                return this;
            }

            @JsonProperty(value="pgpgout")
            public final Builder pgpgout(Long pgpgout) {
                this.pgpgout = Objects.requireNonNull(pgpgout, "pgpgout");
                this.initBits &= 0xFFFFFFFFFFFDFFFFL;
                return this;
            }

            @JsonProperty(value="total_pgpgout")
            public final Builder totalPgpgout(Long totalPgpgout) {
                this.totalPgpgout = Objects.requireNonNull(totalPgpgout, "totalPgpgout");
                this.initBits &= 0xFFFFFFFFFFFBFFFFL;
                return this;
            }

            @JsonProperty(value="pgfault")
            public final Builder pgfault(Long pgfault) {
                this.pgfault = Objects.requireNonNull(pgfault, "pgfault");
                this.initBits &= 0xFFFFFFFFFFF7FFFFL;
                return this;
            }

            @JsonProperty(value="total_pgfault")
            public final Builder totalPgfault(Long totalPgfault) {
                this.totalPgfault = Objects.requireNonNull(totalPgfault, "totalPgfault");
                this.initBits &= 0xFFFFFFFFFFEFFFFFL;
                return this;
            }

            @JsonProperty(value="rss")
            public final Builder rss(Long rss) {
                this.rss = Objects.requireNonNull(rss, "rss");
                this.initBits &= 0xFFFFFFFFFFDFFFFFL;
                return this;
            }

            @JsonProperty(value="total_rss")
            public final Builder totalRss(Long totalRss) {
                this.totalRss = Objects.requireNonNull(totalRss, "totalRss");
                this.initBits &= 0xFFFFFFFFFFBFFFFFL;
                return this;
            }

            @JsonProperty(value="rss_huge")
            public final Builder rssHuge(Long rssHuge) {
                this.rssHuge = Objects.requireNonNull(rssHuge, "rssHuge");
                this.initBits &= 0xFFFFFFFFFF7FFFFFL;
                return this;
            }

            @JsonProperty(value="total_rss_huge")
            public final Builder totalRssHuge(Long totalRssHuge) {
                this.totalRssHuge = Objects.requireNonNull(totalRssHuge, "totalRssHuge");
                this.initBits &= 0xFFFFFFFFFEFFFFFFL;
                return this;
            }

            @JsonProperty(value="unevictable")
            public final Builder unevictable(Long unevictable) {
                this.unevictable = Objects.requireNonNull(unevictable, "unevictable");
                this.initBits &= 0xFFFFFFFFFDFFFFFFL;
                return this;
            }

            @JsonProperty(value="total_unevictable")
            public final Builder totalUnevictable(Long totalUnevictable) {
                this.totalUnevictable = Objects.requireNonNull(totalUnevictable, "totalUnevictable");
                this.initBits &= 0xFFFFFFFFFBFFFFFFL;
                return this;
            }

            @JsonProperty(value="total_writeback")
            public final Builder totalWriteback(@Nullable Long totalWriteback) {
                this.totalWriteback = totalWriteback;
                return this;
            }

            @JsonProperty(value="writeback")
            public final Builder writeback(@Nullable Long writeback) {
                this.writeback = writeback;
                return this;
            }

            public Stats build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Stats(this.activeFile, this.totalActiveFile, this.inactiveFile, this.totalInactiveFile, this.cache, this.totalCache, this.activeAnon, this.totalActiveAnon, this.inactiveAnon, this.totalInactiveAnon, this.hierarchicalMemoryLimit, this.mappedFile, this.totalMappedFile, this.pgmajfault, this.totalPgmajfault, this.pgpgin, this.totalPgpgin, this.pgpgout, this.totalPgpgout, this.pgfault, this.totalPgfault, this.rss, this.totalRss, this.rssHuge, this.totalRssHuge, this.unevictable, this.totalUnevictable, this.totalWriteback, this.writeback);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("activeFile");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("totalActiveFile");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("inactiveFile");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("totalInactiveFile");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("cache");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("totalCache");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("activeAnon");
                }
                if ((this.initBits & 0x80L) != 0L) {
                    attributes.add("totalActiveAnon");
                }
                if ((this.initBits & 0x100L) != 0L) {
                    attributes.add("inactiveAnon");
                }
                if ((this.initBits & 0x200L) != 0L) {
                    attributes.add("totalInactiveAnon");
                }
                if ((this.initBits & 0x400L) != 0L) {
                    attributes.add("hierarchicalMemoryLimit");
                }
                if ((this.initBits & 0x800L) != 0L) {
                    attributes.add("mappedFile");
                }
                if ((this.initBits & 0x1000L) != 0L) {
                    attributes.add("totalMappedFile");
                }
                if ((this.initBits & 0x2000L) != 0L) {
                    attributes.add("pgmajfault");
                }
                if ((this.initBits & 0x4000L) != 0L) {
                    attributes.add("totalPgmajfault");
                }
                if ((this.initBits & 0x8000L) != 0L) {
                    attributes.add("pgpgin");
                }
                if ((this.initBits & 0x10000L) != 0L) {
                    attributes.add("totalPgpgin");
                }
                if ((this.initBits & 0x20000L) != 0L) {
                    attributes.add("pgpgout");
                }
                if ((this.initBits & 0x40000L) != 0L) {
                    attributes.add("totalPgpgout");
                }
                if ((this.initBits & 0x80000L) != 0L) {
                    attributes.add("pgfault");
                }
                if ((this.initBits & 0x100000L) != 0L) {
                    attributes.add("totalPgfault");
                }
                if ((this.initBits & 0x200000L) != 0L) {
                    attributes.add("rss");
                }
                if ((this.initBits & 0x400000L) != 0L) {
                    attributes.add("totalRss");
                }
                if ((this.initBits & 0x800000L) != 0L) {
                    attributes.add("rssHuge");
                }
                if ((this.initBits & 0x1000000L) != 0L) {
                    attributes.add("totalRssHuge");
                }
                if ((this.initBits & 0x2000000L) != 0L) {
                    attributes.add("unevictable");
                }
                if ((this.initBits & 0x4000000L) != 0L) {
                    attributes.add("totalUnevictable");
                }
                return "Cannot build Stats, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

