/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import java.util.List;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.model.NodeDataModel;

public class CircularSeriesData
extends SeriesData
implements ICircularSeriesData {
    public static final String ID = "Circular Series";
    private NodeDataModel nodeDataModel;
    private Node rootNode;
    private ICircularSeriesSettings seriesSettings;
    private String nodeClass;
    private String valueClass;

    public CircularSeriesData() {
        super(new double[0], new double[0], ID);
        this.nodeDataModel = new NodeDataModel();
        this.rootNode = this.nodeDataModel.getRootNode();
        this.seriesSettings = new CircularSeriesSettings();
        this.nodeClass = "Node";
        this.valueClass = "Value";
    }

    public CircularSeriesData(ICircularSeriesData seriesData) {
        super(new double[0], new double[0], ID);
        this.seriesSettings = new CircularSeriesSettings();
        this.seriesSettings.setDescription(seriesData.getTitle());
    }

    @Override
    public String getTitle() {
        return this.nodeDataModel.getId();
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        int length = labels.length;
        int cfr_ignored_0 = values.length;
        int i = 0;
        while (i != length) {
            new Node(labels[i], values[i], this.rootNode);
            ++i;
        }
        this.nodeDataModel.update();
    }

    @Override
    public List<Node> getSeries() {
        return this.rootNode.getChildren();
    }

    @Override
    public NodeDataModel getDataModel() {
        return this.nodeDataModel;
    }

    @Override
    public void setDataModel(NodeDataModel data) {
        this.nodeDataModel = data;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Node getNodeById(String id) {
        return this.nodeDataModel.getNodeById(id);
    }

    @Override
    public ICircularSeriesSettings getSettings() {
        return this.seriesSettings;
    }

    @Override
    public void setTitle(String id) {
        this.nodeDataModel.setId(id);
    }

    @Override
    public String getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public void setNodeClass(String nodeClass) {
        this.nodeClass = nodeClass;
    }

    @Override
    public String getValueClass() {
        return this.valueClass;
    }

    @Override
    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
    }
}

