/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class MoveResourceChange
extends ResourceChange {
    private final IResource fSource;
    private final IContainer fTarget;
    private final long fStampToRestore;
    private final Change fRestoreSourceChange;
    private ChangeDescriptor fDescriptor;

    public MoveResourceChange(IResource source, IContainer target) {
        this(source, target, -1L, null);
    }

    protected MoveResourceChange(IResource source, IContainer target, long stampToRestore, Change restoreSourceChange) {
        this.fSource = source;
        this.fTarget = target;
        this.fStampToRestore = stampToRestore;
        this.fRestoreSourceChange = restoreSourceChange;
        this.setValidationMethod(2);
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    @Override
    public final Change perform(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)4);
        Change deleteUndo = null;
        IResource resourceAtDestination = this.fTarget.findMember(this.fSource.getName());
        if (resourceAtDestination != null && resourceAtDestination.exists()) {
            deleteUndo = this.performDestinationDelete(resourceAtDestination, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.worked(1);
        }
        long currentStamp = this.fSource.getModificationStamp();
        IPath destinationPath = this.fTarget.getFullPath().append(this.fSource.getName());
        this.fSource.move(destinationPath, 34, (IProgressMonitor)subMonitor.newChild(2));
        resourceAtDestination = ResourcesPlugin.getWorkspace().getRoot().findMember(destinationPath);
        if (this.fStampToRestore != -1L) {
            resourceAtDestination.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fRestoreSourceChange != null) {
            this.performSourceRestore((IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.worked(1);
        }
        return new MoveResourceChange(resourceAtDestination, this.fSource.getParent(), currentStamp, deleteUndo);
    }

    private Change performDestinationDelete(IResource newResource, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.MoveResourceChange_progress_delete_destination, (int)3);
        DeleteResourceChange deleteChange = new DeleteResourceChange(newResource.getFullPath(), true);
        deleteChange.initializeValidationData((IProgressMonitor)subMonitor.newChild(1));
        RefactoringStatus deleteStatus = deleteChange.isValid((IProgressMonitor)subMonitor.newChild(1));
        if (!deleteStatus.hasFatalError()) {
            return deleteChange.perform((IProgressMonitor)subMonitor.newChild(1));
        }
        return null;
    }

    private void performSourceRestore(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.MoveResourceChange_progress_restore_source, (int)3);
        this.fRestoreSourceChange.initializeValidationData((IProgressMonitor)subMonitor.newChild(1));
        RefactoringStatus restoreStatus = this.fRestoreSourceChange.isValid((IProgressMonitor)subMonitor.newChild(1));
        if (!restoreStatus.hasFatalError()) {
            this.fRestoreSourceChange.perform((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    @Override
    protected IResource getModifiedResource() {
        return this.fSource;
    }

    @Override
    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveResourceChange_name, new String[]{BasicElementLabels.getPathLabel(this.fSource.getFullPath(), false), BasicElementLabels.getResourceName((IResource)this.fTarget)});
    }
}

