/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.utils;

import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.utils.LibhoverInfoGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CXmlLibhoverGen
extends LibhoverInfoGenerator {
    public CXmlLibhoverGen(Document document) {
        this.document = document;
    }

    private FunctionInfo getFunctionInfoFromNode(String name, Node functionNode, Document document) {
        FunctionInfo f = new FunctionInfo(name);
        NamedNodeMap functionNodeMap = functionNode.getAttributes();
        Node functionNodeReturntypeNode = functionNodeMap.item(0);
        String functionNodeRtName = functionNodeReturntypeNode.getNodeName();
        if (functionNodeRtName.equals("returntype")) {
            String functionNodeRtValue = functionNodeReturntypeNode.getNodeValue();
            f.setReturnType(functionNodeRtValue);
        }
        NodeList kids = functionNode.getChildNodes();
        for (int fnk = 0; fnk < kids.getLength(); ++fnk) {
            Node kid = kids.item(fnk);
            String kidName = kid.getNodeName();
            if (kidName.equals("prototype")) {
                String prototype = null;
                NodeList parms = kid.getChildNodes();
                for (int fnp = 0; fnp < parms.getLength(); ++fnp) {
                    Node parm = parms.item(fnp);
                    String parmName = parm.getNodeName();
                    if (!parmName.equals("parameter")) continue;
                    NamedNodeMap parmMap = parm.getAttributes();
                    Node parmNode = parmMap.item(0);
                    String parameter = parmNode.getNodeValue();
                    prototype = null == prototype ? parameter : prototype + ", " + parameter;
                }
                f.setPrototype(prototype);
                continue;
            }
            if (kidName.equals("headers")) {
                NodeList headers = kid.getChildNodes();
                for (int fnh = 0; fnh < headers.getLength(); ++fnh) {
                    Node header = headers.item(fnh);
                    String headerName = header.getNodeName();
                    if (!headerName.equals("header")) continue;
                    NamedNodeMap headerMap = header.getAttributes();
                    Node headerNode = headerMap.item(0);
                    f.addHeader(headerNode.getNodeValue());
                }
                continue;
            }
            if (kidName.equals("groupsynopsis")) {
                NodeList synopsisNode;
                Element elem2;
                NamedNodeMap attr = kid.getAttributes();
                Node idnode = attr.getNamedItem("id");
                String id = idnode.getNodeValue();
                if (id == null || null == (elem2 = document.getElementById(id)) || null == (synopsisNode = elem2.getElementsByTagName("synopsis")) || synopsisNode.getLength() <= 0) continue;
                Node synopsis = synopsisNode.item(0);
                Node textNode = synopsis.getLastChild();
                f.setDescription(textNode.getNodeValue());
                continue;
            }
            if (!kidName.equals("synopsis")) continue;
            Node textNode = kid.getLastChild();
            f.setDescription(textNode.getNodeValue());
        }
        return f;
    }

    @Override
    protected LibHoverInfo doGenerate() {
        LibHoverInfo hoverInfo = new LibHoverInfo();
        NodeList nl = this.document.getElementsByTagName("construct");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NamedNodeMap m = n.getAttributes();
            Node id = m.getNamedItem("id");
            if (id == null || !id.getNodeValue().startsWith("function-")) continue;
            String name = id.getNodeValue().substring(9);
            NodeList nl2 = n.getChildNodes();
            for (int j = 0; j < nl2.getLength(); ++j) {
                Node n2 = nl2.item(j);
                if (!n2.getNodeName().equals("function")) continue;
                FunctionInfo f = this.getFunctionInfoFromNode(name, n2, this.document);
                hoverInfo.functions.put(name, f);
            }
        }
        return hoverInfo;
    }
}

