/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.ui.memory.traditional.IMemorySpacePreferencesHelper;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class MemorySpacePreferencesHelper
implements IMemorySpacePreferencesHelper {
    private final IPreferenceStore fStore = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
    private static final String[] fColorPool = new String[]{"238,192,192", "250,238,195", "255,179,0", "122,245,0", "184,242,255", "166,189,215", "206,162,98", "245,138,157", "244,200,0", "255,136,56", "244,255,128"};

    private String[] getMemorySpaceIds() {
        String csv = this.fStore.getString("memorySpaceIdList");
        return csv.isEmpty() ? new String[]{} : csv.split(",");
    }

    @Override
    public void updateMemorySpaces(String[] ids) {
        ArrayList<String> inputIdList = new ArrayList<String>(Arrays.asList(ids));
        ArrayList<String> knownIdList = new ArrayList<String>(Arrays.asList(this.getMemorySpaceIds()));
        int nextIdIndex = knownIdList.size();
        inputIdList.removeAll(knownIdList);
        boolean newIds = inputIdList.size() > 0;
        for (String id : inputIdList) {
            knownIdList.add(id);
            this.setDefaultColorPreference(id, nextIdIndex);
            ++nextIdIndex;
        }
        if (newIds) {
            this.setMemorySpaceIds(knownIdList.toArray(new String[knownIdList.size()]));
        }
    }

    private void setMemorySpaceIds(String[] memorySpaces) {
        StringBuilder csv = new StringBuilder();
        int i = 0;
        while (i < memorySpaces.length) {
            csv.append(memorySpaces[i]);
            if (i < memorySpaces.length - 1) {
                csv.append(",");
            }
            ++i;
        }
        this.fStore.setValue("memorySpaceIdList", csv.toString());
    }

    @Override
    public String getMemorySpaceKey(String id) {
        return "memoryColorBackgroundMemorySpace-" + id;
    }

    @Override
    public Map<String, String> getMemorySpaceLabels() {
        String prefix = "memoryColorBackgroundMemorySpace-";
        String labelPrefix = TraditionalRenderingMessages.getString("TraditionalRenderingPreferencePage_BackgroundColorMemorySpacePrefix");
        String[] ids = this.getMemorySpaceIds();
        HashMap<String, String> keysToLabels = new HashMap<String, String>();
        int i = 0;
        while (i < ids.length) {
            String key = prefix + ids[i];
            String label = labelPrefix + " " + ids[i];
            keysToLabels.put(key, label);
            ++i;
        }
        return keysToLabels;
    }

    @Override
    public Map<String, String> getMemorySpaceDefaultColors() {
        String prefix = "memoryColorBackgroundMemorySpace-";
        String[] ids = this.getMemorySpaceIds();
        HashMap<String, String> mapKeyToColor = new HashMap<String, String>();
        int i = 0;
        while (i < ids.length) {
            String key = prefix + ids[i];
            String color = this.getColor(i);
            mapKeyToColor.put(key, color);
            ++i;
        }
        return mapKeyToColor;
    }

    private void setDefaultColorPreference(String id, int index) {
        String prefix = "memoryColorBackgroundMemorySpace-";
        String key = prefix + id;
        this.fStore.setValue(key, this.getColor(index));
        this.fStore.setDefault(key, this.getColor(index));
    }

    private String getColor(int index) {
        if (index >= fColorPool.length) {
            index %= fColorPool.length;
        }
        return fColorPool[index];
    }
}

