/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

final class ImplicitsAnalysis {
    private final ICPPClassType classType;
    private boolean hasConstructor;
    private boolean hasCopyConstructor;
    private boolean hasCopyAssignmentOperator;
    private boolean hasDestructor;
    private boolean hasNonStaticFields;

    ImplicitsAnalysis(ICPPASTCompositeTypeSpecifier compositeTypeSpecifier, ICPPClassType classType) {
        this.classType = classType;
        this.analyzeMembers(compositeTypeSpecifier);
    }

    public boolean hasUserDeclaredConstructor() {
        return this.hasConstructor;
    }

    public boolean hasUserDeclaredCopyConstructor() {
        return this.hasCopyConstructor;
    }

    public boolean hasUserDeclaredCopyAssignmentOperator() {
        return this.hasCopyAssignmentOperator;
    }

    public boolean hasUserDeclaredDestructor() {
        return this.hasDestructor;
    }

    public int getImplicitsToDeclareCount() {
        return (!this.hasDestructor ? 1 : 0) + (!this.hasConstructor ? 1 : 0) + (!this.hasCopyConstructor ? 1 : 0) + (!this.hasCopyAssignmentOperator ? 1 : 0);
    }

    private void analyzeMembers(ICPPASTCompositeTypeSpecifier compositeTypeSpecifier) {
        IASTDeclaration[] members = compositeTypeSpecifier.getMembers();
        char[] name = compositeTypeSpecifier.getName().getLookupKey();
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                IASTDeclSpecifier spec;
                IASTDeclarator dcltor;
                block13: {
                    IASTDeclaration member;
                    block11: {
                        member = iASTDeclarationArray[n2];
                        if (member instanceof ICPPASTTemplateDeclaration) {
                            member = ((ICPPASTTemplateDeclaration)member).getDeclaration();
                        }
                        dcltor = null;
                        spec = null;
                        if (!(member instanceof IASTSimpleDeclaration)) break block11;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                        if (dtors.length != 1) break block12;
                        dcltor = dtors[0];
                        spec = ((IASTSimpleDeclaration)member).getDeclSpecifier();
                        break block13;
                    }
                    if (member instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)member).getDeclarator();
                        spec = ((IASTFunctionDefinition)member).getDeclSpecifier();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator) {
                    IASTParameterDeclaration[] params;
                    char[] declName = ASTQueries.findInnermostDeclarator(dcltor).getName().getLookupKey();
                    if (spec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)spec).getType() == 0) {
                        if (CharArrayUtils.equals(declName, name)) {
                            this.hasConstructor = true;
                            params = ((ICPPASTFunctionDeclarator)dcltor).getParameters();
                            if (params.length != 0 && this.hasTypeReferenceToClassType(params[0]) && this.parametersHaveInitializers(params, 1)) {
                                this.hasCopyConstructor = true;
                            }
                        } else if (declName.length != 0 && declName[0] == '~' && CharArrayUtils.equals(declName, 1, name.length, name)) {
                            this.hasDestructor = true;
                        }
                    } else if (CharArrayUtils.equals(declName, OverloadableOperator.ASSIGN.toCharArray()) && (params = ((ICPPASTFunctionDeclarator)dcltor).getParameters()).length == 1 && this.hasTypeReferenceToClassType(params[0])) {
                        this.hasCopyAssignmentOperator = true;
                    }
                    if (this.hasCopyConstructor && this.hasDestructor && this.hasCopyAssignmentOperator) break;
                }
            }
            ++n2;
        }
    }

    private boolean hasTypeReferenceToClassType(IASTParameterDeclaration decl) {
        IType t;
        if (decl instanceof ICPPASTParameterDeclaration && (t = CPPVisitor.createType((ICPPASTParameterDeclaration)decl, false)) != null && (t = SemanticUtil.getNestedType(t, 1)) instanceof ICPPReferenceType && !((ICPPReferenceType)t).isRValueReference()) {
            t = SemanticUtil.getNestedType(t, 13);
            return this.classType.isSameType(t);
        }
        return false;
    }

    private boolean parametersHaveInitializers(IASTParameterDeclaration[] params, int offset) {
        int i = offset;
        while (i < params.length) {
            if (params[i].getDeclarator().getInitializer() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDefaultConstructorConstexpr() {
        ICPPClassType[] baseClasses;
        ICPPBase[] bases;
        if (this.hasNonStaticFields) {
            return false;
        }
        ICPPBase[] iCPPBaseArray = bases = this.classType.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            if (base.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(this.classType);
        int n3 = baseClasses.length;
        n = 0;
        while (n < n3) {
            ICPPClassType baseClass = iCPPClassTypeArray[n];
            ICPPConstructor ctor = ImplicitsAnalysis.getDefaultConstructor(baseClass);
            if (ctor == null || !ctor.isConstexpr()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static ICPPConstructor getDefaultConstructor(ICPPClassType classType) {
        ICPPConstructor[] iCPPConstructorArray = classType.getConstructors();
        int n = iCPPConstructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ClassTypeHelper.getMethodKind(classType, ctor) == ClassTypeHelper.MethodKind.DEFAULT_CTOR) {
                return ctor;
            }
            ++n2;
        }
        return null;
    }
}

