/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
public class SyncRegisterDataAccess {
    private final DsfSession fSession;
    @ThreadSafe
    private ServiceTracker fServiceTracker;

    public SyncRegisterDataAccess(DsfSession session) {
        this.fSession = session;
    }

    @ThreadSafe
    private synchronized IRegisters getService() {
        String serviceId = DsfServices.createServiceFilter(IRegisters.class, (String)this.fSession.getId());
        if (this.fServiceTracker == null) {
            try {
                this.fServiceTracker = new ServiceTracker(DsfUIPlugin.getBundleContext(), DsfUIPlugin.getBundleContext().createFilter(serviceId), null);
                this.fServiceTracker.open();
            }
            catch (InvalidSyntaxException e) {
                return null;
            }
        }
        return (IRegisters)this.fServiceTracker.getService();
    }

    @ThreadSafe
    public synchronized void dispose() {
        if (this.fServiceTracker != null) {
            this.fServiceTracker.close();
        }
    }

    public IRegisters.IBitFieldDMContext getBitFieldDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IBitFieldDMContext.class);
        }
        return null;
    }

    public IRegisters.IBitFieldDMData readBitField(Object element) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetBitFieldValueQuery query = new GetBitFieldValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IBitFieldDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeBitField(Object element, String value, String formatId) {
        block6: {
            IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
            if (dmc == null) {
                return;
            }
            DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
            if (session == null) {
                return;
            }
            SetBitFieldValueQuery query = new SetBitFieldValueQuery(dmc, value, formatId);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                query.get();
            }
            catch (InterruptedException e) {
                assert (false);
            }
            catch (ExecutionException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void writeBitField(Object element, IRegisters.IMnemonic mnemonic) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetBitFieldValueMnemonicQuery query = new SetBitFieldValueMnemonicQuery(dmc, mnemonic);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public IRegisters.IRegisterGroupDMContext getRegisterGroupDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterGroupDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterDMContext getRegisterDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
        }
        return null;
    }

    public IFormattedValues.IFormattedDataDMContext getFormattedDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
            return (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterGroupDMData readRegisterGroup(Object element) {
        IRegisters.IRegisterGroupDMContext dmc = this.getRegisterGroupDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterGroupValueQuery query = new GetRegisterGroupValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterGroupDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public IRegisters.IRegisterDMData readRegister(Object element) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterValueQuery query = new GetRegisterValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeRegister(Object element, String value, String formatId) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetRegisterValueQuery query = new SetRegisterValueQuery(dmc, value, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public String[] getSupportedFormats(Object element) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            IDMContext vmcdmc = ((IDMVMContext)element).getDMContext();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IRegisterDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetSupportFormatsValueQuery query = new GetSupportFormatsValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String[])query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedRegisterValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            IDMContext vmcdmc = ((IDMVMContext)element).getDMContext();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IRegisterDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedBitFieldValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            IDMContext vmcdmc = ((IDMVMContext)element).getDMContext();
            IRegisters.IBitFieldDMContext bitfielddmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IBitFieldDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)bitfielddmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public IRegisters.IRegisterGroupDMData getRegisterGroupDMData(Object element) {
        DsfSession session;
        IRegisters.IRegisterGroupDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            dmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterGroupDMContext.class);
        }
        if (dmc != null && (session = DsfSession.getSession((String)dmc.getSessionId())) != null) {
            GetRegisterGroupDataQuery query = new GetRegisterGroupDataQuery(dmc);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                return (IRegisters.IRegisterGroupDMData)query.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return null;
    }

    public IRegisters.IRegisterDMData getRegisterDMData(Object element) {
        DsfSession session;
        IRegisters.IRegisterDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            dmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class);
        }
        if (dmc != null && (session = DsfSession.getSession((String)dmc.getSessionId())) != null) {
            GetRegisterDataQuery query = new GetRegisterDataQuery(dmc);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                return (IRegisters.IRegisterDMData)query.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return null;
    }

    public IRegisters.IBitFieldDMData getBitFieldDMData(Object element) {
        DsfSession session;
        IRegisters.IBitFieldDMContext dmc = null;
        if (element instanceof IDMVMContext) {
            dmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IBitFieldDMContext.class);
        }
        if (dmc != null && (session = DsfSession.getSession((String)dmc.getSessionId())) != null) {
            GetBitFieldQuery query = new GetBitFieldQuery(dmc);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                return (IRegisters.IBitFieldDMData)query.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return null;
    }

    public class GetBitFieldQuery
    extends RegistersServiceQuery<IRegisters.IBitFieldDMData, IRegisters.IBitFieldDMContext> {
        public GetBitFieldQuery(IRegisters.IBitFieldDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
            service.getBitFieldData((IRegisters.IBitFieldDMContext)this.fDmc, rm);
        }
    }

    public class GetBitFieldValueQuery
    extends RegistersServiceQuery<IRegisters.IBitFieldDMData, IRegisters.IBitFieldDMContext> {
        public GetBitFieldValueQuery(IRegisters.IBitFieldDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
            service.getBitFieldData((IRegisters.IBitFieldDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((IRegisters.IBitFieldDMData)this.getData()));
                    rm.done();
                }
            });
        }
    }

    public class GetFormattedValueValueQuery
    extends RegistersServiceQuery<String, IFormattedValues.IFormattedDataDMContext> {
        private String fFormatId;

        public GetFormattedValueValueQuery(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
            this.fFormatId = formatId;
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<String> rm) {
            IFormattedValues.FormattedValueDMContext formDmc = service.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)this.fDmc, this.fFormatId);
            service.getFormattedExpressionValue(formDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                    rm.done();
                }
            });
        }
    }

    public class GetRegisterDataQuery
    extends RegistersServiceQuery<IRegisters.IRegisterDMData, IRegisters.IRegisterDMContext> {
        public GetRegisterDataQuery(IRegisters.IRegisterDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
            service.getRegisterData((IRegisters.IRegisterDMContext)this.fDmc, rm);
        }
    }

    public class GetRegisterGroupDataQuery
    extends RegistersServiceQuery<IRegisters.IRegisterGroupDMData, IRegisters.IRegisterGroupDMContext> {
        public GetRegisterGroupDataQuery(IRegisters.IRegisterGroupDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
            service.getRegisterGroupData((IRegisters.IRegisterGroupDMContext)this.fDmc, rm);
        }
    }

    public class GetRegisterGroupValueQuery
    extends RegistersServiceQuery<IRegisters.IRegisterGroupDMData, IRegisters.IRegisterGroupDMContext> {
        public GetRegisterGroupValueQuery(IRegisters.IRegisterGroupDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
            service.getRegisterGroupData((IRegisters.IRegisterGroupDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((IRegisters.IRegisterGroupDMData)this.getData()));
                    rm.done();
                }
            });
        }
    }

    public class GetRegisterValueQuery
    extends RegistersServiceQuery<IRegisters.IRegisterDMData, IRegisters.IRegisterDMContext> {
        public GetRegisterValueQuery(IRegisters.IRegisterDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
            service.getRegisterData((IRegisters.IRegisterDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((IRegisters.IRegisterDMData)this.getData()));
                    rm.done();
                }
            });
        }
    }

    public class GetSupportFormatsValueQuery
    extends RegistersServiceQuery<String[], IFormattedValues.IFormattedDataDMContext> {
        public GetSupportFormatsValueQuery(IFormattedValues.IFormattedDataDMContext dmc) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
        }

        @Override
        protected void doExecute(IRegisters service, DataRequestMonitor<String[]> rm) {
            service.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)this.fDmc, rm);
        }
    }

    public static abstract class RegistersServiceQuery<V, K extends IDMContext>
    extends Query<V> {
        protected final K fDmc;
        final /* synthetic */ SyncRegisterDataAccess this$0;

        public RegistersServiceQuery(K dmc) {
            this.this$0 = var1_1;
            this.fDmc = dmc;
        }

        protected void execute(DataRequestMonitor<V> rm) {
            DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10001, "Debug session already shut down.", null));
                rm.done();
                return;
            }
            IRegisters service = this.this$0.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            this.doExecute(service, rm);
        }

        protected abstract void doExecute(IRegisters var1, DataRequestMonitor<V> var2);
    }

    public class SetBitFieldValueMnemonicQuery
    extends RegistersServiceQuery<Object, IRegisters.IBitFieldDMContext> {
        IRegisters.IMnemonic fMnemonic;

        public SetBitFieldValueMnemonicQuery(IRegisters.IBitFieldDMContext dmc, IRegisters.IMnemonic mnemonic) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
            this.fMnemonic = mnemonic;
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<Object> rm) {
            service.writeBitField((IRegisters.IBitFieldDMContext)this.fDmc, this.fMnemonic, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    public class SetBitFieldValueQuery
    extends RegistersServiceQuery<Object, IRegisters.IBitFieldDMContext> {
        private String fValue;
        private String fFormatId;

        public SetBitFieldValueQuery(IRegisters.IBitFieldDMContext dmc, String value, String formatId) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
            this.fValue = value;
            this.fFormatId = formatId;
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<Object> rm) {
            service.writeBitField((IRegisters.IBitFieldDMContext)this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    public class SetRegisterValueQuery
    extends RegistersServiceQuery<Object, IRegisters.IRegisterDMContext> {
        private String fValue;
        private String fFormatId;

        public SetRegisterValueQuery(IRegisters.IRegisterDMContext dmc, String value, String formatId) {
            super(SyncRegisterDataAccess.this, (IDMContext)dmc);
            this.fValue = value;
            this.fFormatId = formatId;
        }

        @Override
        protected void doExecute(IRegisters service, final DataRequestMonitor<Object> rm) {
            service.writeRegister((IRegisters.IRegisterDMContext)this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(ImmediateExecutor.getInstance(), rm){

                protected void handleSuccess() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }
}

