/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

class StorageSizeFieldEditor
extends StringFieldEditor {
    private final int minValidValue;
    private final int maxValidValue;

    StorageSizeFieldEditor(String name, String labelText, Composite parent, int min, int max) {
        Assert.isTrue((min > 0 && min < max ? 1 : 0) != 0);
        this.init(name, labelText);
        this.setTextLimit(10);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{min, max}));
        this.createControl(parent);
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String numberString = text.getText();
        int number = this.parse(numberString);
        if (this.checkValue(number)) {
            this.clearErrorMessage();
            return true;
        }
        this.showErrorMessage();
        return false;
    }

    protected boolean checkValue(int number) {
        return number >= this.minValidValue && number <= this.maxValidValue;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            text.setText(StringUtils.formatWithSuffix((long)value));
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            text.setText(StringUtils.formatWithSuffix((long)value));
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            int v = this.parse(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), v);
        }
    }

    private int parse(String str) {
        try {
            return StringUtils.parseIntWithSuffix((String)str, (boolean)true);
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            return 0;
        }
    }
}

