/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.ContextManagerFactory;
import org.eclipse.ui.internal.contexts.ContextManagerLegacyWrapper;
import org.eclipse.ui.keys.IBindingService;

public class WorkbenchContextSupport
implements IWorkbenchContextSupport {
    private Map<EnabledSubmission, IContextActivation> activationsBySubmission = null;
    private final IBindingService bindingService;
    private final IContextService contextService;
    private final ContextManagerLegacyWrapper contextManagerWrapper;
    private final Workbench workbench;

    public WorkbenchContextSupport(Workbench workbenchToSupport, ContextManager contextManager) {
        this.workbench = workbenchToSupport;
        this.contextService = this.workbench.getService(IContextService.class);
        this.bindingService = this.workbench.getService(IBindingService.class);
        this.contextManagerWrapper = ContextManagerFactory.getContextManagerWrapper(contextManager);
    }

    @Override
    public final void addEnabledSubmission(EnabledSubmission enabledSubmission) {
        IContextActivation activation = this.contextService.activateContext(enabledSubmission.getContextId(), new LegacyHandlerSubmissionExpression(enabledSubmission.getActivePartId(), enabledSubmission.getActiveShell(), enabledSubmission.getActiveWorkbenchPartSite()));
        if (this.activationsBySubmission == null) {
            this.activationsBySubmission = new HashMap<EnabledSubmission, IContextActivation>();
        }
        this.activationsBySubmission.put(enabledSubmission, activation);
    }

    @Override
    public final void addEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.addEnabledSubmission((EnabledSubmission)submissionItr.next());
        }
    }

    @Override
    public final IContextManager getContextManager() {
        return this.contextManagerWrapper;
    }

    @Override
    public final int getShellType(Shell shell) {
        return this.contextService.getShellType(shell);
    }

    @Override
    public final boolean isKeyFilterEnabled() {
        return this.bindingService.isKeyFilterEnabled();
    }

    @Override
    public final void openKeyAssistDialog() {
        this.bindingService.openKeyAssistDialog();
    }

    @Override
    public final boolean registerShell(Shell shell, int type) {
        return this.contextService.registerShell(shell, type);
    }

    @Override
    public final void removeEnabledSubmission(EnabledSubmission enabledSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        IContextActivation value = this.activationsBySubmission.remove(enabledSubmission);
        if (value instanceof IContextActivation) {
            IContextActivation activation = value;
            this.contextService.deactivateContext(activation);
        }
    }

    @Override
    public final void removeEnabledSubmissions(Collection enabledSubmissions) {
        Iterator submissionItr = enabledSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.removeEnabledSubmission((EnabledSubmission)submissionItr.next());
        }
    }

    @Override
    public final void setKeyFilterEnabled(boolean enabled) {
        this.bindingService.setKeyFilterEnabled(enabled);
    }

    @Override
    public final boolean unregisterShell(Shell shell) {
        return this.contextService.unregisterShell(shell);
    }
}

