/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.thread.Invocable;

public class FormFields
extends ContentSourceCompletableFuture<Fields> {
    public static final String MAX_FIELDS_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_LENGTH_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormContentSize";
    public static final int MAX_FIELDS_DEFAULT = 1000;
    public static final int MAX_LENGTH_DEFAULT = 200000;
    private static final CompletableFuture<Fields> EMPTY = CompletableFuture.completedFuture(Fields.EMPTY);
    private final Fields _fields;
    private final CharsetStringBuilder _builder;
    private final int _maxFields;
    private final int _maxLength;
    private int _length;
    private String _name;
    private int _percent = 0;
    private byte _percentCode;

    public static Charset getFormEncodedCharset(Request request) {
        HttpConfiguration config = request.getConnectionMetaData().getHttpConfiguration();
        if (!config.getFormEncodedMethods().contains(request.getMethod())) {
            return null;
        }
        HttpField contentTypeField = request.getHeaders().getField(HttpHeader.CONTENT_TYPE);
        if (contentTypeField == null) {
            return null;
        }
        MimeTypes.Type type = MimeTypes.getMimeTypeFromContentType((HttpField)contentTypeField);
        if (type != null) {
            if (type.getBaseType() != MimeTypes.Type.FORM_ENCODED) {
                return null;
            }
            return type.getCharset() == null ? StandardCharsets.UTF_8 : type.getCharset();
        }
        String contentType = contentTypeField.getValue();
        int semicolon = contentType.indexOf(59);
        if (semicolon >= 0) {
            contentType = contentType.substring(0, semicolon).trim();
        }
        if (!MimeTypes.Type.FORM_ENCODED.is(contentType)) {
            return null;
        }
        Charset charset = MimeTypes.getCharsetFromContentType((HttpField)contentTypeField);
        return charset == null ? StandardCharsets.UTF_8 : charset;
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static void set(Request request, CompletableFuture<Fields> fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static void setFields(Request request, Fields fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static Fields getFields(Request request) {
        return FormFields.getFields(request, -1, -1);
    }

    public static Fields getFields(Request request, int maxFields, int maxLength) {
        if (maxFields < 0) {
            maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        }
        if (maxLength < 0) {
            maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        }
        Charset charset = FormFields.getFormEncodedCharset(request);
        return FormFields.from(request, Invocable.InvocationType.NON_BLOCKING, request, charset, maxFields, maxLength).join();
    }

    public static Fields getFields(Content.Source source, Attributes attributes, Charset charset, int maxFields, int maxLength) {
        if (maxFields < 0) {
            maxFields = 1000;
        }
        if (maxLength < 0) {
            maxLength = 1000;
        }
        return FormFields.from(source, Invocable.InvocationType.NON_BLOCKING, attributes, charset, maxFields, maxLength).join();
    }

    public static void onFields(Request request, Promise.Invocable<Fields> promise) {
        FormFields.onFields(request, FormFields.getFormEncodedCharset(request), promise);
    }

    public static void onFields(Request request, Charset charset, Promise.Invocable<Fields> promise) {
        FormFields.onFields(request, charset, -1, -1, promise);
    }

    public static void onFields(Request request, Charset charset, int maxFields, int maxLength, Promise.Invocable<Fields> promise) {
        if (maxFields < 0) {
            maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        }
        if (maxLength < 0) {
            maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        }
        FormFields.from(request, promise.getInvocationType(), request, charset, maxFields, maxLength).whenComplete(Promise.Invocable.toBiConsumer(promise));
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> get(Request request) {
        Object attr = request.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        return EMPTY;
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request) {
        return FormFields.from(request, -1, -1);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, Charset charset) {
        return FormFields.from(request, charset, -1, -1);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, int maxFields, int maxLength) {
        return FormFields.from(request, FormFields.getFormEncodedCharset(request), maxFields, maxLength);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public static CompletableFuture<Fields> from(Request request, Charset charset, int maxFields, int maxLength) {
        if (maxFields < 0) {
            maxFields = FormFields.getContextAttribute(request.getContext(), MAX_FIELDS_ATTRIBUTE, 1000);
        }
        if (maxLength < 0) {
            maxLength = FormFields.getContextAttribute(request.getContext(), MAX_LENGTH_ATTRIBUTE, 200000);
        }
        return FormFields.from(request, Invocable.InvocationType.NON_BLOCKING, request, charset, maxFields, maxLength);
    }

    static CompletableFuture<Fields> from(Content.Source source, Invocable.InvocationType invocationType, Attributes attributes, Charset charset, int maxFields, int maxLength) {
        Object attr = attributes.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        if (charset == null) {
            return EMPTY;
        }
        FormFields futureFormFields = new FormFields(source, invocationType, charset, maxFields, maxLength);
        attributes.setAttribute(FormFields.class.getName(), (Object)futureFormFields);
        futureFormFields.parse();
        return futureFormFields;
    }

    private static int getContextAttribute(Context context, String attribute, int defValue) {
        Object value = context.getAttribute(attribute);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return defValue;
        }
    }

    private FormFields(Content.Source source, Invocable.InvocationType invocationType, Charset charset, int maxFields, int maxSize) {
        super(source, invocationType);
        this._maxFields = maxFields;
        this._maxLength = maxSize;
        this._builder = CharsetStringBuilder.forCharset((Charset)charset);
        this._fields = new Fields(true);
        if (this._maxLength > 0 && source.getLength() > (long)this._maxLength) {
            throw new IllegalStateException("form too large > " + this._maxLength);
        }
    }

    protected Fields parse(Content.Chunk chunk) throws CharacterCodingException {
        if (this._maxLength >= 0) {
            this._length += chunk.remaining();
            if (this._length > this._maxLength) {
                throw new IllegalStateException("form too large > " + this._maxLength);
            }
        }
        ByteBuffer buffer = chunk.getByteBuffer();
        block15: while (BufferUtil.hasContent((ByteBuffer)buffer)) {
            byte b = buffer.get();
            switch (this._percent) {
                case 1: {
                    this._percentCode = b;
                    ++this._percent;
                    continue block15;
                }
                case 2: {
                    this._percent = 0;
                    this._builder.append(UrlEncoded.decodeHexByte((char)((char)this._percentCode), (char)((char)b)));
                    continue block15;
                }
            }
            if (this._name == null) {
                switch (b) {
                    case 38: {
                        String name = this._builder.build();
                        this.onNewField(name, "");
                        continue block15;
                    }
                    case 61: {
                        this._name = this._builder.build();
                        continue block15;
                    }
                    case 43: {
                        this._builder.append(' ');
                        continue block15;
                    }
                    case 37: {
                        ++this._percent;
                        continue block15;
                    }
                }
                this._builder.append(b);
                continue;
            }
            switch (b) {
                case 38: {
                    String value = this._builder.build();
                    this.onNewField(this._name, value);
                    this._name = null;
                    continue block15;
                }
                case 43: {
                    this._builder.append(' ');
                    continue block15;
                }
                case 37: {
                    ++this._percent;
                    continue block15;
                }
            }
            this._builder.append(b);
        }
        if (!chunk.isLast()) {
            return null;
        }
        if (this._percent > 0) {
            throw new IllegalStateException("invalid percent encoding");
        }
        String value = this._builder.build();
        if (this._name == null) {
            if (!value.isEmpty()) {
                this.onNewField(value, "");
            }
            return this._fields;
        }
        this.onNewField(this._name, value);
        return this._fields;
    }

    private void onNewField(String name, String value) {
        Fields.Field field = new Fields.Field(name, value);
        this._fields.add(field);
        if (this._maxFields >= 0 && this._fields.getSize() > this._maxFields) {
            throw new IllegalStateException("form with too many fields > " + this._maxFields);
        }
    }
}

