/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.core.spi.RunBuildRequest;
import org.eclipse.mylyn.builds.internal.core.operations.AbortBuildOperation;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshOperation;
import org.eclipse.mylyn.builds.internal.core.operations.RunBuildOperation;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;

public class OperationFactory {
    private final IOperationService service;

    public OperationFactory(IOperationService service) {
        this.service = service;
    }

    public RefreshOperation getRefreshOperation() {
        return new RefreshOperation(this.service, BuildsUiInternal.getModel());
    }

    public RefreshOperation getRefreshOperation(IBuildElement element) {
        return new RefreshOperation(this.service, BuildsUiInternal.getModel(), Collections.singletonList(element));
    }

    public RefreshOperation getRefreshOperation(List<IBuildElement> elements) {
        return new RefreshOperation(this.service, BuildsUiInternal.getModel(), elements);
    }

    public RunBuildOperation getRunBuildOperation(RunBuildRequest request) {
        return new RunBuildOperation(this.service, request);
    }

    public AbortBuildOperation getAbortBuildOperation(IBuild build) {
        return new AbortBuildOperation(this.service, build);
    }

    public GetBuildsOperation getGetBuildsOperation(GetBuildsRequest request) {
        return new GetBuildsOperation(this.service, request);
    }

    public IOperationService getService() {
        return this.service;
    }
}

