/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineHeaderAnnotation;
import org.eclipse.jface.internal.text.codemining.CodeMiningManager;
import org.eclipse.jface.internal.text.codemining.ICodeMiningAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.LineFooterAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CodeMiningDocumentFooterAnnotation
extends LineFooterAnnotation
implements ICodeMiningAnnotation {
    private ICodeMining[] fResolvedMinings = null;
    private final List<ICodeMining> fMinings = new ArrayList<ICodeMining>();
    private final List<Rectangle> fBounds = new ArrayList<Rectangle>();
    private IProgressMonitor fMonitor;

    public CodeMiningDocumentFooterAnnotation(Position position, ISourceViewer viewer, Consumer<MouseEvent> onMouseHover, Consumer<MouseEvent> onMouseOut, Consumer<MouseEvent> onMouseMove) {
        super(position, viewer, onMouseHover, onMouseOut, onMouseMove);
    }

    @Override
    public int getHeight() {
        return CodeMiningLineHeaderAnnotation.hasAtLeastOneResolvedMiningNotEmpty(this.fMinings, this.fResolvedMinings) ? CodeMiningLineHeaderAnnotation.getMultilineHeight(null, this.fMinings, super.getTextWidget(), super.getHeight()) : 0;
    }

    @Override
    public void update(List<ICodeMining> minings, IProgressMonitor monitor) {
        if (this.fResolvedMinings == null || this.fResolvedMinings.length != minings.size()) {
            this.fResolvedMinings = new ICodeMining[minings.size()];
        }
        int length = Math.min(this.fMinings.size(), minings.size());
        int i = 0;
        while (i < length) {
            ICodeMining mining = this.fMinings.get(i);
            if (mining.getLabel() != null) {
                this.fResolvedMinings[i] = mining;
            }
            ++i;
        }
        CodeMiningLineHeaderAnnotation.disposeMinings(this.fMinings);
        this.fMonitor = monitor;
        this.fMinings.addAll(minings);
    }

    public void markDeleted(boolean deleted) {
        super.markDeleted(deleted);
        if (deleted) {
            CodeMiningLineHeaderAnnotation.disposeMinings(this.fMinings);
            this.fResolvedMinings = null;
        }
    }

    @Override
    public void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        int singleLineHeight = super.getHeight();
        CodeMiningLineHeaderAnnotation.draw(this.fMinings, this.fBounds, singleLineHeight, this.fResolvedMinings, gc, textWidget, color, x, y, this::redraw);
    }

    @Override
    public void redraw() {
        ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>(this.fMinings);
        for (ICodeMining mining : minings) {
            if (mining.isResolved()) continue;
            mining.resolve(this.getViewer(), this.fMonitor).thenRunAsync(() -> this.redraw());
            return;
        }
        super.redraw();
    }

    @Override
    public Consumer<MouseEvent> getAction(MouseEvent e) {
        ICodeMining mining = CodeMiningManager.getValidCodeMiningAtLocation(this.fResolvedMinings, this.fBounds, e.x, e.y);
        return mining != null ? mining.getAction() : null;
    }

    @Override
    public boolean isInVisibleLines() {
        return super.isInVisibleLines();
    }
}

