/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.ui.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.build.gcc.ui.internal.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GCCToolChainSettingsPage
extends WizardPage {
    private final GCCToolChain toolChain;
    private Text compilerText;
    private Text osText;
    private Text archText;

    public GCCToolChainSettingsPage(GCCToolChain toolChain, boolean isClang) {
        super(GCCToolChainSettingsPage.class.getName());
        this.toolChain = toolChain;
        this.setTitle(isClang ? Messages.GCCToolChainSettingsPage_ClangTitle : Messages.GCCToolChainSettingsPage_Title);
        this.setDescription(Messages.GCCToolChainSettingsPage_Description);
    }

    public void createControl(Composite parent) {
        String arch;
        String os;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comp, 0);
        label.setText(Messages.GCCToolChainSettingsPage_Compiler);
        Composite compilerComp = new Composite(comp, 0);
        compilerComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compilerComp.setLayout((Layout)layout);
        this.compilerText = new Text(compilerComp, 2048);
        this.compilerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.compilerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GCCToolChainSettingsPage.this.updateComplete();
            }
        });
        this.compilerText.addModifyListener(e -> this.updateComplete());
        if (this.toolChain != null) {
            this.compilerText.setText(this.toolChain.getPath().toString());
        }
        Button compilerBrowse = new Button(compilerComp, 8);
        compilerBrowse.setText(Messages.GCCToolChainSettingsPage_Browse);
        compilerBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(GCCToolChainSettingsPage.this.getShell());
                String newText = fileDialog.open();
                if (newText != null) {
                    GCCToolChainSettingsPage.this.compilerText.setText(newText);
                }
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.GCCToolChainSettingsPage_OS);
        this.osText = new Text(comp, 2048);
        this.osText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.toolChain != null && (os = this.toolChain.getProperty("os")) != null) {
            this.osText.setText(os);
        }
        label = new Label(comp, 0);
        label.setText(Messages.GCCToolChainSettingsPage_Arch);
        this.archText = new Text(comp, 2048);
        this.archText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.toolChain != null && (arch = this.toolChain.getProperty("arch")) != null) {
            this.archText.setText(arch);
        }
        this.updateComplete();
        this.setControl((Control)comp);
    }

    private void updateComplete() {
        this.setPageComplete(!this.compilerText.getText().trim().isEmpty());
    }

    public Path getPath() {
        return Paths.get(this.compilerText.getText().trim(), new String[0]);
    }

    public String getOS() {
        return this.osText.getText().trim();
    }

    public String getArch() {
        return this.archText.getText().trim();
    }
}

