/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;

public class IUDragAdapter
extends DragSourceAdapter {
    ISelectionProvider selectionProvider;

    public IUDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragSetData(DragSourceEvent event) {
        IInstallableUnit[] ius = this.getSelectedIUs();
        if (ius == null || ius.length == 0) {
            return;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getTransfer().getSelection();
            return;
        }
        if (!TextTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            buffer.append(iu.toString());
            buffer.append('\n');
            ++n2;
        }
        event.data = buffer.toString();
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
        if (!this.areOnlyIUsSelected(selection)) {
            event.doit = false;
            return;
        }
        LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
        event.doit = true;
    }

    private IInstallableUnit[] getSelectedIUs() {
        IStructuredSelection structuredSelection;
        ArrayList<IInstallableUnit> ius;
        block4: {
            block3: {
                ius = new ArrayList<IInstallableUnit>();
                ISelection selection = this.selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) break block3;
                structuredSelection = (IStructuredSelection)selection;
                if (!selection.isEmpty()) break block4;
            }
            return null;
        }
        Iterator iter = structuredSelection.iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = ProvUI.getAdapter(iter.next(), IInstallableUnit.class);
            if (iu == null) continue;
            ius.add(iu);
        }
        return ius.toArray(new IInstallableUnit[ius.size()]);
    }

    private boolean areOnlyIUsSelected(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = ProvUI.getAdapter(iter.next(), IInstallableUnit.class);
            if (iu != null) continue;
            return false;
        }
        return true;
    }
}

