/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcHttpTransportException;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.XmlRpcIOException;
import org.xml.sax.SAXException;

public class XmlRpcCommonsTransport
extends XmlRpcHttpTransport {
    private static final int MAX_REDIRECT_ATTEMPTS = 100;
    protected final HttpClient client;
    private static final String userAgent = USER_AGENT + " (Jakarta Commons httpclient Transport)";
    protected PostMethod method;
    private int contentLength = -1;
    private XmlRpcHttpClientConfig config;

    public XmlRpcCommonsTransport(XmlRpcCommonsTransportFactory pFactory) {
        super(pFactory.getClient(), userAgent);
        HttpClient httpClient = pFactory.getHttpClient();
        if (httpClient == null) {
            httpClient = this.newHttpClient();
        }
        this.client = httpClient;
    }

    protected void setContentLength(int pLength) {
        this.contentLength = pLength;
    }

    protected HttpClient newHttpClient() {
        return new HttpClient();
    }

    protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
        this.config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        this.method = this.newPostMethod(this.config);
        super.initHttpHeaders(pRequest);
        if (this.config.getConnectionTimeout() != 0) {
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.config.getConnectionTimeout());
        }
        if (this.config.getReplyTimeout() != 0) {
            this.client.getHttpConnectionManager().getParams().setSoTimeout(this.config.getReplyTimeout());
        }
        this.method.getParams().setVersion(HttpVersion.HTTP_1_1);
    }

    protected PostMethod newPostMethod(XmlRpcHttpClientConfig pConfig) {
        return new PostMethod(pConfig.getServerURL().toString());
    }

    protected void setRequestHeader(String pHeader, String pValue) {
        this.method.setRequestHeader(new Header(pHeader, pValue));
    }

    protected boolean isResponseGzipCompressed() {
        Header h = this.method.getResponseHeader("Content-Encoding");
        if (h == null) {
            return false;
        }
        return HttpUtil.isUsingGzipEncoding((String)h.getValue());
    }

    protected InputStream getInputStream() throws XmlRpcException {
        try {
            this.checkStatus((HttpMethod)this.method);
            return this.method.getResponseBodyAsStream();
        }
        catch (HttpException e) {
            throw new XmlRpcClientException("Error in HTTP transport: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("I/O error in server communication: " + e.getMessage(), e);
        }
    }

    protected void setCredentials(XmlRpcHttpClientConfig pConfig) throws XmlRpcClientException {
        String userName = pConfig.getBasicUserName();
        if (userName != null) {
            String enc = pConfig.getBasicEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            this.client.getParams().setParameter("http.protocol.credential-charset", (Object)enc);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, pConfig.getBasicPassword());
            AuthScope scope = new AuthScope(null, -1, null, AuthScope.ANY_SCHEME);
            this.client.getState().setCredentials(scope, (Credentials)creds);
            this.client.getParams().setAuthenticationPreemptive(true);
        }
    }

    protected void close() throws XmlRpcClientException {
        this.method.releaseConnection();
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        Header h = this.method.getResponseHeader("Content-Encoding");
        if (h == null) {
            return false;
        }
        return HttpUtil.isUsingGzipEncoding((String)h.getValue());
    }

    protected boolean isRedirectRequired() {
        switch (this.method.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    protected void resetClientForRedirect() throws XmlRpcException {
        Header locationHeader = this.method.getResponseHeader("location");
        if (locationHeader == null) {
            throw new XmlRpcException("Invalid redirect: Missing location header");
        }
        String location = locationHeader.getValue();
        URI redirectUri = null;
        URI currentUri = null;
        try {
            currentUri = this.method.getURI();
            String charset = currentUri.getProtocolCharset();
            redirectUri = new URI(location, true, charset);
            this.method.setURI(redirectUri);
        }
        catch (URIException ex) {
            throw new XmlRpcException(ex.getMessage(), (Throwable)ex);
        }
        this.method.getHostAuthState().invalidate();
    }

    protected void writeRequest(final XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException {
        this.method.setRequestEntity(new RequestEntity(){

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream pOut) throws IOException {
                try {
                    FilterOutputStream ostream = XmlRpcCommonsTransport.this.isUsingByteArrayOutput(XmlRpcCommonsTransport.this.config) ? new FilterOutputStream(pOut){

                        public void close() throws IOException {
                            this.flush();
                        }
                    } : new BufferedOutputStream(pOut){

                        public void close() throws IOException {
                            this.flush();
                        }
                    };
                    pWriter.write(ostream);
                }
                catch (XmlRpcException e) {
                    throw new XmlRpcIOException((Throwable)e);
                }
                catch (SAXException e) {
                    throw new XmlRpcIOException((Throwable)e);
                }
            }

            public long getContentLength() {
                return XmlRpcCommonsTransport.this.contentLength;
            }

            public String getContentType() {
                return "text/xml";
            }
        });
        try {
            int redirectAttempts = 0;
            while (true) {
                this.client.executeMethod((HttpMethod)this.method);
                if (this.isRedirectRequired()) {
                    if (redirectAttempts++ > 100) {
                        throw new XmlRpcException("Too many redirects.");
                    }
                    this.resetClientForRedirect();
                    continue;
                }
                break;
            }
        }
        catch (XmlRpcIOException e) {
            Throwable t = e.getLinkedException();
            if (t instanceof XmlRpcException) {
                throw (XmlRpcException)t;
            }
            throw new XmlRpcException("Unexpected exception: " + t.getMessage(), t);
        }
        catch (IOException e) {
            throw new XmlRpcException("I/O error while communicating with HTTP server: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkStatus(HttpMethod pMethod) throws XmlRpcHttpTransportException {
        int status = pMethod.getStatusCode();
        if (status < 200 || status > 299) {
            throw new XmlRpcHttpTransportException(status, pMethod.getStatusText());
        }
    }
}

