/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;

public abstract class AbstractGCCBOPConsoleParser
implements IScannerInfoConsoleParser {
    protected static final String[] COMPILER_INVOCATION = new String[]{"gcc", "g++", "cc", "c++"};
    protected static final String DASHIDASH = "-I-";
    protected static final String DASHI = "-I";
    protected static final String DASHD = "-D";
    private IProject project;
    protected IScannerInfoCollector collector;
    private boolean bMultiline = false;
    private String sMultiline = "";
    protected String[] fCompilerCommands;

    protected IProject getProject() {
        return this.project;
    }

    protected IScannerInfoCollector getCollector() {
        return this.collector;
    }

    public void startup(IProject project, IScannerInfoCollector collector) {
        this.project = project;
        this.collector = collector;
        this.fCompilerCommands = this.computeCompilerCommands();
    }

    private String[] computeCompilerCommands() {
        String[] compilerCommands;
        String compilerCommandsString;
        SCProfileInstance profileInstance;
        ScannerConfigProfile.BuildOutputProvider boProvider;
        if (this.project != null && (boProvider = (profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(this.project, "")).getProfile().getBuildOutputProviderElement()) != null && (compilerCommandsString = boProvider.getScannerInfoConsoleParser().getCompilerCommands()) != null && compilerCommandsString.length() > 0 && (compilerCommands = compilerCommandsString.split(",\\s*")).length > 0) {
            String[] compilerInvocation = new String[COMPILER_INVOCATION.length + compilerCommands.length];
            System.arraycopy(COMPILER_INVOCATION, 0, compilerInvocation, 0, COMPILER_INVOCATION.length);
            System.arraycopy(compilerCommands, 0, compilerInvocation, COMPILER_INVOCATION.length, compilerCommands.length);
            return compilerInvocation;
        }
        return COMPILER_INVOCATION;
    }

    public boolean processLine(String line) {
        if (((String)line).trim().length() == 0) {
            return false;
        }
        boolean rc = false;
        int lineBreakPos = ((String)line).length() - 1;
        char[] lineChars = ((String)line).toCharArray();
        while (lineBreakPos >= 0 && Character.isWhitespace(lineChars[lineBreakPos])) {
            --lineBreakPos;
        }
        if (lineBreakPos >= 0 && (lineChars[lineBreakPos] != '\\' || lineBreakPos > 0 && lineChars[lineBreakPos - 1] == '\\')) {
            lineBreakPos = -1;
        }
        if (lineBreakPos >= 0) {
            this.sMultiline = String.valueOf(this.sMultiline) + ((String)line).substring(0, lineBreakPos);
            this.bMultiline = true;
            return rc;
        }
        if (this.bMultiline) {
            line = this.sMultiline + (String)line;
            this.bMultiline = false;
            this.sMultiline = "";
        }
        line = ((String)line).trim();
        TraceUtil.outputTrace("AbstractGCCBOPConsoleParser parsing line: [", (String)line, "]");
        int firstColon = ((String)line).indexOf(58);
        String make = ((String)line).substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = ((String)line).substring(firstColon + 1).trim();
            enter = msg.startsWith(MakeMessages.getString("AbstractGCCBOPConsoleParser_EnteringDirectory"));
            if (enter || msg.startsWith(MakeMessages.getString("AbstractGCCBOPConsoleParser_LeavingDirectory"))) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.getUtility() != null) {
                        this.getUtility().changeMakeDirectory(dir, this.getDirectoryLevel((String)line), enter);
                    }
                    return rc;
                }
            }
        }
        return this.processSingleLine(((String)line).trim());
    }

    private int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    protected abstract AbstractGCCBOPConsoleParserUtility getUtility();

    public void shutdown() {
        if (this.getUtility() != null) {
            this.getUtility().reportProblems();
        }
    }

    protected String[][] tokenize(String line, boolean escapeInsideDoubleQuotes) {
        ArrayList<String[]> commands = new ArrayList<String[]>();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        char[] input = line.toCharArray();
        boolean nextEscaped = false;
        char currentQuote = '\u0000';
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            boolean escaped = nextEscaped;
            nextEscaped = false;
            if (currentQuote != '\u0000') {
                if (c == currentQuote) {
                    if (escaped) {
                        token.append(c);
                    } else {
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = '\u0000';
                    }
                } else if (escapeInsideDoubleQuotes && currentQuote == '\"' && c == '\\') {
                    boolean bl = nextEscaped = !escaped;
                    if (escaped) {
                        token.append(c);
                    }
                } else {
                    if (escaped) {
                        token.append('\\');
                    }
                    token.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        nextEscaped = true;
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        if (c == '`') {
                            token.append(c);
                        }
                        currentQuote = c;
                        break;
                    }
                    case ';': {
                        if (escaped) {
                            token.append(c);
                            break;
                        }
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    case '&': 
                    case '|': {
                        if (escaped || i + 1 >= input.length || input[i + 1] != c) {
                            token.append(c);
                            break;
                        }
                        ++i;
                        this.endCommand(token, tokens, commands);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(c)) {
                            if (escaped) {
                                token.append(c);
                                break;
                            }
                            this.endToken(token, tokens);
                            break;
                        }
                        if (escaped) {
                            token.append('\\');
                        }
                        token.append(c);
                    }
                }
            }
            ++i;
        }
        this.endCommand(token, tokens, commands);
        return (String[][])commands.toArray((T[])new String[commands.size()][]);
    }

    private void endCommand(StringBuilder token, ArrayList<String> tokens, ArrayList<String[]> commands) {
        this.endToken(token, tokens);
        if (!tokens.isEmpty()) {
            commands.add(tokens.toArray(new String[tokens.size()]));
            tokens.clear();
        }
    }

    private void endToken(StringBuilder token, ArrayList<String> tokens) {
        if (token.length() > 0) {
            tokens.add(token.toString());
            token.setLength(0);
        }
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        String[][] tokens = this.tokenize(line, true);
        int i = 0;
        while (i < tokens.length) {
            String[] command = tokens[i];
            if (this.processCommand(command)) {
                rc = true;
            } else {
                int j = 0;
                while (j < command.length) {
                    String[][] subtokens = this.tokenize(command[j], true);
                    int k = 0;
                    while (k < subtokens.length) {
                        String[] subcommand = subtokens[k];
                        if (subcommand.length > 1 && this.processCommand(subcommand)) {
                            rc = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rc;
    }

    protected int findCompilerInvocation(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            int searchFromOffset = Math.max(token.lastIndexOf(47), token.lastIndexOf(92)) + 1;
            int j = 0;
            while (j < this.fCompilerCommands.length) {
                if (token.indexOf(this.fCompilerCommands[j], searchFromOffset) != -1) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    protected abstract boolean processCommand(String[] var1);
}

