/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.jackson.UnixTimestampDeserializer;
import org.mandas.docker.client.jackson.UnixTimestampSerializer;
import org.mandas.docker.client.messages.Event;

final class ImmutableEvent
implements Event {
    @Nullable
    private final Event.Type type;
    @Nullable
    private final String action;
    @Nullable
    private final Event.Actor actor;
    private final Date time;
    @Nullable
    private final Long timeNano;

    private ImmutableEvent(@Nullable Event.Type type, @Nullable String action, @Nullable Event.Actor actor, Date time, @Nullable Long timeNano) {
        this.type = type;
        this.action = action;
        this.actor = actor;
        this.time = time;
        this.timeNano = timeNano;
    }

    @Override
    @JsonProperty(value="Type")
    @Nullable
    public Event.Type type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Action")
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty(value="Actor")
    @Nullable
    public Event.Actor actor() {
        return this.actor;
    }

    @Override
    @JsonProperty(value="time")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    @JsonSerialize(using=UnixTimestampSerializer.class)
    public Date time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="timeNano")
    @Nullable
    public Long timeNano() {
        return this.timeNano;
    }

    public final ImmutableEvent withType(@Nullable Event.Type value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableEvent(value, this.action, this.actor, this.time, this.timeNano);
    }

    public final ImmutableEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableEvent(this.type, value, this.actor, this.time, this.timeNano);
    }

    public final ImmutableEvent withActor(@Nullable Event.Actor value) {
        if (this.actor == value) {
            return this;
        }
        return new ImmutableEvent(this.type, this.action, value, this.time, this.timeNano);
    }

    public final ImmutableEvent withTime(Date value) {
        if (this.time == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "time");
        return new ImmutableEvent(this.type, this.action, this.actor, newValue, this.timeNano);
    }

    public final ImmutableEvent withTimeNano(@Nullable Long value) {
        if (Objects.equals(this.timeNano, value)) {
            return this;
        }
        return new ImmutableEvent(this.type, this.action, this.actor, this.time, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvent && this.equalsByValue((ImmutableEvent)another);
    }

    private boolean equalsByValue(ImmutableEvent another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.action, another.action) && Objects.equals(this.actor, another.actor) && this.time.equals(another.time) && Objects.equals(this.timeNano, another.timeNano);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.actor);
        h += (h << 5) + this.time.hashCode();
        h += (h << 5) + Objects.hashCode(this.timeNano);
        return h;
    }

    public String toString() {
        return "Event{type=" + String.valueOf((Object)this.type) + ", action=" + this.action + ", actor=" + String.valueOf(this.actor) + ", time=" + String.valueOf(this.time) + ", timeNano=" + this.timeNano + "}";
    }

    public static ImmutableEvent copyOf(Event instance) {
        if (instance instanceof ImmutableEvent) {
            return (ImmutableEvent)instance;
        }
        return ImmutableEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements Event.Builder {
        private static final long INIT_BIT_TIME = 1L;
        private long initBits = 1L;
        private Event.Type type;
        private String action;
        private Event.Actor actor;
        private Date time;
        private Long timeNano;

        private Builder() {
        }

        public final Builder from(Event instance) {
            Event.Actor actorValue;
            String actionValue;
            Objects.requireNonNull(instance, "instance");
            Event.Type typeValue = instance.type();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((actionValue = instance.action()) != null) {
                this.action(actionValue);
            }
            if ((actorValue = instance.actor()) != null) {
                this.actor(actorValue);
            }
            this.time(instance.time());
            Long timeNanoValue = instance.timeNano();
            if (timeNanoValue != null) {
                this.timeNano(timeNanoValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Type")
        public final Builder type(@Nullable Event.Type type) {
            this.type = type;
            return this;
        }

        @Override
        @JsonProperty(value="Action")
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @Override
        @JsonProperty(value="Actor")
        public final Builder actor(@Nullable Event.Actor actor) {
            this.actor = actor;
            return this;
        }

        @Override
        @JsonProperty(value="time")
        @JsonDeserialize(using=UnixTimestampDeserializer.class)
        @JsonSerialize(using=UnixTimestampSerializer.class)
        public final Builder time(Date time) {
            this.time = Objects.requireNonNull(time, "time");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="timeNano")
        public final Builder timeNano(@Nullable Long timeNano) {
            this.timeNano = timeNano;
            return this;
        }

        @Override
        public ImmutableEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvent(this.type, this.action, this.actor, this.time, this.timeNano);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            return "Cannot build Event, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    static final class Actor
    implements Event.Actor {
        private final String id;
        @Nullable
        private final Map<String, String> attributes;

        private Actor(String id, @Nullable Map<String, String> attributes) {
            this.id = id;
            this.attributes = attributes;
        }

        @Override
        @JsonProperty(value="ID")
        public String id() {
            return this.id;
        }

        @Override
        @JsonProperty(value="Attributes")
        @Nullable
        public Map<String, String> attributes() {
            return this.attributes;
        }

        public final Actor withId(String value) {
            String newValue = Objects.requireNonNull(value, "id");
            if (this.id.equals(newValue)) {
                return this;
            }
            return new Actor(newValue, this.attributes);
        }

        public final Actor withAttributes(@Nullable Map<String, ? extends String> entries) {
            if (this.attributes == entries) {
                return this;
            }
            Map<String, String> newValue = entries == null ? null : ImmutableEvent.createUnmodifiableMap(true, false, entries);
            return new Actor(this.id, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Actor && this.equalsByValue((Actor)another);
        }

        private boolean equalsByValue(Actor another) {
            return this.id.equals(another.id) && Objects.equals(this.attributes, another.attributes);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.id.hashCode();
            h += (h << 5) + Objects.hashCode(this.attributes);
            return h;
        }

        public String toString() {
            return "Actor{id=" + this.id + ", attributes=" + String.valueOf(this.attributes) + "}";
        }

        public static Actor copyOf(Event.Actor instance) {
            if (instance instanceof Actor) {
                return (Actor)instance;
            }
            return Actor.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_ID = 1L;
            private long initBits = 1L;
            private String id;
            private Map<String, String> attributes = null;

            private Builder() {
            }

            public final Builder from(Event.Actor instance) {
                Objects.requireNonNull(instance, "instance");
                this.id(instance.id());
                Map<String, String> attributesValue = instance.attributes();
                if (attributesValue != null) {
                    this.putAllAttributes(attributesValue);
                }
                return this;
            }

            @JsonProperty(value="ID")
            public final Builder id(String id) {
                this.id = Objects.requireNonNull(id, "id");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addAttribute(String key, String value) {
                if (this.attributes == null) {
                    this.attributes = new LinkedHashMap<String, String>();
                }
                this.attributes.put(Objects.requireNonNull(key, "attributes key"), Objects.requireNonNull(value, value == null ? "attributes value for key: " + key : null));
                return this;
            }

            public final Builder addAttribute(Map.Entry<String, ? extends String> entry) {
                String v;
                if (this.attributes == null) {
                    this.attributes = new LinkedHashMap<String, String>();
                }
                String k = entry.getKey();
                this.attributes.put(Objects.requireNonNull(k, "attributes key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "attributes value for key: " + k : null));
                return this;
            }

            @JsonProperty(value="Attributes")
            public final Builder attributes(@Nullable Map<String, ? extends String> entries) {
                if (entries == null) {
                    this.attributes = null;
                    return this;
                }
                this.attributes = new LinkedHashMap<String, String>();
                return this.putAllAttributes(entries);
            }

            public final Builder putAllAttributes(Map<String, ? extends String> entries) {
                if (this.attributes == null) {
                    this.attributes = new LinkedHashMap<String, String>();
                }
                for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                    String v;
                    String k = e.getKey();
                    this.attributes.put(Objects.requireNonNull(k, "attributes key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "attributes value for key: " + k : null));
                }
                return this;
            }

            public Actor build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Actor(this.id, this.attributes == null ? null : ImmutableEvent.createUnmodifiableMap(false, false, this.attributes));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("id");
                }
                return "Cannot build Actor, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

