/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class SchedWakeupHandler
extends KernelEventHandler {
    public SchedWakeupHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        ITmfEventField content = event.getContent();
        Integer tid = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldTid()});
        if (tid == null) {
            return;
        }
        Integer prio = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldPrio()});
        Long targetCpu = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldTargetCpu()});
        String threadAttributeName = Attributes.buildThreadAttributeName(tid, cpu);
        if (cpu == null || targetCpu == null || threadAttributeName == null) {
            return;
        }
        int threadNode = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{threadAttributeName});
        ProcessStatus status = ProcessStatus.getStatusFromStateValue(ss.queryOngoingState(threadNode));
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        if (status != ProcessStatus.RUN && status != ProcessStatus.RUN_SYTEMCALL) {
            ss.modifyAttribute(timestamp, ProcessStatus.WAIT_CPU.getStateValue().unboxValue(), threadNode);
        }
        int quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Current_cpu_rq"});
        ss.modifyAttribute(timestamp, (Object)targetCpu.intValue(), quark);
        if (prio != null) {
            quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Prio"});
            ss.modifyAttribute(timestamp, (Object)prio, quark);
        }
    }
}

