/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickFixAddDefaultSwitch
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return QuickFixMessages.QuickFixAddDefaultSwitch_add_default_to_switch;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IASTTranslationUnit ast;
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTNode astNode = null;
        if (this.isCodanProblem(marker)) {
            astNode = this.getASTNodeFromMarker(marker, ast);
        }
        if (astNode == null || !(astNode instanceof IASTSwitchStatement)) {
            return;
        }
        ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)ast);
        INodeFactory factory = ast.getASTNodeFactory();
        IASTDefaultStatement defStatement = factory.newDefaultStatement();
        IASTBreakStatement breakStatement = factory.newBreakStatement();
        IASTNode[] children = astNode.getChildren();
        IASTCompoundStatement compound = null;
        IASTNullStatement nullStatement = null;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IASTCompoundStatement) {
                compound = (IASTCompoundStatement)children[i];
                break;
            }
            if (children[i] instanceof IASTNullStatement) {
                nullStatement = (IASTNullStatement)children[i];
            }
            ++i;
        }
        if (compound == null && nullStatement != null) {
            compound = factory.newCompoundStatement();
            compound.addStatement((IASTStatement)defStatement);
            compound.addStatement((IASTStatement)breakStatement);
            r.replace((IASTNode)nullStatement, (IASTNode)compound, null);
        } else if (compound != null) {
            r.insertBefore((IASTNode)compound, null, (IASTNode)defStatement, null);
            r.insertBefore((IASTNode)compound, null, (IASTNode)breakStatement, null);
        } else {
            return;
        }
        Change c = r.rewriteAST();
        try {
            c.perform((IProgressMonitor)new NullProgressMonitor());
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }
}

