/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;

class ImageDataImageDescriptor
extends ImageDescriptor {
    private final ImageDataProvider dataProvider;
    private final Image originalImage;

    ImageDataImageDescriptor(Image originalImage) {
        this.dataProvider = arg_0 -> ((Image)originalImage).getImageData(arg_0);
        this.originalImage = originalImage;
    }

    @Deprecated
    ImageDataImageDescriptor(ImageData data) {
        this(zoom -> zoom == 100 ? data : null);
    }

    ImageDataImageDescriptor(ImageDataProvider provider) {
        this.dataProvider = provider;
        this.originalImage = null;
    }

    @Override
    public Object createResource(Device device) throws DeviceResourceException {
        if (this.originalImage != null && this.originalImage.getDevice() == device) {
            return this.originalImage;
        }
        return super.createResource(device);
    }

    @Override
    public void destroyResource(Object previouslyCreatedObject) {
        if (previouslyCreatedObject != this.originalImage) {
            super.destroyResource(previouslyCreatedObject);
        }
    }

    @Override
    public ImageData getImageData(int zoom) {
        return this.dataProvider.getImageData(zoom);
    }

    public int hashCode() {
        if (this.originalImage != null) {
            return System.identityHashCode(this.originalImage);
        }
        return this.dataProvider.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void imgWrap;
        if (!(obj instanceof ImageDataImageDescriptor)) {
            return false;
        }
        ImageDataImageDescriptor imageDataImageDescriptor = (ImageDataImageDescriptor)obj;
        if (this.originalImage != null) {
            return imgWrap.originalImage == this.originalImage;
        }
        return imgWrap.originalImage == null && this.dataProvider.equals(imgWrap.dataProvider);
    }
}

