/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.text.c.hover.AnnotationExpandHover;
import org.eclipse.cdt.internal.ui.text.c.hover.AnnotationExpansionControl;
import org.eclipse.cdt.internal.ui.text.c.hover.CHoverMessages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class CExpandHover
extends AnnotationExpandHover {
    private static final String ANNOTATION_TYPE_BREAKPOINT = "org.eclipse.cdt.debug.core.breakpoint";
    public static final String NO_BREAKPOINT_ANNOTATION = "org.eclipse.cdt.internal.ui.NoBreakpointAnnotation";
    private AnnotationPreferenceLookup fLookup = new AnnotationPreferenceLookup();
    private IPreferenceStore fStore = CUIPlugin.getDefault().getCombinedPreferenceStore();

    public CExpandHover(CompositeRuler ruler, IAnnotationAccess access, IDoubleClickListener doubleClickListener) {
        super(ruler, access, doubleClickListener);
    }

    @Override
    protected Object getHoverInfoForLine(final ISourceViewer viewer, final int line) {
        boolean showTemporaryProblems = PreferenceConstants.getPreferenceStore().getBoolean("handleTemporaryProblems");
        IAnnotationModel model = viewer.getAnnotationModel();
        IDocument document = viewer.getDocument();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        HashMap<Position, Object> messagesAtPosition = new HashMap<Position, Object>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            String key;
            AnnotationPreference pref;
            Annotation annotation = (Annotation)e.next();
            if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && !((IAnnotationAccessExtension)this.fAnnotationAccess).isPaintable(annotation) || annotation instanceof ICAnnotation && !this.isIncluded((ICAnnotation)annotation, showTemporaryProblems) || (pref = this.fLookup.getAnnotationPreference(annotation)) != null && (key = pref.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key) || (position = model.getPosition(annotation)) == null || this.compareRulerLine(position, document, line) != 1 || this.isDuplicateMessage(messagesAtPosition, position, annotation.getText())) continue;
            exact.add(annotation);
        }
        this.sort(exact, model);
        if (exact.size() > 0) {
            this.setLastRulerMouseLocation(viewer, line);
        }
        if (exact.size() > 0 && !this.containsBreakpointAnnotation(exact)) {
            exact.add(new NoBreakpointAnnotation());
        }
        if (exact.size() <= 1) {
            return null;
        }
        AnnotationExpansionControl.AnnotationHoverInput input = new AnnotationExpansionControl.AnnotationHoverInput();
        input.fAnnotations = exact.toArray(new Annotation[0]);
        input.fViewer = viewer;
        input.fRulerInfo = this.fCompositeRuler;
        input.fAnnotationListener = this.fgListener;
        input.fDoubleClickListener = this.fDblClickListener;
        input.redoAction = new AnnotationExpansionControl.ICallback(){

            @Override
            public void run(IInformationControlExtension2 control) {
                control.setInput(CExpandHover.this.getHoverInfoForLine(viewer, line));
            }
        };
        input.model = model;
        return input;
    }

    private boolean isIncluded(ICAnnotation annotation, boolean showTemporaryProblems) {
        if (annotation instanceof CDocumentProvider.ProblemAnnotation && "org.eclipse.ui.workbench.texteditor.task".equals(annotation.getType())) {
            return false;
        }
        if (!annotation.isProblem()) {
            return true;
        }
        if (annotation.isMarkedDeleted() && !annotation.hasOverlay()) {
            return true;
        }
        if (annotation.hasOverlay() && !annotation.isMarkedDeleted()) {
            return true;
        }
        if (annotation.hasOverlay()) {
            return !this.isIncluded(annotation.getOverlay(), showTemporaryProblems);
        }
        return showTemporaryProblems;
    }

    @Override
    protected int getAnnotationOffsetForSort(IAnnotationModel model, Annotation a) {
        if (this.isBreakpointAnnotation(a)) {
            return Integer.MAX_VALUE;
        }
        return model.getPosition((Annotation)a).offset;
    }

    @Override
    protected int getOrder(Annotation annotation) {
        if (this.isBreakpointAnnotation(annotation)) {
            return 0;
        }
        return super.getOrder(annotation);
    }

    private boolean isBreakpointAnnotation(Annotation a) {
        return a.getType().equals(ANNOTATION_TYPE_BREAKPOINT);
    }

    private boolean containsBreakpointAnnotation(List<Annotation> annotations) {
        for (Annotation a : annotations) {
            if (!this.isBreakpointAnnotation(a)) continue;
            return true;
        }
        return false;
    }

    private static class NoBreakpointAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        public NoBreakpointAnnotation() {
            super(CExpandHover.NO_BREAKPOINT_ANNOTATION, false, CHoverMessages.CExpandHover_tooltip_noBreakpoint);
        }

        public void paint(GC gc, Canvas canvas, Rectangle bounds) {
            Image fImage = CDTSharedImages.getImage("icons/obj16/field_public_obj.gif");
            ImageUtilities.drawImage((Image)fImage, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
        }

        public int getLayer() {
            return 0;
        }
    }
}

