/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.ChangeConfigAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ChangeBuildConfigContribution
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        HashSet<IProject> projects = ChangeBuildConfigContribution.findProjects();
        TreeSet<String> configNames = new TreeSet<String>();
        String sCurrentConfig = null;
        boolean bCurrentConfig = true;
        for (IProject prj : projects) {
            ICConfigurationDescription[] cfgDescs = ChangeBuildConfigContribution.getCfgs(prj);
            String sActiveConfig = null;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs;
            int n = cfgDescs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray[n2];
                String s = cfgDesc.getName();
                if (!configNames.contains(s)) {
                    configNames.add(s);
                }
                if (cfgDesc.isActive()) {
                    sActiveConfig = s;
                }
                ++n2;
            }
            if (!bCurrentConfig) continue;
            if (sCurrentConfig == null) {
                sCurrentConfig = sActiveConfig;
                continue;
            }
            if (sCurrentConfig.equals(sActiveConfig)) continue;
            bCurrentConfig = false;
        }
        ArrayList<ActionContributionItem> actions = new ArrayList<ActionContributionItem>();
        int accel = 0;
        for (String sName : configNames) {
            String sDesc = null;
            boolean commonName = true;
            boolean commonDesc = true;
            boolean firstProj = true;
            for (IProject prj : projects) {
                ICConfigurationDescription[] cfgDescs = ChangeBuildConfigContribution.getCfgs(prj);
                int i = 0;
                while (i < cfgDescs.length) {
                    if (cfgDescs[i].getName().equals(sName)) {
                        String sNewDesc = cfgDescs[i].getDescription();
                        if (sNewDesc != null && sNewDesc.length() == 0) {
                            sNewDesc = null;
                        }
                        if (!commonDesc) break;
                        if (firstProj) {
                            sDesc = sNewDesc;
                            firstProj = false;
                            break;
                        }
                        if ((sNewDesc != null || sDesc == null) && (sNewDesc == null || sNewDesc.equals(sDesc))) break;
                        commonDesc = false;
                        break;
                    }
                    ++i;
                }
                if (i != cfgDescs.length) continue;
                commonName = false;
                break;
            }
            if (!commonName) continue;
            StringBuffer builder = new StringBuffer(sName);
            if (commonDesc) {
                if (sDesc != null) {
                    builder.append(" (");
                    builder.append(sDesc);
                    builder.append(")");
                }
            } else {
                builder.append(" (...)");
            }
            ChangeConfigAction action = new ChangeConfigAction(projects, sName, builder.toString(), accel + 1);
            if (bCurrentConfig && sCurrentConfig != null && sCurrentConfig.equals(sName)) {
                action.setChecked(true);
            }
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            actions.add(item);
            ++accel;
        }
        return actions.toArray(new IContributionItem[0]);
    }

    private static HashSet<IProject> findProjects() {
        LinkedHashSet<IProject> fProjects = new LinkedHashSet<IProject>();
        ISelection selection = CUIPlugin.getActivePage().getSelection();
        boolean badObject = ChangeBuildConfigContribution.addProjectsFromSelection(selection, fProjects);
        if (badObject || fProjects.isEmpty()) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (projects != null && projects.length == 1) {
                IProject project = projects[0];
                if (CoreModel.getDefault().isNewStyleProject(project) && ChangeBuildConfigContribution.getCfgs(project).length > 0) {
                    fProjects.add(project);
                }
            }
            IWorkbenchPage page = CUIPlugin.getActivePage();
            int viewCount = 0;
            if (page != null) {
                ISelection cdtSelection;
                IViewPart view;
                IViewReference theViewRef = null;
                IViewReference viewRef = null;
                theViewRef = page.findViewReference("org.eclipse.cdt.ui.CView");
                viewCount += theViewRef != null ? 1 : 0;
                viewRef = page.findViewReference("org.eclipse.ui.navigator.ProjectExplorer");
                viewCount += viewRef != null ? 1 : 0;
                theViewRef = theViewRef == null ? viewRef : theViewRef;
                viewRef = page.findViewReference("org.eclipse.ui.views.ResourceNavigator");
                IViewReference iViewReference = theViewRef = theViewRef == null ? viewRef : theViewRef;
                if (theViewRef != null && (viewCount += viewRef != null ? 1 : 0) == 1 && (view = theViewRef.getView(false)) != null && (cdtSelection = view.getSite().getSelectionProvider().getSelection()) != null && !cdtSelection.isEmpty() && !cdtSelection.equals(selection)) {
                    ChangeBuildConfigContribution.addProjectsFromSelection(cdtSelection, fProjects);
                }
            }
        }
        return fProjects;
    }

    private static boolean addProjectsFromSelection(ISelection selection, HashSet<IProject> fProjects) {
        boolean badObject = false;
        if (selection != null) {
            IEditorPart epart;
            IResource resource;
            IWorkbenchPart part;
            IWorkbenchPage page;
            IWorkbenchWindow window;
            if (selection instanceof IStructuredSelection) {
                Object o;
                IWorkbenchPart part2;
                IWorkbenchPage page2;
                if (selection.isEmpty() && (page2 = CUIPlugin.getActivePage()) != null && (part2 = page2.getActivePart()) != null && (o = part2.getAdapter(IResource.class)) != null && o instanceof IResource) {
                    fProjects.add(((IResource)o).getProject());
                }
                for (Object selItem : (IStructuredSelection)selection) {
                    Object adapter;
                    IProject project = null;
                    if (selItem instanceof ICElement) {
                        ICProject cproject = ((ICElement)selItem).getCProject();
                        if (cproject != null) {
                            project = cproject.getProject();
                        }
                    } else if (selItem instanceof IResource) {
                        project = ((IResource)selItem).getProject();
                    } else if (selItem instanceof IncludeRefContainer) {
                        ICProject fCProject = ((IncludeRefContainer)((Object)selItem)).getCProject();
                        if (fCProject != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IncludeReferenceProxy) {
                        ICProject fCProject;
                        IncludeRefContainer irc = ((IncludeReferenceProxy)((Object)selItem)).getIncludeRefContainer();
                        if (irc != null && (fCProject = irc.getCProject()) != null) {
                            project = fCProject.getProject();
                        }
                    } else if (selItem instanceof IAdaptable && (adapter = ((IAdaptable)selItem).getAdapter(IProject.class)) != null && adapter instanceof IProject) {
                        project = (IProject)adapter;
                    }
                    if (project != null) {
                        if (!CoreModel.getDefault().isNewStyleProject(project)) {
                            project = null;
                        } else {
                            ICConfigurationDescription[] tmp = ChangeBuildConfigContribution.getCfgs(project);
                            if (tmp.length == 0) {
                                project = null;
                            }
                        }
                    }
                    if (project != null) {
                        fProjects.add(project);
                        continue;
                    }
                    badObject = true;
                    break;
                }
            } else if (selection instanceof ITextSelection && (window = CUIPlugin.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) instanceof IEditorPart && (resource = (IResource)(epart = (IEditorPart)part).getEditorInput().getAdapter(IResource.class)) != null) {
                IProject project = resource.getProject();
                boolean bl = badObject = project == null || !CoreModel.getDefault().isNewStyleProject(project);
                if (!badObject) {
                    fProjects.add(project);
                }
            }
        }
        return badObject;
    }

    private static ICConfigurationDescription[] getCfgs(IProject prj) {
        ICConfigurationDescription[] cfgs;
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
        if (prjd != null && (cfgs = prjd.getConfigurations()) != null) {
            return cfgs;
        }
        return new ICConfigurationDescription[0];
    }
}

