/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class PreferenceScopeBlock {
    private Button fUseProjectSettings;
    private Button fStoreWithProject;
    private String fPrefPageID;
    private Link fLink;

    public PreferenceScopeBlock(String linkedPrefPageID) {
        this.fPrefPageID = linkedPrefPageID;
    }

    public void createControl(final Composite parent) {
        Composite group = ControlFactory.createComposite(parent, 2);
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gd = (GridData)group.getLayoutData();
        gd.horizontalIndent = 0;
        this.fUseProjectSettings = ControlFactory.createCheckBox(group, DialogsMessages.PreferenceScopeBlock_enableProjectSettings);
        Composite two = ControlFactory.createComposite(group, 1);
        two.setLayout((Layout)new TabFolderLayout());
        this.fStoreWithProject = ControlFactory.createCheckBox(two, DialogsMessages.PreferenceScopeBlock_storeWithProject);
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceScopeBlock.this.updateEnablement();
                PreferenceScopeBlock.this.onPreferenceScopeChange();
            }
        };
        this.fUseProjectSettings.addSelectionListener((SelectionListener)sl);
        this.fStoreWithProject.addSelectionListener((SelectionListener)sl);
        this.fLink = new Link(two, 0);
        this.fLink.setText(DialogsMessages.PreferenceScopeBlock_preferenceLink);
        this.fLink.setLayoutData((Object)new GridData());
        sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)PreferenceScopeBlock.this.fPrefPageID, null, null).open();
                PreferenceScopeBlock.this.onPreferenceScopeChange();
            }
        };
        this.fLink.addSelectionListener((SelectionListener)sl);
        Label horizontalLine = new Label(group, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(group.getFont());
    }

    protected abstract void onPreferenceScopeChange();

    private void updateEnablement() {
        if (this.fUseProjectSettings.getSelection()) {
            this.fLink.setVisible(false);
            this.fStoreWithProject.setVisible(true);
        } else {
            this.fStoreWithProject.setVisible(false);
            this.fLink.setVisible(true);
        }
        this.fUseProjectSettings.getParent().layout(true);
    }

    public void setProjectLocalScope() {
        this.fUseProjectSettings.setSelection(true);
        this.fStoreWithProject.setSelection(false);
        this.updateEnablement();
    }

    public void setProjectScope() {
        this.fUseProjectSettings.setSelection(true);
        this.fStoreWithProject.setSelection(true);
        this.updateEnablement();
    }

    public void setInstanceScope() {
        this.fUseProjectSettings.setSelection(false);
        this.fStoreWithProject.setSelection(false);
        this.updateEnablement();
    }

    public boolean isProjectLocalScope() {
        return this.fUseProjectSettings.getSelection() && !this.fStoreWithProject.getSelection();
    }

    public boolean isProjectScope() {
        return this.fUseProjectSettings.getSelection() && this.fStoreWithProject.getSelection();
    }

    public boolean isInstanceScope() {
        return !this.fUseProjectSettings.getSelection();
    }
}

