/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core.jsoncdb.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.jsoncdb.CompilationDatabaseInformation;
import org.eclipse.cdt.managedbuilder.core.jsoncdb.ICompilationDatabaseContributor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;

final class CompilationDatabaseContributionManager {
    private static final String ATTRIB_RUNNER = "runner";
    private static final String ATTRIB_TOOLCHAIN_ID = "toolchainID";
    private static final String ID_COMPILATIONDATABASE = "compilationDatabase";
    private static final String EXTENSION_ID = "compilationDatabaseContributor";
    private final @NonNull Map<String, ICompilationDatabaseContributor> loadedInstances = new HashMap<String, ICompilationDatabaseContributor>();
    private final Map<String, IConfigurationElement> factoryExtensions = new HashMap<String, IConfigurationElement>();
    private static CompilationDatabaseContributionManager instance;

    private CompilationDatabaseContributionManager() {
        this.initalise();
    }

    public static synchronized CompilationDatabaseContributionManager getInstance() {
        if (instance == null) {
            instance = new CompilationDatabaseContributionManager();
        }
        return instance;
    }

    private void initalise() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", EXTENSION_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (ID_COMPILATIONDATABASE.equals(configElement.getName())) {
                        String toolchainId = configElement.getAttribute(ATTRIB_TOOLCHAIN_ID);
                        String className = configElement.getAttribute(ATTRIB_RUNNER);
                        if (toolchainId != null && className != null) {
                            this.factoryExtensions.put(toolchainId, configElement);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public synchronized @NonNull ICompilationDatabaseContributor getCompilationDatabaseContributor(@NonNull IConfiguration config) {
        IToolChain toolChain = config.getToolChain();
        while (toolChain != null) {
            String toolchainId = toolChain.getBaseId();
            if (this.loadedInstances.containsKey(toolchainId)) {
                ICompilationDatabaseContributor contributor = this.loadedInstances.get(toolchainId);
                Assert.isNotNull((Object)contributor);
                return contributor;
            }
            if (this.factoryExtensions.containsKey(toolchainId)) {
                return this.createCdbInstance(toolchainId);
            }
            toolChain = toolChain.getSuperClass();
        }
        return new EmptyCompilationDatabaseContributor();
    }

    private @NonNull ICompilationDatabaseContributor createCdbInstance(String toolchainId) {
        IConfigurationElement ele = this.factoryExtensions.get(toolchainId);
        if (ele != null) {
            ICompilationDatabaseContributor loaded = null;
            try {
                loaded = (ICompilationDatabaseContributor)ele.createExecutableExtension(ATTRIB_RUNNER);
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).log(Status.error((String)"Not able to create instance", (Throwable)e));
            }
            if (loaded == null) {
                loaded = new EmptyCompilationDatabaseContributor();
            }
            this.loadedInstances.put(toolchainId, loaded);
            return loaded;
        }
        return new EmptyCompilationDatabaseContributor();
    }

    private class EmptyCompilationDatabaseContributor
    implements ICompilationDatabaseContributor {
        private EmptyCompilationDatabaseContributor() {
        }

        @Override
        public final @NonNull List<CompilationDatabaseInformation> getAdditionalFiles(@NonNull IConfiguration config) {
            return Collections.emptyList();
        }
    }
}

