/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.processes.CreateSourceFolder;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateIncludeFolder
extends CreateSourceFolder {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String targetPath = args[1].getSimpleValue();
        this.createSourceFolder(projectName, targetPath, monitor);
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)projectHandle);
        try {
            IConfiguration[] configs;
            IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ITool[] tools;
                IConfiguration config = iConfigurationArray[n2];
                String path = projectHandle.getFolder(targetPath).getLocation().toOSString();
                IToolChain toolChain = config.getToolChain();
                this.setIncludePathOptionForConfig(path, config, toolChain.getOptions(), toolChain);
                ITool[] iToolArray = tools = config.getTools();
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    this.setIncludePathOptionForConfig(path, config, tool.getOptions(), tool);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            throw new ProcessFailureException(Messages.getString((String)"CreateIncludeFolder.3") + e.getMessage(), (Throwable)e);
        }
        ManagedBuildManager.saveBuildInfo(projectHandle, true);
    }

    private void setIncludePathOptionForConfig(String path, IConfiguration config, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option.getValueType() == 4) {
                String[] includePaths = option.getIncludePaths();
                String[] newPaths = new String[includePaths.length + 1];
                System.arraycopy(includePaths, 0, newPaths, 0, includePaths.length);
                newPaths[includePaths.length] = path;
                ManagedBuildManager.setOption(config, optionHolder, option, newPaths);
            }
            ++n2;
        }
    }
}

