/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.prov.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.prov.engine.Messages;
import org.eclipse.equinox.prov.core.helpers.LogHelper;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.engine.ITouchpoint;
import org.eclipse.equinox.prov.metadata.TouchpointType;
import org.eclipse.osgi.util.NLS;

public class TouchpointManager
implements IRegistryChangeListener {
    private static TouchpointManager instance;
    private static final String PT_TOUCHPOINTS = "touchpoints";
    private static final String ELEMENT_TOUCHPOINT = "touchpoint";
    private static final String ELEMENT_TOUCHPOINT_DATA = "data";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_TYPE = "type";
    private Map touchpointEntries;

    public static TouchpointManager getInstance() {
        if (instance == null) {
            instance = new TouchpointManager();
        }
        return instance;
    }

    private TouchpointManager() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.equinox.prov.engine");
    }

    public ITouchpoint getTouchpoint(TouchpointType id) {
        TouchpointEntry entry;
        if (id == null || "".equals(id.getId())) {
            throw new IllegalArgumentException(Messages.TouchpointManager_Null_Touchpoint_Type_Argument);
        }
        if (this.touchpointEntries == null) {
            this.initializeTouchpoints();
        }
        return (entry = (TouchpointEntry)this.touchpointEntries.get(id.getId())) == null ? null : entry.getTouchpoint();
    }

    public ITouchpoint[] getAllTouchpoints() {
        if (this.touchpointEntries == null) {
            this.initializeTouchpoints();
        }
        Collection adapters = this.touchpointEntries.values();
        ArrayList<ITouchpoint> touchpoints = new ArrayList<ITouchpoint>(adapters.size());
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            TouchpointEntry entry = (TouchpointEntry)iter.next();
            ITouchpoint touchpoint = entry.getTouchpoint();
            if (touchpoint == null) continue;
            touchpoints.add(touchpoint);
        }
        return touchpoints.toArray(new ITouchpoint[touchpoints.size()]);
    }

    public ITouchpoint[] getCreatedTouchpoints() {
        if (this.touchpointEntries == null) {
            return new ITouchpoint[0];
        }
        Collection adapters = this.touchpointEntries.values();
        ArrayList<ITouchpoint> touchpoints = new ArrayList<ITouchpoint>(adapters.size());
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            ITouchpoint touchpoint;
            TouchpointEntry entry = (TouchpointEntry)iter.next();
            if (!entry.hasTouchpoint() || (touchpoint = entry.getTouchpoint()) == null) continue;
            touchpoints.add(touchpoint);
        }
        return touchpoints.toArray(new ITouchpoint[touchpoints.size()]);
    }

    public IStatus validateTouchpoints(String[] requiredTypes) {
        MultiStatus status = this.touchpointEntries == null ? this.initializeTouchpoints() : new MultiStatus();
        int i = 0;
        while (i < requiredTypes.length) {
            TouchpointEntry entry = (TouchpointEntry)this.touchpointEntries.get(requiredTypes[i]);
            if (entry == null) {
                TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_Required_Touchpoint_Not_Found, (Object)requiredTypes[i]), status);
            }
            ++i;
        }
        return status;
    }

    private MultiStatus initializeTouchpoints() {
        MultiStatus status = new MultiStatus();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.equinox.prov.engine", PT_TOUCHPOINTS);
        if (point == null) {
            TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_No_Extension_Point, (Object)"org.eclipse.equinox.prov.engine", (Object)PT_TOUCHPOINTS), status);
            this.touchpointEntries = new HashMap(0);
            return status;
        }
        IExtension[] extensions = point.getExtensions();
        this.touchpointEntries = new HashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String elementName = elements[j].getName();
                if (!ELEMENT_TOUCHPOINT.equalsIgnoreCase(elements[j].getName())) {
                    if (!ELEMENT_TOUCHPOINT_DATA.equals(elementName)) {
                        TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_Incorrectly_Named_Extension, (Object)elements[j].getName(), (Object)ELEMENT_TOUCHPOINT), status);
                    }
                } else {
                    String id = elements[j].getAttribute(ATTRIBUTE_TYPE);
                    if (id == null) {
                        TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_Attribute_Not_Specified, (Object)ATTRIBUTE_TYPE), status);
                    } else if (this.touchpointEntries.get(id) == null) {
                        this.touchpointEntries.put(id, new TouchpointEntry(elements[j]));
                    } else {
                        TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_Conflicting_Touchpoint_Types, (Object)ATTRIBUTE_TYPE, (Object)id), status);
                    }
                }
                ++j;
            }
            ++i;
        }
        return status;
    }

    private static void reportError(String errorMsg, MultiStatus status) {
        Status errorStatus = new Status(4, "org.eclipse.equinox.prov.engine", 1, errorMsg, null);
        if (status != null) {
            status.add((IStatus)errorStatus);
        }
        LogHelper.log((IStatus)errorStatus);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.touchpointEntries = null;
    }

    private class TouchpointEntry {
        private IConfigurationElement element;
        private boolean createdExtension;
        private ITouchpoint touchpoint;

        public TouchpointEntry(IConfigurationElement element) {
            this.element = element;
            this.touchpoint = null;
            this.createdExtension = false;
        }

        public TouchpointEntry(IConfigurationElement element, ITouchpoint touchpoint) {
            this.element = element;
            this.touchpoint = touchpoint;
            this.createdExtension = touchpoint != null;
        }

        public boolean hasTouchpoint() {
            return this.touchpoint != null;
        }

        public ITouchpoint getTouchpoint() {
            if (!this.createdExtension) {
                String id = this.element.getAttribute(TouchpointManager.ATTRIBUTE_TYPE);
                try {
                    ITouchpoint touchpoint = (ITouchpoint)this.element.createExecutableExtension(TouchpointManager.ATTRIBUTE_CLASS);
                    if (touchpoint != null) {
                        if (!id.equals(touchpoint.getTouchpointType().getId())) {
                            TouchpointManager.reportError(NLS.bind((String)Messages.TouchpointManager_Touchpoint_Type_Mismatch, (Object)id, (Object)touchpoint.getTouchpointType().getId()), null);
                        }
                    } else {
                        String errorMsg = NLS.bind((String)Messages.TouchpointManager_Null_Creating_Touchpoint_Extension, (Object)id);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.prov.engine", 1, errorMsg, null));
                    }
                    this.touchpoint = touchpoint;
                }
                catch (CoreException cexcpt) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.prov.engine", NLS.bind((String)Messages.TouchpointManager_Exception_Creating_Touchpoint_Extension, (Object)id), (Throwable)cexcpt));
                }
                catch (ClassCastException ccexcpt) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.prov.engine", NLS.bind((String)Messages.TouchpointManager_Exception_Creating_Touchpoint_Extension, (Object)id), (Throwable)ccexcpt));
                }
                this.createdExtension = true;
            }
            return this.touchpoint;
        }

        public String toString() {
            StringBuffer result = new StringBuffer(this.element.toString());
            if (this.createdExtension) {
                String touchpointString = this.touchpoint != null ? this.touchpoint.toString() : "not created";
                result.append(" => " + touchpointString);
            }
            return result.toString();
        }
    }
}

