/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.support;

import java.util.Dictionary;
import java.util.Map;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.eclipse.virgo.teststubs.osgi.support.AbstractFilter;
import org.osgi.framework.ServiceReference;

public final class ObjectClassFilter
extends AbstractFilter {
    private static final String FILTER_STRING_FORMAT = "(objectClass=%s)";
    private final String className;

    public ObjectClassFilter(Class<?> clazz) {
        Assert.assertNotNull(clazz, "clazz");
        this.className = clazz.getName();
    }

    public ObjectClassFilter(String className) {
        Assert.assertNotNull(className, "className");
        this.className = className;
    }

    public boolean match(ServiceReference<?> reference) {
        return this.contains((String[])reference.getProperty("objectClass"), this.className);
    }

    public boolean match(Dictionary<String, ?> dictionary) {
        return this.contains((String[])dictionary.get("objectClass"), this.className);
    }

    public boolean matchCase(Dictionary<String, ?> dictionary) {
        return this.match(dictionary);
    }

    @Override
    public String getFilterString() {
        return String.format(FILTER_STRING_FORMAT, this.className);
    }

    public boolean matches(Map<String, ?> map) {
        return this.contains((String[])map.get("objectClass"), this.className);
    }

    private boolean contains(String[] strings, String toMatch) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (toMatch.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

