/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractCMRelaxNGCollector;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.CMRelaxNGAttributeDeclaration;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclaration;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.RequiredAttributesFunction;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;

public class CMRelaxNGAttributeDeclarationCollector
extends AbstractCMRelaxNGCollector {
    private final CMRelaxNGElementDeclaration elementDeclaration;
    private final Collection<CMAttributeDeclaration> attributes;

    public CMRelaxNGAttributeDeclarationCollector(CMRelaxNGElementDeclaration elementDeclaration, Pattern pattern) {
        this.elementDeclaration = elementDeclaration;
        this.attributes = new ArrayList<CMAttributeDeclaration>();
        pattern.apply(this);
        if (!this.attributes.isEmpty()) {
            RequiredAttributesFunction attributesFunction = new RequiredAttributesFunction();
            Set<Name> requiredAttributeNames = pattern.apply(attributesFunction);
            for (Name requiredAttributeName : requiredAttributeNames) {
                for (CMAttributeDeclaration attribute : this.attributes) {
                    CMRelaxNGAttributeDeclaration rngAttribute = (CMRelaxNGAttributeDeclaration)attribute;
                    if (!requiredAttributeName.equals(rngAttribute.getJingName())) continue;
                    rngAttribute.setRequired(true);
                }
            }
        }
    }

    @Override
    public VoidValue caseAttribute(AttributePattern p) {
        NameClass nameClass = p.getNameClass();
        if (nameClass instanceof SimpleNameClass) {
            CMRelaxNGAttributeDeclaration attributeDeclaration = new CMRelaxNGAttributeDeclaration(this.elementDeclaration, p);
            this.attributes.add(attributeDeclaration);
        }
        return VoidValue.VOID;
    }

    public Collection<CMAttributeDeclaration> getAttributes() {
        return this.attributes;
    }
}

