"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("@theia/core/shared/inversify");
const backend_application_1 = require("@theia/core/lib/node/backend-application");
const file_download_endpoint_1 = require("./file-download-endpoint");
const file_download_handler_1 = require("./file-download-handler");
const directory_archiver_1 = require("./directory-archiver");
const file_download_cache_1 = require("./file-download-cache");
exports.default = new inversify_1.ContainerModule(bind => {
    bind(file_download_endpoint_1.FileDownloadEndpoint).toSelf().inSingletonScope();
    bind(backend_application_1.BackendApplicationContribution).toService(file_download_endpoint_1.FileDownloadEndpoint);
    bind(file_download_cache_1.FileDownloadCache).toSelf().inSingletonScope();
    bind(file_download_handler_1.FileDownloadHandler).to(file_download_handler_1.SingleFileDownloadHandler).inSingletonScope().whenTargetNamed(file_download_handler_1.FileDownloadHandler.SINGLE);
    bind(file_download_handler_1.FileDownloadHandler).to(file_download_handler_1.MultiFileDownloadHandler).inSingletonScope().whenTargetNamed(file_download_handler_1.FileDownloadHandler.MULTI);
    bind(file_download_handler_1.FileDownloadHandler).to(file_download_handler_1.DownloadLinkHandler).inSingletonScope().whenTargetNamed(file_download_handler_1.FileDownloadHandler.DOWNLOAD_LINK);
    bind(directory_archiver_1.DirectoryArchiver).toSelf().inSingletonScope();
});
//# sourceMappingURL=file-download-backend-module.js.map