"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.HoverParticipantRegistry = exports.HoverForeignElementAnchor = exports.HoverRangeAnchor = void 0;
class HoverRangeAnchor {
    constructor(priority, range) {
        this.priority = priority;
        this.range = range;
        this.type = 1 /* Range */;
    }
    equals(other) {
        return (other.type === 1 /* Range */ && this.range.equalsRange(other.range));
    }
    canAdoptVisibleHover(lastAnchor, showAtPosition) {
        return (lastAnchor.type === 1 /* Range */ && showAtPosition.lineNumber === this.range.startLineNumber);
    }
}
exports.HoverRangeAnchor = HoverRangeAnchor;
class HoverForeignElementAnchor {
    constructor(priority, owner, range) {
        this.priority = priority;
        this.owner = owner;
        this.range = range;
        this.type = 2 /* ForeignElement */;
    }
    equals(other) {
        return (other.type === 2 /* ForeignElement */ && this.owner === other.owner);
    }
    canAdoptVisibleHover(lastAnchor, showAtPosition) {
        return (lastAnchor.type === 2 /* ForeignElement */ && this.owner === lastAnchor.owner);
    }
}
exports.HoverForeignElementAnchor = HoverForeignElementAnchor;
exports.HoverParticipantRegistry = (new class HoverParticipantRegistry {
    constructor() {
        this._participants = [];
    }
    register(ctor) {
        this._participants.push(ctor);
    }
    getAll() {
        return this._participants;
    }
}());
//# sourceMappingURL=hoverTypes.js.map