"use strict";
// *****************************************************************************
// Copyright (C) 2022 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferenceSingleFilePathInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceSingleFilePathInputRenderer = exports.PreferenceSingleFilePathInputRendererContribution = exports.FileNodeTypeDetails = void 0;
const nls_1 = require("@theia/core/lib/common/nls");
const inversify_1 = require("@theia/core/shared/inversify");
const file_dialog_service_1 = require("@theia/filesystem/lib/browser/file-dialog/file-dialog-service");
const browser_1 = require("@theia/workspace/lib/browser");
const preference_node_renderer_creator_1 = require("./preference-node-renderer-creator");
const preference_string_input_1 = require("./preference-string-input");
var FileNodeTypeDetails;
(function (FileNodeTypeDetails) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function is(typeDetails) {
        return !!typeDetails && !!typeDetails.isFilepath;
    }
    FileNodeTypeDetails.is = is;
})(FileNodeTypeDetails = exports.FileNodeTypeDetails || (exports.FileNodeTypeDetails = {}));
let PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution_1 = class PreferenceSingleFilePathInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceSingleFilePathInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        var _a;
        const typeDetails = node.preference.data.typeDetails;
        return FileNodeTypeDetails.is(typeDetails) && !((_a = typeDetails.selectionProps) === null || _a === void 0 ? void 0 : _a.canSelectMany) ? 5 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceSingleFilePathInputRenderer);
    }
};
PreferenceSingleFilePathInputRendererContribution.ID = 'preference-single-file-path-input-renderer';
PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution_1 = __decorate([
    (0, inversify_1.injectable)()
], PreferenceSingleFilePathInputRendererContribution);
exports.PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution;
let PreferenceSingleFilePathInputRenderer = class PreferenceSingleFilePathInputRenderer extends preference_string_input_1.PreferenceStringInputRenderer {
    get typeDetails() {
        return this.preferenceNode.preference.data.typeDetails;
    }
    createInputWrapper() {
        const inputWrapper = document.createElement('div');
        inputWrapper.classList.add('preference-file-container');
        return inputWrapper;
    }
    createInteractable(parent) {
        const inputWrapper = this.createInputWrapper();
        super.createInteractable(inputWrapper);
        this.interactable.classList.add('preference-file-input');
        this.createBrowseButton(inputWrapper);
        parent.appendChild(inputWrapper);
    }
    createBrowseButton(parent) {
        const button = document.createElement('button');
        button.classList.add('theia-button', 'main', 'preference-file-button');
        button.textContent = nls_1.nls.localize('theia/core/file/browse', 'Browse');
        const handler = this.browse.bind(this);
        button.onclick = handler;
        button.onkeydown = handler;
        button.tabIndex = 0;
        button.setAttribute('aria-label', 'Submit Preference Input');
        parent.appendChild(button);
    }
    async browse() {
        var _a;
        const selectionProps = this.typeDetails.selectionProps;
        const title = ((_a = selectionProps === null || selectionProps === void 0 ? void 0 : selectionProps.title) !== null && _a !== void 0 ? _a : selectionProps === null || selectionProps === void 0 ? void 0 : selectionProps.canSelectFolders) ? browser_1.WorkspaceCommands.OPEN_FOLDER.dialogLabel : browser_1.WorkspaceCommands.OPEN_FILE.dialogLabel;
        const selection = await this.fileDialogService.showOpenDialog(Object.assign({ title }, selectionProps));
        if (selection) {
            this.setPreferenceImmediately(selection.path.toString());
        }
    }
    setPreferenceImmediately(value) {
        this.interactable.value = value;
        return super.setPreferenceImmediately(value);
    }
};
__decorate([
    (0, inversify_1.inject)(file_dialog_service_1.FileDialogService),
    __metadata("design:type", Object)
], PreferenceSingleFilePathInputRenderer.prototype, "fileDialogService", void 0);
PreferenceSingleFilePathInputRenderer = __decorate([
    (0, inversify_1.injectable)()
], PreferenceSingleFilePathInputRenderer);
exports.PreferenceSingleFilePathInputRenderer = PreferenceSingleFilePathInputRenderer;
//# sourceMappingURL=preference-file-input.js.map