"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceServerUrlProviderImpl = void 0;
const core_1 = require("@theia/core");
const env_variables_protocol_1 = require("@theia/core/lib/common/env-variables/env-variables-protocol");
const inversify_1 = require("inversify");
const trace_server_config_1 = require("../common/trace-server-config");
const trace_server_url_provider_1 = require("../common/trace-server-url-provider");
const trace_server_preference_1 = require("./trace-server-preference");
let TraceServerUrlProviderImpl = class TraceServerUrlProviderImpl {
    constructor(environment, tracePreferences, traceServerConfigService, messageService) {
        this.environment = environment;
        this.tracePreferences = tracePreferences;
        this.traceServerConfigService = traceServerConfigService;
        this.messageService = messageService;
        this._onDidChangeTraceServerUrlEmitter = new core_1.Emitter();
        this._traceServerUrlPromise = new Promise(resolve => {
            const self = this.onDidChangeTraceServerUrl(url => {
                self.dispose();
                resolve(url);
            });
        });
        // Get the URL template from the remote environment.
        this.environment.getValue('TRACE_SERVER_URL').then(variable => {
            const url = variable === null || variable === void 0 ? void 0 : variable.value;
            this._traceServerUrlTemplate = url
                ? this.normalizeUrl(url)
                : trace_server_url_provider_1.TRACE_SERVER_DEFAULT_URL;
            this.updateTraceServerUrl();
        });
        // Get the configurable port from Theia's preferences.
        this.tracePreferences.ready.then(() => {
            this._traceServerPort = this.tracePreferences[trace_server_preference_1.TRACE_PORT];
            this.updateTraceServerUrl();
            this.tracePreferences.onPreferenceChanged(async (event) => {
                if (event.preferenceName === trace_server_preference_1.TRACE_PORT) {
                    this._traceServerPort = event.newValue;
                    this.updateTraceServerUrl();
                    try {
                        await this.traceServerConfigService.stopTraceServer();
                        this.messageService.info(`Trace server disconnected on port: ${event.oldValue}.`);
                    }
                    catch (_) {
                        // Do not show the error incase the user tries to modify the port before starting a server
                    }
                }
            });
        });
    }
    /**
     * Listen for updates to the Trace Server URL.
     * Fired when Trace Server URL is first initiliazed and when the `TRACE_PORT` preference changes.
     */
    get onDidChangeTraceServerUrl() {
        return this._onDidChangeTraceServerUrlEmitter.event;
    }
    async initialize() {
        // Don't start the application until the Trace Server URL is initialized.
        await this._traceServerUrlPromise;
    }
    async getTraceServerUrlPromise() {
        return this._traceServerUrlPromise;
    }
    getTraceServerUrl() {
        if (this._traceServerUrl === undefined) {
            throw new Error('The Trace Server URL is not yet defined. Try using getTraceServerUrlPromise.');
        }
        return this._traceServerUrl;
    }
    normalizeUrl(url) {
        url = url.toLowerCase();
        // Add missing http protocol.
        if (!url.startsWith('http://') && !url.startsWith('https://')) {
            url = 'http://' + url;
        }
        // Remove trailing `/`.
        if (url.endsWith('/')) {
            url = url.substring(0, url.length - 1);
        }
        return url;
    }
    updateTraceServerUrl() {
        if (this._traceServerUrlTemplate === undefined || this._traceServerPort === undefined) {
            return; // State is only partially initialized = try again later.
        }
        const traceServerUrl = this._traceServerUrlTemplate.replace(/{}/g, this._traceServerPort.toString());
        this._traceServerUrl = traceServerUrl;
        this._traceServerUrlPromise = Promise.resolve(traceServerUrl);
        this._onDidChangeTraceServerUrlEmitter.fire(traceServerUrl);
    }
};
TraceServerUrlProviderImpl = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(env_variables_protocol_1.EnvVariablesServer)),
    __param(1, (0, inversify_1.inject)(trace_server_preference_1.TracePreferences)),
    __param(2, (0, inversify_1.inject)(trace_server_config_1.TraceServerConfigService)),
    __param(3, (0, inversify_1.inject)(core_1.MessageService)),
    __metadata("design:paramtypes", [Object, Object, Object, core_1.MessageService])
], TraceServerUrlProviderImpl);
exports.TraceServerUrlProviderImpl = TraceServerUrlProviderImpl;
//# sourceMappingURL=trace-server-url-provider-frontend-impl.js.map