"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTreeOutputComponent = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const abstract_output_component_1 = require("./abstract-output-component");
const React = __importStar(require("react"));
const query_helper_1 = require("tsp-typescript-client/lib/models/query/query-helper");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const entry_tree_1 = require("./utils/filter-tree/entry-tree");
const utils_1 = require("./utils/filter-tree/utils");
const lodash_debounce_1 = __importDefault(require("lodash.debounce"));
class DataTreeOutputComponent extends abstract_output_component_1.AbstractOutputComponent {
    constructor(props) {
        super(props);
        this.treeRef = React.createRef();
        this._debouncedFetchSelectionData = (0, lodash_debounce_1.default)(() => this.fetchSelectionData(), 500);
        this.state = {
            outputStatus: responses_1.ResponseStatus.RUNNING,
            selectedSeriesId: [],
            xyTree: [],
            collapsedNodes: [],
            orderedNodes: [],
            columns: [{ title: 'Name', sortable: true }],
        };
    }
    componentDidMount() {
        this.waitAnalysisCompletion();
    }
    async fetchTree() {
        const parameters = query_helper_1.QueryHelper.timeQuery([this.props.range.getStart(), this.props.range.getEnd()]);
        // TODO: use the data tree endpoint instead of the xy tree endpoint
        const tspClientResponse = await this.props.tspClient.fetchXYTree(this.props.traceId, this.props.outputDescriptor.id, parameters);
        const treeResponse = tspClientResponse.getModel();
        if (tspClientResponse.isOk() && treeResponse) {
            if (treeResponse.model) {
                const headers = treeResponse.model.headers;
                const columns = [];
                if (headers && headers.length > 0) {
                    headers.forEach(header => {
                        columns.push({ title: header.name, sortable: true, resizable: true, tooltip: header.tooltip });
                    });
                }
                else {
                    columns.push({ title: 'Name', sortable: true });
                }
                this.setState({
                    outputStatus: treeResponse.status,
                    xyTree: treeResponse.model.entries,
                    columns
                });
            }
            else {
                this.setState({
                    outputStatus: treeResponse.status
                });
            }
            return treeResponse.status;
        }
        this.setState({
            outputStatus: responses_1.ResponseStatus.FAILED
        });
        return responses_1.ResponseStatus.FAILED;
    }
    resultsAreEmpty() {
        return this.state.xyTree.length === 0;
    }
    renderTree() {
        this.onToggleCollapse = this.onToggleCollapse.bind(this);
        this.onOrderChange = this.onOrderChange.bind(this);
        return this.state.xyTree.length
            ? React.createElement("div", { tabIndex: 0, id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: 'scrollable', style: { height: this.props.style.height, width: this.getMainAreaWidth() } },
                React.createElement(entry_tree_1.EntryTree, { entries: this.state.xyTree, showCheckboxes: false, collapsedNodes: this.state.collapsedNodes, onToggleCollapse: this.onToggleCollapse, onOrderChange: this.onOrderChange, headers: this.state.columns }))
            : undefined;
    }
    renderMainArea() {
        return React.createElement(React.Fragment, null, this.state.outputStatus === responses_1.ResponseStatus.COMPLETED ?
            React.createElement("div", { ref: this.treeRef, className: 'output-component-tree disable-select', style: { height: this.props.style.height, width: this.props.outputWidth } }, this.renderTree()) :
            React.createElement("div", { tabIndex: 0, id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: 'analysis-running-main-area' },
                React.createElement("i", { className: 'fa fa-refresh fa-spin', style: { marginRight: '5px' } }),
                React.createElement("span", null, "Analysis running")));
    }
    setFocus() {
        var _a, _b;
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) {
            (_a = document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = document.getElementById(this.props.traceId + this.props.outputDescriptor.id)) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }
    onToggleCollapse(id, nodes) {
        let newList = [...this.state.collapsedNodes];
        const exist = this.state.collapsedNodes.find(expandId => expandId === id);
        if (exist !== undefined) {
            newList = newList.filter(collapsed => id !== collapsed);
        }
        else {
            newList = newList.concat(id);
        }
        const orderedIds = (0, utils_1.getAllExpandedNodeIds)(nodes, newList);
        this.setState({ collapsedNodes: newList, orderedNodes: orderedIds });
    }
    onOrderChange(ids) {
        this.setState({ orderedNodes: ids });
    }
    async waitAnalysisCompletion() {
        let outputStatus = this.state.outputStatus;
        const timeout = 500;
        while (this.state && outputStatus === responses_1.ResponseStatus.RUNNING) {
            outputStatus = await this.fetchTree();
            await new Promise(resolve => setTimeout(resolve, timeout));
        }
    }
    componentWillUnmount() {
        // fix Warning: Can't perform a React state update on an unmounted component
        this.setState = (_state, _callback) => undefined;
    }
    async fetchSelectionData() {
        if (this.props.selectionRange) {
            let payload;
            if (this.props.selectionRange.getStart() < this.props.selectionRange.getEnd()) {
                payload = query_helper_1.QueryHelper.timeQuery([this.props.selectionRange.getStart(), this.props.selectionRange.getEnd()]);
            }
            else {
                payload = query_helper_1.QueryHelper.timeQuery([this.props.selectionRange.getEnd(), this.props.selectionRange.getStart()]);
            }
            payload.parameters.isFiltered = true;
            // TODO: use the data tree endpoint instead of the xy tree endpoint
            const tspClientResponse = await this.props.tspClient.fetchXYTree(this.props.traceId, this.props.outputDescriptor.id, payload);
            const treeResponse = tspClientResponse.getModel();
            if (tspClientResponse.isOk() && treeResponse) {
                if (treeResponse.model) {
                    this.setState({
                        outputStatus: treeResponse.status,
                        xyTree: treeResponse.model.entries,
                    });
                }
            }
        }
    }
    async componentDidUpdate(prevProps) {
        if (this.props.selectionRange && this.props.selectionRange !== prevProps.selectionRange) {
            this._debouncedFetchSelectionData();
        }
    }
}
exports.DataTreeOutputComponent = DataTreeOutputComponent;
//# sourceMappingURL=datatree-output-component.js.map