"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactOpenTracesWidget = void 0;
const React = __importStar(require("react"));
const react_virtualized_1 = require("react-virtualized");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const react_modal_1 = __importDefault(require("react-modal"));
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const opened_traces_updated_signal_payload_1 = require("traceviewer-base/lib/signals/opened-traces-updated-signal-payload");
const free_solid_svg_icons_2 = require("@fortawesome/free-solid-svg-icons");
class ReactOpenTracesWidget extends React.Component {
    constructor(props) {
        super(props);
        this._forceUpdateKey = false;
        this._sharingLink = '';
        this._showShareDialog = false;
        this._onExperimentOpened = (experiment) => this.doHandleExperimentOpenedSignal(experiment);
        this._onExperimentClosed = (experiment) => this.doHandleExperimentClosed(experiment);
        this._onExperimentDeleted = (experiment) => this.doHandleExperimentDeletedSignal(experiment);
        this._onOpenedTracesWidgetActivated = (experiment) => this.doHandleTracesWidgetActivatedSignal(experiment);
        this._onTraceServerStarted = () => this.doHandleTraceServerStartedSignal();
        this.renderExperimentRow = (props) => this.doRenderExperimentRow(props);
        this.getRowHeight = (index) => this.doGetRowHeight(index);
        this.updateOpenedExperiments = async () => this.doUpdateOpenedExperiments();
        this.handleShareButtonClick = (index) => this.doHandleShareButtonClick(index);
        this.handleOnExperimentSelected = (e) => this.doHandleOnExperimentSelected(e);
        this.handleContextMenuEvent = (e, traceUUID) => this.doHandleContextMenuEvent(e, traceUUID);
        this.handleClickEvent = (e, traceUUID) => this.dohandleClickEvent(e, traceUUID);
        this.handleOnExperimentDeleted = (e, traceUUID) => this.doHandleOnExperimentDeleted(e, traceUUID);
        this.handleShareModalClose = () => this.doHandleShareModalClose();
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_OPENED, this._onExperimentOpened);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_DELETED, this._onExperimentDeleted);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.TRACEVIEWERTAB_ACTIVATED, this._onOpenedTracesWidgetActivated);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.TRACE_SERVER_STARTED, this._onTraceServerStarted);
        this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        this.props.tspClientProvider.addTspClientChangeListener(() => {
            this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        });
        this.state = { openedExperiments: [], selectedExperimentIndex: -1 };
    }
    componentDidMount() {
        this.initialize();
    }
    componentWillUnmount() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_OPENED, this._onExperimentOpened);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_DELETED, this._onExperimentDeleted);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.TRACEVIEWERTAB_ACTIVATED, this._onOpenedTracesWidgetActivated);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.TRACE_SERVER_STARTED, this._onTraceServerStarted);
    }
    async initialize() {
        await this.updateOpenedExperiments();
        this.updateSelectedExperiment();
    }
    async doHandleTraceServerStartedSignal() {
        await this.initialize();
    }
    async doHandleExperimentOpenedSignal(_experiment) {
        await this.initialize();
    }
    doHandleExperimentClosed(experiment) {
        var _a;
        if (((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) === experiment.UUID) {
            this._selectedExperiment = undefined;
            this.setState({ selectedExperimentIndex: -1 });
        }
    }
    async doHandleExperimentDeletedSignal(_experiment) {
        await this.initialize();
    }
    doHandleTracesWidgetActivatedSignal(experiment) {
        var _a;
        if (((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) !== experiment.UUID) {
            this._selectedExperiment = experiment;
            const selectedIndex = this.state.openedExperiments.findIndex(openedExperiment => openedExperiment.UUID === experiment.UUID);
            this.selectExperiment(selectedIndex);
        }
    }
    doHandleContextMenuEvent(event, traceUUID) {
        this.doHandleOnExperimentSelected(event);
        const experiment = this.getExperiment(traceUUID);
        if (experiment !== undefined && this.props.contextMenuRenderer) {
            this.props.contextMenuRenderer(event, experiment);
        }
        event.preventDefault();
        event.stopPropagation();
    }
    dohandleClickEvent(event, traceUUID) {
        this.doHandleOnExperimentSelected(event);
        const experiment = this.getExperiment(traceUUID);
        if (experiment !== undefined && this.props.onClick) {
            this.props.onClick(event, experiment);
        }
        event.preventDefault();
        event.stopPropagation();
    }
    getExperiment(traceUUID) {
        return this.state.openedExperiments.find(experiment => experiment.UUID === traceUUID);
    }
    render() {
        const totalHeight = this.getTotalHeight();
        this._forceUpdateKey = !this._forceUpdateKey;
        const key = Number(this._forceUpdateKey);
        return (React.createElement(React.Fragment, null,
            React.createElement(react_modal_1.default, { isOpen: this._showShareDialog, onRequestClose: this.handleShareModalClose, ariaHideApp: false, className: 'sharing-modal', overlayClassName: 'sharing-overlay' }, this.renderSharingModal()),
            React.createElement("div", { className: 'trace-explorer-opened' },
                React.createElement("div", { className: 'trace-explorer-panel-content', onClick: this.updateOpenedExperiments },
                    React.createElement(react_virtualized_1.AutoSizer, null, ({ width }) => React.createElement(react_virtualized_1.List, { key: key, height: totalHeight, width: width, rowCount: this.state.openedExperiments.length, rowHeight: this.getRowHeight, rowRenderer: this.renderExperimentRow }))))));
    }
    /*
        TODO: Implement better visualization of experiment, e.g. a tree
        with experiment name as root and traces (name and path) as children
     */
    doRenderExperimentRow(props) {
        const traceName = this.state.openedExperiments.length && props.index < this.state.openedExperiments.length
            ? this.state.openedExperiments[props.index].name : '';
        const traceUUID = this.state.openedExperiments.length && props.index < this.state.openedExperiments.length
            ? this.state.openedExperiments[props.index].UUID : '';
        let traceContainerClassName = 'trace-list-container';
        if (props.index === this.state.selectedExperimentIndex && this.state.selectedExperimentIndex >= 0) {
            traceContainerClassName = traceContainerClassName + ' theia-mod-selected';
        }
        return React.createElement("div", { className: traceContainerClassName, id: `${traceContainerClassName}-${props.index}`, key: props.key, style: props.style, onClick: event => { this.handleClickEvent(event, traceUUID); }, onContextMenu: event => { this.handleContextMenuEvent(event, traceUUID); }, "data-id": `${props.index}` },
            React.createElement("div", { className: 'trace-element-container' },
                React.createElement("div", { className: 'trace-element-info' },
                    React.createElement("h4", { className: 'trace-element-name' }, traceName),
                    this.renderTracesForExperiment(props.index)),
                React.createElement("div", { className: 'remove-trace-button-container', title: 'Remove trace from Trace Viewer' },
                    React.createElement("button", { "data-tip": true, "data-for": "removeTip", className: 'remove-trace-button', onClick: event => { this.handleOnExperimentDeleted(event, traceUUID); } },
                        React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_2.faTimes })))));
    }
    doHandleOnExperimentDeleted(e, traceUUID) {
        this._experimentManager.deleteExperiment(traceUUID);
        (0, signal_manager_1.signalManager)().fireCloseTraceViewerTabSignal(traceUUID);
        e.preventDefault();
        e.stopPropagation();
    }
    renderTracesForExperiment(index) {
        const tracePaths = this.state.openedExperiments[index].traces;
        return (React.createElement("div", { className: 'trace-element-path-container' }, tracePaths.map(trace => (React.createElement("div", { className: 'trace-element-path child-element', id: trace.UUID, key: trace.UUID }, ` > ${trace.name}`)))));
    }
    doGetRowHeight(index) {
        const resolvedIndex = typeof index === 'object' ? index.index : index;
        const experiment = this.state.openedExperiments[resolvedIndex];
        let totalHeight = 0;
        if (experiment.name) {
            totalHeight += ReactOpenTracesWidget.LINE_HEIGHT;
        }
        for (let i = 0; i < experiment.traces.length; i++) {
            totalHeight += ReactOpenTracesWidget.LINE_HEIGHT;
        }
        return totalHeight;
    }
    getTotalHeight() {
        let totalHeight = 0;
        for (let i = 0; i < this.state.openedExperiments.length; i++) {
            totalHeight += this.getRowHeight(i);
        }
        return totalHeight;
    }
    renderSharingModal() {
        if (this._sharingLink.length) {
            return React.createElement("div", { className: 'sharing-container' },
                React.createElement("div", { className: 'sharing-description' }, 'Copy URL to share your trace context'),
                React.createElement("div", { className: 'sharing-link-info' },
                    React.createElement("div", { className: 'sharing-link' },
                        React.createElement("textarea", { rows: 1, cols: this._sharingLink.length, readOnly: true, value: this._sharingLink })),
                    React.createElement("div", { className: 'sharing-link-copy' },
                        React.createElement("button", { className: 'copy-link-button' },
                            React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faCopy })))));
        }
        return React.createElement("div", { style: { color: 'white' } }, 'Cannot share this trace');
    }
    async doUpdateOpenedExperiments() {
        const remoteExperiments = await this._experimentManager.getOpenedExperiments();
        remoteExperiments.forEach(experiment => {
            this._experimentManager.addExperiment(experiment);
        });
        const selectedIndex = remoteExperiments.findIndex(experiment => this._selectedExperiment &&
            experiment.UUID === this._selectedExperiment.UUID);
        this.setState({ openedExperiments: remoteExperiments, selectedExperimentIndex: selectedIndex });
        (0, signal_manager_1.signalManager)().fireOpenedTracesChangedSignal(new opened_traces_updated_signal_payload_1.OpenedTracesUpdatedSignalPayload(remoteExperiments ? remoteExperiments.length : 0));
    }
    doHandleShareButtonClick(index) {
        const traceToShare = this.state.openedExperiments[index];
        this._sharingLink = 'https://localhost:3000/share/trace?' + traceToShare.UUID;
        this._showShareDialog = true;
        (0, signal_manager_1.signalManager)().fireOpenedTracesChangedSignal(new opened_traces_updated_signal_payload_1.OpenedTracesUpdatedSignalPayload(this.state.openedExperiments ? this.state.openedExperiments.length : 0));
    }
    doHandleOnExperimentSelected(e) {
        const index = Number(e.currentTarget.getAttribute('data-id'));
        this.selectExperiment(index);
    }
    selectExperiment(index) {
        if (index >= 0 && index !== this.state.selectedExperimentIndex) {
            this.setState({ selectedExperimentIndex: index });
            this._selectedExperiment = this.state.openedExperiments[index];
            (0, signal_manager_1.signalManager)().fireExperimentSelectedSignal(this._selectedExperiment);
        }
    }
    updateSelectedExperiment() {
        if (this.state.openedExperiments && this.state.selectedExperimentIndex >= 0 && this.state.selectedExperimentIndex < this.state.openedExperiments.length) {
            this._selectedExperiment = this.state.openedExperiments[this.state.selectedExperimentIndex];
            (0, signal_manager_1.signalManager)().fireExperimentSelectedSignal(this._selectedExperiment);
        }
    }
    onWidgetActivated(experiment) {
        if (experiment) {
            this._selectedExperiment = experiment;
            const selectedIndex = this.state.openedExperiments.findIndex(openedExperiment => openedExperiment.UUID === experiment.UUID);
            this.selectExperiment(selectedIndex);
        }
    }
    doHandleShareModalClose() {
        this._showShareDialog = false;
        this._sharingLink = '';
        (0, signal_manager_1.signalManager)().fireOpenedTracesChangedSignal(new opened_traces_updated_signal_payload_1.OpenedTracesUpdatedSignalPayload(this.state.openedExperiments ? this.state.openedExperiments.length : 0));
    }
}
exports.ReactOpenTracesWidget = ReactOpenTracesWidget;
ReactOpenTracesWidget.LIST_MARGIN = 2;
ReactOpenTracesWidget.LINE_HEIGHT = 16;
//# sourceMappingURL=trace-explorer-opened-traces-widget.js.map