/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Value_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureExceptions;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Catch_Statement
extends Statement {
    private static final String EXCEPTIONPARAMEXPECTED3 = "The type of catch parameter is the `default'' type, which cannot be an exception type";
    private static final String EXCEPTIONPARAMEXPECTED2 = "The type of catch parameter is port type `{0}'', which cannot be an exception type";
    private static final String EXCEPTIONPARAMEXPECTED1 = "The type of catch parameter is signature `{0}'', which cannot be an exception type";
    private static final String AMBIGUOUSEXCEPTIONTYPE = "Type of the exception is ambigous: `{0}'' is compatible with more than one exception type of signature `{1}''";
    private static final String MISSINGEXCEPTIONTYPE = "Type `{0}'' is not present on the exception list of signature `{1}''";
    private static final String UNKNOWNEXCEPTIONTYPE = "Cannot determine the type of the exception";
    private static final String SIGNATUREWITHOUTEXCEPTIONS = "Signature `{0}'' does not have exceptions";
    private static final String MISSINGSIGNATURE = "Signature `{0}'' is not present on the outgoing list of port type `{1}''";
    private static final String ANYPORTWITHVALUEREDIRECT = "operation `any port.{0}'' cannot have value redirect";
    private static final String ANYPORTWITHPARAMETER = "operation`any port.{0}'' cannot have parameter";
    private static final String VALUEREDIRECTWITHOUTPARAMETER = "Value redirect cannot be used without signature and parameter";
    private static final String PORTWITHOUTEXCEPTIONSUPPORT = "Port type `{0}'' does not have any outgoing signatures that support exceptions";
    private static final String MESSAGEPORT = "Procedure-based operation `{0}'' is not applicable to a message-based port of type `{1}''";
    private static final String TIMEOUTWITHSENDERREDIRECT = "operation `catch(timeout)'' cannot have a sender redirect";
    private static final String TIMEOUTWITHFROM = "operation `catch(timeout)'' cannot have a from caluse";
    private static final String TIMEOUTWITHOUTOUTSIGNATURES = "Timeout exception cannot be cought on a port of type `{0}'', which does not have any outgoing signatures that allow blocking calls";
    private static final String TIMEOUTONMESSAGEPORT = "Timeout exception cannot be cought on a message-based port of type `{0}''";
    private static final String TIMEOUTONANYPORT = "Timeout exception cannot be cought on `any port''";
    private static final String TIMEOUTNOTPERMITTED1 = "Catching of `timeout' exception is not allowed in this context. It is permitted only in the response and exception handling part of `call' operations";
    private static final String TIMEOUTNOTPERMITTED2 = "Catching of `timeout' exception is not allowed because the previous `call' operation does not have timer";
    private static final String ANYOROMITWITHOUTMATCHINGTAMPLE = "''*'' cannot be used as a matching template for a `{0}'' operation";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".signaturereference";
    private static final String FULLNAMEPART3 = ".parameter";
    private static final String FULLNAMEPART4 = ".from";
    private static final String FULLNAMEPART5 = ".redirectValue";
    private static final String FULLNAMEPART6 = ".redirectSender";
    private static final String FULLNAMEPART7 = ".redirectIndex";
    private static final String FULLNAMEPART8 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "catch";
    private final Reference portReference;
    private final boolean anyfrom;
    private final Reference signatureReference;
    private final TemplateInstance parameter;
    private final boolean timeout;
    private final TemplateInstance fromClause;
    private final Value_Redirection redirectValue;
    private final Reference redirectSender;
    private final Reference redirectIndex;
    private final Reference redirectTimestamp;
    private boolean inCall = false;
    private boolean callHasTimer = false;
    private Signature_Type signature;

    public Catch_Statement(Reference portReference, boolean anyFrom, Reference signatureReference, TemplateInstance parameter, boolean timeout, TemplateInstance fromClause, Value_Redirection redirectValue, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp) {
        this.portReference = portReference;
        this.anyfrom = anyFrom;
        this.signatureReference = signatureReference;
        this.parameter = parameter;
        this.timeout = timeout;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectSender = redirectSender;
        this.redirectIndex = redirectIndex;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (signatureReference != null) {
            signatureReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CATCH;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    public Reference getPortReference() {
        return this.portReference;
    }

    public Signature_Type getSignatureType() {
        return this.signature;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.signatureReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.redirectIndex == child) {
            return builder.append(FULLNAMEPART7);
        }
        if (this.redirectTimestamp == child) {
            return builder.append(FULLNAMEPART8);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.signatureReference != null) {
            this.signatureReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.signatureReference != null) {
            this.signatureReference.setCodeSection(codeSection);
        }
        if (this.parameter != null) {
            this.parameter.setCodeSection(codeSection);
        }
        if (this.fromClause != null) {
            this.fromClause.setCodeSection(codeSection);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setCodeSection(codeSection);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    public boolean hasTimeout() {
        return this.timeout;
    }

    public void setCallSettings(boolean inCall, boolean callHasTimer) {
        this.inCall = inCall;
        this.callHasTimer = callHasTimer;
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.signatureReference != null) {
            this.signature = Port_Utility.checkSignatureReference(timestamp, this.signatureReference);
        }
        Catch_Statement.checkCatch(timestamp, this, STATEMENT_NAME, this.portReference, this.anyfrom, this.signatureReference, this.parameter, this.timeout, this.fromClause, this.redirectValue, this.redirectSender, this.redirectIndex, this.redirectTimestamp);
        if (this.redirectValue != null) {
            // empty if block
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    public static void checkCatch(CompilationTimeStamp timestamp, Statement statement, String statementName, Reference portReference, boolean anyFrom, Reference signatureReference, TemplateInstance parameter, boolean timeout, TemplateInstance fromClause, Value_Redirection redirectValue, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp) {
        Port_Type portType = Port_Utility.checkPortReference(timestamp, statement, portReference, anyFrom);
        if (signatureReference == null) {
            PortTypeBody body;
            if (timeout) {
                if (portReference == null) {
                    statement.getLocation().reportSemanticError(TIMEOUTONANYPORT);
                } else if (portType != null) {
                    body = portType.getPortBody();
                    if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                        portReference.getLocation().reportSemanticError(MessageFormat.format(TIMEOUTONMESSAGEPORT, portType.getTypename()));
                    } else if (!body.getreplyAllowed(timestamp)) {
                        portReference.getLocation().reportSemanticError(MessageFormat.format(TIMEOUTWITHOUTOUTSIGNATURES, portType.getTypename()));
                    }
                }
                if (statement instanceof Catch_Statement) {
                    Catch_Statement catchStatement = (Catch_Statement)statement;
                    if (!catchStatement.inCall) {
                        statement.getLocation().reportSemanticError(TIMEOUTNOTPERMITTED1);
                    } else if (!catchStatement.callHasTimer) {
                        statement.getLocation().reportSemanticError(TIMEOUTNOTPERMITTED2);
                    }
                }
                if (fromClause != null) {
                    fromClause.getLocation().reportSemanticError(TIMEOUTWITHFROM);
                }
                if (redirectSender != null) {
                    redirectSender.getLocation().reportSemanticError(TIMEOUTWITHSENDERREDIRECT);
                }
            } else if (portType != null) {
                body = portType.getPortBody();
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(MESSAGEPORT, statementName, portType.getTypename()));
                } else if (!body.catchAllowed(timestamp)) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(PORTWITHOUTEXCEPTIONSUPPORT, portType.getTypename()));
                }
            }
            if (redirectValue != null) {
                redirectValue.getLocation().reportSemanticError(VALUEREDIRECTWITHOUTPARAMETER);
                redirectValue.checkErroneous(timestamp);
            }
        } else {
            Signature_Type signature = Port_Utility.checkSignatureReference(timestamp, signatureReference);
            if (portType != null) {
                PortTypeBody body = portType.getPortBody();
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(MESSAGEPORT, statementName, portType.getTypename()));
                } else if (body.catchAllowed(timestamp)) {
                    TypeSet outSignatures = body.getOutSignatures();
                    if (signature != null) {
                        if (!outSignatures.hasType(timestamp, signature)) {
                            signatureReference.getLocation().reportSemanticError(MessageFormat.format(MISSINGSIGNATURE, signature.getTypename(), portType.getTypename()));
                        }
                    } else if (outSignatures.getNofTypes() == 1) {
                        signature = (Signature_Type)outSignatures.getTypeByIndex(0).getTypeRefdLast(timestamp);
                    }
                } else {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(PORTWITHOUTEXCEPTIONSUPPORT, portType.getTypename()));
                }
            } else if (portReference == null) {
                if (parameter != null) {
                    parameter.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHPARAMETER, statementName));
                }
                if (redirectValue != null) {
                    redirectValue.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHVALUEREDIRECT, statementName));
                }
            }
            IType exceptionType = null;
            boolean exceptionTypeDetermined = false;
            if (signature != null) {
                SignatureExceptions exceptions = signature.getSignatureExceptions();
                if (exceptions == null) {
                    signatureReference.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREWITHOUTEXCEPTIONS, signature.getTypename()));
                } else {
                    if (exceptions.getNofExceptions() == 1) {
                        exceptionType = exceptions.getExceptionByIndex(0);
                    } else if (parameter != null) {
                        exceptionType = Port_Utility.getMessageSignatureType(timestamp, parameter);
                        if (exceptionType == null) {
                            parameter.getLocation().reportSemanticError(UNKNOWNEXCEPTIONTYPE);
                        } else {
                            int nofCompatibleTypes = exceptions.getNofCompatibleExceptions(timestamp, exceptionType);
                            if (nofCompatibleTypes == 0) {
                                String message = MessageFormat.format(MISSINGEXCEPTIONTYPE, exceptionType.getTypename(), signature.getTypename());
                                parameter.getLocation().reportSemanticError(message);
                            } else if (nofCompatibleTypes > 1) {
                                String message = MessageFormat.format(AMBIGUOUSEXCEPTIONTYPE, exceptionType.getTypename(), signature.getTypename());
                                parameter.getLocation().reportSemanticError(message);
                            }
                        }
                    }
                    exceptionTypeDetermined = true;
                }
            }
            if (!exceptionTypeDetermined) {
                exceptionType = Port_Utility.getMessageSignatureType(timestamp, parameter);
            }
            if (exceptionType != null && parameter != null) {
                parameter.check(timestamp, exceptionType);
                if (parameter.getTemplateBody().getTemplateReferencedLast(timestamp).getTemplatetype() == ITTCN3Template.Template_type.ANY_OR_OMIT) {
                    parameter.getLocation().reportSemanticError(MessageFormat.format(ANYOROMITWITHOUTMATCHINGTAMPLE, statementName));
                }
                if (redirectValue != null) {
                    redirectValue.check(timestamp, exceptionType);
                }
                exceptionType = exceptionType.getTypeRefdLast(timestamp);
                switch (exceptionType.getTypetype()) {
                    case TYPE_SIGNATURE: {
                        parameter.getLocation().reportSemanticError(MessageFormat.format(EXCEPTIONPARAMEXPECTED1, exceptionType.getTypename()));
                        break;
                    }
                    case TYPE_PORT: {
                        parameter.getLocation().reportSemanticError(MessageFormat.format(EXCEPTIONPARAMEXPECTED2, exceptionType.getTypename()));
                        break;
                    }
                    case TYPE_DEFAULT: {
                        parameter.getLocation().reportSemanticError(EXCEPTIONPARAMEXPECTED3);
                        break;
                    }
                }
            } else if (redirectValue != null) {
                redirectValue.checkErroneous(timestamp);
            }
        }
        Port_Utility.checkFromClause(timestamp, statement, portType, fromClause, redirectSender);
        if (redirectIndex != null && portReference != null) {
            Assignment assignment = portReference.getRefdAssignment(timestamp, false);
            Catch_Statement.checkIndexRedirection(timestamp, redirectIndex, assignment == null ? null : ((Def_Port)assignment).getDimensions(), anyFrom, "timer");
        }
        Port_Utility.checkTimestampRedirect(timestamp, portType, redirectTimestamp);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(145);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(253);
        if (this.fromClause != null) {
            return result;
        }
        result.add(62);
        if (this.signatureReference == null || !this.timeout) {
            result.add(297);
        }
        result.add(297);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.signatureReference != null) {
            this.signatureReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.signatureReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.signatureReference != null) {
            this.signatureReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.signatureReference != null && !this.signatureReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        if (this.redirectSender != null && !this.redirectSender.accept(v)) {
            return false;
        }
        if (this.redirectIndex != null && !this.redirectIndex.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        if (this.portReference != null) {
            if (this.timeout && callTimer != null) {
                expression.expression.append(MessageFormat.format("{0}.timeout()", callTimer));
                return;
            }
            this.portReference.generateCode(aData, expression);
            expression.expression.append(".get_exception(");
            if (this.signatureReference != null) {
                expression.expression.append(MessageFormat.format("new {0}_exception_template(", this.signature.getGenNameValue(aData, expression.expression)));
                boolean hasDecodedRedirect = this.redirectValue != null && this.redirectValue.hasDecodedModifier();
                int expressionStart = expression.expression.length();
                this.parameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE, hasDecodedRedirect);
                String lastGenExpression = expression.expression.substring(expressionStart);
                expression.expression.append(", ");
                if (this.redirectValue == null) {
                    expression.expression.append("null");
                } else {
                    this.redirectValue.generateCode(aData, expression, this.parameter, lastGenExpression);
                }
                expression.expression.append("), ");
            }
        } else {
            expression.expression.append("TitanPort.any_catch(");
        }
        this.generateCodeExprFromclause(aData, expression);
        expression.expression.append(", ");
        if (this.redirectSender == null) {
            expression.expression.append("null");
        } else {
            this.redirectSender.generateCode(aData, expression);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        if (this.portReference != null) {
            expression.expression.append(", ");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Catch_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
        }
        expression.expression.append(')');
    }

    private void generateCodeExprFromclause(JavaGenData aData, ExpressionStruct expression) {
        if (this.fromClause != null) {
            this.fromClause.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        } else if (this.redirectSender != null) {
            IType varType = this.redirectSender.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
            if (varType == null) {
                ErrorReporter.INTERNAL_ERROR((String)("Encountered a redirection with unknown type `" + this.getFullName() + "''"));
            }
            if (varType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_COMPONENT) {
                aData.addBuiltinTypeImport("TitanComponent_template");
                expression.expression.append("TitanComponent_template.any_compref");
            } else {
                expression.expression.append(MessageFormat.format("new {0}(template_sel.ANY_VALUE)", varType.getGenNameTemplate(aData, expression.expression)));
            }
        } else {
            aData.addBuiltinTypeImport("TitanComponent_template");
            expression.expression.append("TitanComponent_template.any_compref");
        }
    }
}

