/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedTemplates
extends ASTNode
implements IIncrementallyUpdateable {
    public static final String DUPLICATEFIELDNAMEFIRST = "Duplicate field name `{0}'' was first declared here";
    public static final String DUPLICATEFIELDNAMEREPEATED = "Duplicate field name `{0}'' was declared here again";
    private final ArrayList<NamedTemplate> named_templates = new ArrayList();
    private HashMap<String, NamedTemplate> namedTemplateMap;
    private List<NamedTemplate> duplicatedNames;
    private CompilationTimeStamp lastUniquenessCheck;

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.named_templates.trimToSize();
        for (NamedTemplate template : this.named_templates) {
            template.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (NamedTemplate template : this.named_templates) {
            if (template != child) continue;
            return builder.append(".").append(template.getName().getDisplayName());
        }
        return builder;
    }

    public void addTemplate(NamedTemplate template) {
        if (template != null && template.getName() != null) {
            this.named_templates.add(template);
            template.setFullNameParent(this);
        }
    }

    public void removeGeneratedValues() {
        if (this.named_templates != null) {
            Iterator<NamedTemplate> iterator = this.named_templates.iterator();
            while (iterator.hasNext()) {
                NamedTemplate temp = iterator.next();
                if (temp.isParsed()) continue;
                iterator.remove();
            }
        }
    }

    public int getNofTemplates() {
        return this.named_templates.size();
    }

    public NamedTemplate getTemplateByIndex(int index) {
        return this.named_templates.get(index);
    }

    public boolean hasNamedTemplateWithName(Identifier id) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.namedTemplateMap.containsKey(id.getName());
    }

    public NamedTemplate getNamedTemplateByName(Identifier id) {
        if (this.lastUniquenessCheck == null) {
            this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.namedTemplateMap.containsKey(id.getName())) {
            return this.namedTemplateMap.get(id.getName());
        }
        return null;
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        String name;
        Identifier identifier;
        if (this.lastUniquenessCheck != null && !this.lastUniquenessCheck.isLess(timestamp)) {
            return;
        }
        if (this.lastUniquenessCheck == null) {
            this.namedTemplateMap = new HashMap(this.named_templates.size());
            this.duplicatedNames = new ArrayList<NamedTemplate>();
            for (NamedTemplate template : this.named_templates) {
                identifier = template.getName();
                name = identifier.getName();
                if (this.namedTemplateMap.containsKey(name)) {
                    if (this.duplicatedNames == null) {
                        this.duplicatedNames = new ArrayList<NamedTemplate>();
                    }
                    this.duplicatedNames.add(template);
                    continue;
                }
                this.namedTemplateMap.put(name, template);
            }
            if (this.duplicatedNames != null) {
                for (NamedTemplate template : this.duplicatedNames) {
                    this.named_templates.remove(template);
                }
            }
        }
        if (this.duplicatedNames != null) {
            for (NamedTemplate template : this.duplicatedNames) {
                identifier = template.getName();
                name = identifier.getName();
                Location namedLocation = this.namedTemplateMap.get(name).getName().getLocation();
                namedLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATEFIELDNAMEFIRST, identifier.getDisplayName()));
                template.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEFIELDNAMEREPEATED, identifier.getDisplayName()));
            }
        }
        this.lastUniquenessCheck = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (NamedTemplate template : this.named_templates) {
            template.updateSyntax(reparser, false);
            reparser.updateLocation(template.getLocation());
        }
        if (this.duplicatedNames != null) {
            for (NamedTemplate template : this.duplicatedNames) {
                template.updateSyntax(reparser, false);
                reparser.updateLocation(template.getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.named_templates == null) {
            return;
        }
        for (NamedTemplate namedTemp : this.named_templates) {
            namedTemp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.named_templates != null) {
            for (NamedTemplate nt : this.named_templates) {
                if (nt.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

