/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.CharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.IntegerLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RealLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.UCharLimit;

public abstract class LimitType
implements Comparable<LimitType> {
    public abstract Type getType();

    public abstract boolean isAdjacent(LimitType var1);

    public abstract LimitType increment();

    public abstract LimitType decrement();

    public abstract void toString(StringBuilder var1);

    public static LimitType getMaximum(Type type) {
        switch (type) {
            case SIZE: {
                return SizeLimit.MAXIMUM;
            }
            case INTEGER: {
                return IntegerLimit.MAXIMUM;
            }
            case CHAR: {
                return CharLimit.MAXIMUM;
            }
            case UCHAR: {
                return UCharLimit.MAXIMUM;
            }
            case REAL: {
                return RealLimit.MAXIMUM;
            }
        }
        return null;
    }

    public static LimitType getMinimum(Type type) {
        switch (type) {
            case SIZE: {
                return SizeLimit.MINIMUM;
            }
            case INTEGER: {
                return IntegerLimit.MINIMUM;
            }
            case CHAR: {
                return CharLimit.MINIMUM;
            }
            case UCHAR: {
                return UCharLimit.MINIMUM;
            }
            case REAL: {
                return RealLimit.MINIMUM;
            }
        }
        return null;
    }

    public static enum Type {
        SIZE,
        INTEGER,
        CHAR,
        UCHAR,
        REAL;

    }
}

