/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.decorators;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.commonFilters.ExcludedResourceFilter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.commonFilters.WorkingDirectoryFilter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.decorators.DecoratorVisitor;
import org.eclipse.titan.designer.decorators.OverlayImageIcon;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.IPropertyChangeListener;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public final class TITANDecorator
extends LabelProvider
implements ILabelDecorator {
    public static final String DECORATOR_ID = "org.eclipse.titan.designer.decorators.TITANDecorator";
    static final String TRUE_STRING = "true";
    static final String FALSE_STRING = "false";
    static final String OPENING_PARENTHESIS = " [ ";
    static final String CLOSING_PARENTHESIS = " ] ";
    static final String CENTRAL_STORAGE = "centralstorage";
    static final String EXCLUDED_BY_CONVENTION = "excluded by convention";
    static final String EXCLUDED_BY_USER = "excluded by user";
    static final String EXCLUDED_BY_REGEXP = "excluded by regexp";
    static final String EXCLUDED_AS_WORKINGDIR = "excluded as workingdirectory";
    static final String SPACE = " ";
    static final String ABSOLUTE_PATH_OPTION = "a";
    static final String CENTRAL_STORAGE_OPTION = "c";
    static final String FORCE_OVERWRITE_OPTION = "f";
    static final String GNU_MAKE_OPTION = "g";
    static final String FUNCTION_TEST_OPTION = "R";
    static final String DYNAMIC_LINKING_OPTION = "l";
    static final String PREPROCESSOR_OPTION = "p";
    static final String SINGLE_MODE_OPTION = "s";
    static final String TARGET_EXECUTABLE_OPTION = "-e";
    static final String OUTPUTDIR_OPTION = "-o";
    static final String CODE_SPLITTING_OPTION = "-U";
    static final String CHECK_ICON_NAME = "check.gif";
    private ResourceExclusionHelper helper;
    private static IPropertyChangeListener listener = new IPropertyChangeListener(){

        @Override
        public void propertyChanged(IResource resource) {
            if (resource instanceof IProject) {
                if (!resource.isAccessible()) {
                    return;
                }
                IProject project = (IProject)resource;
                final ArrayList allProjectResources = new ArrayList();
                try {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            allProjectResources.add(resource);
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    ErrorReporter.logWarningExceptionStackTrace((String)("While re-decorating " + project.getName()), (Exception)((Object)e));
                }
                TITANDecorator.refreshSelectively(allProjectResources.toArray());
            } else {
                TITANDecorator.refreshSelectively(resource);
            }
        }
    };

    public TITANDecorator() {
        this.resetMatchers();
    }

    private void resetMatchers() {
        this.helper = new ResourceExclusionHelper();
    }

    public Image decorateImage(Image image, Object element) {
        if (element == null || !(element instanceof IProject)) {
            return null;
        }
        IProject project = (IProject)element;
        try {
            if (!TITANNature.hasTITANNature(project)) {
                return null;
            }
            Object o = project.getSessionProperty(GeneralConstants.PROJECT_UP_TO_DATE);
            if (!Boolean.TRUE.equals(o)) {
                return null;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
        OverlayImageIcon icon = new OverlayImageIcon(image, ImageCache.getImage(CHECK_ICON_NAME), OverlayImageIcon.Position.TOP_RIGHT);
        return icon.getImage();
    }

    public String decorateText(String text, Object element) {
        if (!(element instanceof IResource)) {
            return text;
        }
        IResource baseResource = (IResource)element;
        if (!baseResource.isAccessible()) {
            return text;
        }
        IProject project = baseResource.getProject();
        if (project == null || !project.isAccessible() || !TITANNature.hasTITANNature(project)) {
            return text;
        }
        StringBuilder result = new StringBuilder(text);
        block1 : switch (baseResource.getType()) {
            case 8: {
                break;
            }
            case 4: {
                IProject resource = (IProject)element;
                if (ExcludedResourceFilter.isActive() || WorkingDirectoryFilter.isActive()) {
                    result.append("[filtered]");
                }
                if (!ProjectBuildPropertyData.useAutomaticMakefilegeneration(resource)) break;
                result.append(OPENING_PARENTHESIS);
                result.append(TITANDecorator.propertiesAsParameters(resource, false));
                result.append(CLOSING_PARENTHESIS);
                break;
            }
            case 2: {
                try {
                    IContainer[] workingDirectories;
                    IFolder resource = (IFolder)element;
                    if (TRUE_STRING.equals(resource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage")))) {
                        result.append(OPENING_PARENTHESIS);
                        result.append(CENTRAL_STORAGE);
                        result.append(CLOSING_PARENTHESIS);
                    }
                    if (ResourceExclusionHelper.isDirectlyExcluded(resource)) {
                        result.append(OPENING_PARENTHESIS);
                        result.append(EXCLUDED_BY_USER);
                        result.append(CLOSING_PARENTHESIS);
                    }
                    if (this.helper.isExcludedByRegexp(resource.getName())) {
                        result.append(OPENING_PARENTHESIS);
                        result.append(EXCLUDED_BY_REGEXP);
                        result.append(CLOSING_PARENTHESIS);
                    }
                    if (resource.getName().startsWith(".")) {
                        result.append(OPENING_PARENTHESIS);
                        result.append(EXCLUDED_BY_CONVENTION);
                        result.append(CLOSING_PARENTHESIS);
                    }
                    if (resource.getName().contentEquals("Makefile") || resource.getName().contentEquals("makefile")) {
                        result.append(OPENING_PARENTHESIS);
                        result.append(EXCLUDED_BY_CONVENTION);
                        result.append(CLOSING_PARENTHESIS);
                    }
                    for (IContainer workingDirectory : workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(resource.getProject()).getWorkingDirectoryResources(false)) {
                        if (!workingDirectory.equals(resource)) continue;
                        result.append(OPENING_PARENTHESIS);
                        result.append(EXCLUDED_AS_WORKINGDIR);
                        result.append(CLOSING_PARENTHESIS);
                        break block1;
                    }
                    break;
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    break;
                }
            }
            case 1: {
                IFile resource = (IFile)element;
                if (ResourceExclusionHelper.isDirectlyExcluded(resource)) {
                    result.append(OPENING_PARENTHESIS);
                    result.append(EXCLUDED_BY_USER);
                    result.append(CLOSING_PARENTHESIS);
                }
                if (this.helper.isExcludedByRegexp(resource.getName())) {
                    result.append(OPENING_PARENTHESIS);
                    result.append(EXCLUDED_BY_REGEXP);
                    result.append(CLOSING_PARENTHESIS);
                }
                if (resource.getName().startsWith(".")) {
                    result.append(OPENING_PARENTHESIS);
                    result.append(EXCLUDED_BY_CONVENTION);
                    result.append(CLOSING_PARENTHESIS);
                }
                if (resource.getName().contentEquals("Makefile") || resource.getName().contentEquals("makefile")) {
                    result.append(OPENING_PARENTHESIS);
                    result.append(EXCLUDED_BY_CONVENTION);
                    result.append(CLOSING_PARENTHESIS);
                }
                if (!FileBuildPropertyData.getPropertyValue(resource, "enableCodeSplitting")) break;
                int closing = result.indexOf(CLOSING_PARENTHESIS);
                if (closing > 0) {
                    result.insert(closing, " -U");
                    break;
                }
                result.append(OPENING_PARENTHESIS);
                result.append(CODE_SPLITTING_OPTION);
                result.append(CLOSING_PARENTHESIS);
                break;
            }
        }
        return result.toString();
    }

    public static String propertiesAsParameters(IProject project, boolean full) {
        if (!project.isAccessible()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        DecoratorVisitor visitor = new DecoratorVisitor();
        try {
            project.accept((IResourceVisitor)visitor);
            if (TRUE_STRING.equals(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useAbsolutePath")))) {
                result.append(ABSOLUTE_PATH_OPTION);
            }
            ProjectBasedBuilder builder = ProjectBasedBuilder.getProjectBasedBuilder(project);
            int nofReferencedProjects = builder.getReferencedProjects().length;
            boolean preProcessorOptionSet = false;
            if (visitor.getHasCentralStorage() || nofReferencedProjects != 0) {
                result.append(CENTRAL_STORAGE_OPTION);
                List<IProject> reachableProjects = builder.getAllReachableProjects();
                boolean prePorcessorOptionFound = false;
                for (IProject reachableProject : reachableProjects) {
                    DecoratorVisitor visitor2 = new DecoratorVisitor();
                    try {
                        if (!reachableProject.isAccessible()) continue;
                        reachableProject.accept((IResourceVisitor)visitor2);
                        if (!visitor2.getHasPreprecessable()) continue;
                        prePorcessorOptionFound = true;
                        break;
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                if (prePorcessorOptionFound) {
                    result.append(PREPROCESSOR_OPTION);
                    preProcessorOptionSet = true;
                }
            }
            result.append(FORCE_OVERWRITE_OPTION);
            if (TRUE_STRING.equals(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "GNUMake")))) {
                result.append(GNU_MAKE_OPTION);
            }
            if (visitor.getHasPreprecessable() && !preProcessorOptionSet) {
                result.append(PREPROCESSOR_OPTION);
            }
            if (TRUE_STRING.equals(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime")))) {
                result.append(FUNCTION_TEST_OPTION);
            }
            if (TRUE_STRING.equals(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty")))) {
                result.append(DYNAMIC_LINKING_OPTION);
            }
            if (TRUE_STRING.equals(project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "singleMode")))) {
                result.append(SINGLE_MODE_OPTION);
            }
            if (result.length() > 0) {
                result.insert(0, '-');
            }
            boolean pendingSpace = result.length() > 0;
            String targetExecutable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (targetExecutable != null && targetExecutable.length() != 0) {
                URI uri = TITANPathUtilities.resolvePath((String)targetExecutable, (URI)project.getLocationURI());
                targetExecutable = URIUtil.toPath((URI)uri).toOSString();
                if (pendingSpace) {
                    result.append(SPACE);
                }
                result.append(TARGET_EXECUTABLE_OPTION);
                if (full) {
                    boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
                    StringBuilder output = new StringBuilder();
                    result.append(" '" + PathConverter.convert((String)targetExecutable, (boolean)reportDebugInformation, (StringBuilder)output) + '\'');
                    TITANDebugConsole.println(output);
                }
                pendingSpace = true;
            } else if (full) {
                if (pendingSpace) {
                    result.append(SPACE);
                }
                result.append(TARGET_EXECUTABLE_OPTION);
                targetExecutable = project.getName();
                if ("win32".equals(Platform.getOS())) {
                    targetExecutable = targetExecutable + ".exe";
                }
                if (targetExecutable != null) {
                    result.append(" '" + targetExecutable + '\'');
                }
                pendingSpace = true;
            }
            String codesplittingOption = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"));
            if (codesplittingOption != null && codesplittingOption.length() != 0 && !"none".equals(codesplittingOption)) {
                if (pendingSpace) {
                    result.append(SPACE);
                }
                result.append(CODE_SPLITTING_OPTION);
                if (full) {
                    result.append(SPACE + codesplittingOption);
                }
                pendingSpace = true;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return result.toString();
    }

    private static TITANDecorator getDecorator() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorManager.getEnabled(DECORATOR_ID)) {
            return (TITANDecorator)decoratorManager.getLabelDecorator(DECORATOR_ID);
        }
        return null;
    }

    public static void resetExclusion() {
        TITANDecorator decorator = TITANDecorator.getDecorator();
        if (decorator != null) {
            decorator.resetMatchers();
        }
    }

    public static void refreshAll() {
        TITANDecorator decorator = TITANDecorator.getDecorator();
        if (decorator != null) {
            decorator.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decorator));
        }
    }

    public static void refreshSelectively(IResource resourceToRefresh) {
        TITANDecorator decorator = TITANDecorator.getDecorator();
        if (decorator != null) {
            decorator.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decorator, (Object)resourceToRefresh));
        }
    }

    public static void refreshSelectively(Object[] resourcesToRefresh) {
        TITANDecorator decorator = TITANDecorator.getDecorator();
        if (decorator != null) {
            decorator.fireLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)decorator, resourcesToRefresh));
        }
    }

    private void fireLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TITANDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    static {
        PropertyNotificationManager.addListener(listener);
    }
}

