/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.graphics.ImageCache;

public class FriendContext
extends ProposalContext {
    private List<String> onTheFlyModules = this.parseModuleList();
    private char endsWith;

    public FriendContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
        this.endsWith = proposalContextInfo.context.charAt(proposalContextInfo.context.length() - 1);
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        String prefix = null;
        if (this.endsWith != ',' && this.onTheFlyModules.size() > 0) {
            prefix = this.onTheFlyModules.get(this.onTheFlyModules.size() - 1);
        }
        Set<String> knownModuleNames = this.sourceParser.getKnownModuleNames();
        boolean needsComma = knownModuleNames.contains(prefix);
        knownModuleNames.remove(this.proposalContextInfo.module.getIdentifier().getDisplayName());
        List<FriendModule> friendModules = ((TTCN3Module)this.proposalContextInfo.module).getFriendModules();
        for (FriendModule friendModule : friendModules) {
            knownModuleNames.remove(friendModule.getIdentifier().getDisplayName());
        }
        knownModuleNames.removeAll(this.onTheFlyModules);
        for (String knownModuleName : knownModuleNames) {
            int cursorPos;
            Module tempModule = this.sourceParser.getModuleByName(knownModuleName);
            if (tempModule.getModuletype() != Module.module_type.TTCN3_MODULE) continue;
            String replacementString = this.onTheFlyModules.size() == 0 && this.endsWith == 'e' ? " " + knownModuleName : knownModuleName;
            int relevance = 1;
            int offset = this.proposalContextInfo.offset;
            int replacementLen = 0;
            if (needsComma) {
                replacementString = ", " + replacementString;
                cursorPos = replacementString.length();
            } else if (prefix == null) {
                cursorPos = replacementString.length();
            } else {
                offset -= prefix.length();
                replacementLen = prefix.length();
                cursorPos = prefix.length() + replacementString.length() - replacementLen;
                if (knownModuleName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    relevance = 2;
                }
            }
            CompletionProposal proposal = new CompletionProposal(replacementString, offset, replacementLen, cursorPos, ImageCache.getImage(tempModule.getOutlineIcon()), new StyledString(knownModuleName), null, tempModule.getHoverContent(null), relevance);
            propCollector.addProposal(proposal);
        }
        propCollector.sortAll();
    }

    private List<String> parseModuleList() {
        ArrayList<String> mList = new ArrayList<String>();
        String modules = this.proposalContextInfo.matcher.group(1);
        if (modules.length() == 0) {
            return mList;
        }
        String[] friendModules = modules.split("[,\\s]");
        for (int i = 0; i < friendModules.length; ++i) {
            mList.add(friendModules[i].trim());
        }
        return mList;
    }
}

