/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.LinkerLibrariesOptionsData;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.MyFileListControl;
import org.eclipse.titan.designer.properties.pages.MyFolderListControl;
import org.eclipse.titan.designer.properties.pages.MyListControl;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class LinkerLibrariesOptionsPage
implements IOptionsPage {
    private final IProject project;
    private Composite mainComposite;
    private MyFileListControl objects;
    private MyListControl libraries;
    private MyFolderListControl librarySearchPath;
    private Button disablePredefinedExtrnalDirs;

    public LinkerLibrariesOptionsPage(IProject project) {
        this.project = project;
    }

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.objects.dispose();
            this.libraries.dispose();
            this.librarySearchPath.dispose();
            this.disablePredefinedExtrnalDirs.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.objects = new MyFileListControl(this.mainComposite, this.project.getLocation().toOSString(), "additional object files ", "object");
        this.libraries = new MyListControl(this.mainComposite, "Libraries (-l)", "library");
        this.librarySearchPath = new MyFolderListControl(this.mainComposite, this.project.getLocation().toOSString(), "Library search path (-L)", "search path");
        this.disablePredefinedExtrnalDirs = new Button(this.mainComposite, 32);
        this.disablePredefinedExtrnalDirs.setText("Disable the entries of predefined libraries");
        this.disablePredefinedExtrnalDirs.setToolTipText("Right now the OPENSSL_DIR and XMLDIR entries.\n Please note that these folders are mandatory for the proper operation of TITAN.");
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.objects.setEnabled(enabled);
        this.libraries.setEnabled(enabled);
        this.librarySearchPath.setEnabled(enabled);
        this.disablePredefinedExtrnalDirs.setEnabled(enabled);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        for (int i = 0; i < LinkerLibrariesOptionsData.PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", LinkerLibrariesOptionsData.PROPERTIES[i]));
                if (temp == null) continue;
                tempStorage.setValue(LinkerLibrariesOptionsData.PROPERTIES[i], temp);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = null;
        String copyValue = null;
        boolean result = false;
        for (int i = 0; i < LinkerLibrariesOptionsData.PROPERTIES.length; ++i) {
            try {
                actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", LinkerLibrariesOptionsData.PROPERTIES[i]));
                copyValue = tempStorage.getString(LinkerLibrariesOptionsData.PROPERTIES[i]);
                result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result = true;
            }
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.objects.setEnabled(true);
        this.objects.setValues(new String[0]);
        this.libraries.setEnabled(true);
        this.libraries.setValues(new String[0]);
        this.librarySearchPath.setEnabled(true);
        this.librarySearchPath.setValues(new String[0]);
        this.disablePredefinedExtrnalDirs.setEnabled(true);
        this.disablePredefinedExtrnalDirs.setSelection(false);
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "additionalObjects"));
            this.objects.setValues(ListConverter.convertToList(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibraries"));
            this.libraries.setValues(ListConverter.convertToList(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibrarySearchPath"));
            this.librarySearchPath.setValues(ListConverter.convertToList(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disablePredefinedExternalFolder"));
            this.disablePredefinedExtrnalDirs.setSelection("true".equals(temp));
        }
        catch (CoreException e) {
            this.objects.setValues(new String[0]);
            this.libraries.setValues(new String[0]);
            this.librarySearchPath.setValues(new String[0]);
            this.disablePredefinedExtrnalDirs.setEnabled(false);
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "additionalObjects");
            String newValue = ListConverter.convertFromList(this.objects.getValues());
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
            qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibraries");
            newValue = ListConverter.convertFromList(this.libraries.getValues());
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
            qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibrarySearchPath");
            newValue = ListConverter.convertFromList(this.librarySearchPath.getValues());
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
            qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disablePredefinedExternalFolder");
            newValue = this.disablePredefinedExtrnalDirs.getSelection() ? "true" : "false";
            if (!newValue.equals(oldValue = project.getPersistentProperty(qualifiedName))) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

