/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanInteger
extends Base_Type {
    private static final BER.ASN_Tag[] TitanInteger_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 2)};
    public static final BER.ASN_BERdescriptor TitanInteger_ber_ = new BER.ASN_BERdescriptor(1, TitanInteger_tag_);
    public static final RAW.TTCN_RAWdescriptor TitanInteger_raw_ = new RAW.TTCN_RAWdescriptor(8, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanInteger_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanInteger_descr_ = new Base_Type.TTCN_Typedescriptor("INTEGER", TitanInteger_ber_, TitanInteger_raw_, TitanInteger_json_, null);
    private boolean boundFlag;
    private boolean nativeFlag;
    private int nativeInt;
    private BigInteger openSSL;
    public static final int[] INTX_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    public TitanInteger() {
        this.boundFlag = false;
        this.nativeFlag = true;
    }

    public TitanInteger(int otherValue) {
        this.boundFlag = true;
        if (otherValue == Integer.MIN_VALUE) {
            this.nativeFlag = false;
            this.openSSL = BigInteger.valueOf(otherValue);
        } else {
            this.nativeFlag = true;
            this.nativeInt = otherValue;
        }
    }

    public TitanInteger(BigInteger otherValue) {
        this.openSSL = otherValue;
        this.boundFlag = true;
        this.nativeFlag = false;
    }

    public TitanInteger(TitanInteger otherValue) {
        otherValue.must_bound("Copying an unbound integer value.");
        this.boundFlag = true;
        this.nativeFlag = otherValue.nativeFlag;
        if (this.nativeFlag) {
            this.nativeInt = otherValue.nativeInt;
        } else {
            this.openSSL = otherValue.openSSL;
        }
    }

    private boolean from_string(String otherValue) {
        try {
            BigInteger temp = new BigInteger(otherValue);
            if (temp.abs().compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == -1) {
                this.nativeFlag = true;
                this.nativeInt = temp.intValue();
            } else {
                this.nativeFlag = false;
                this.openSSL = temp;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public TitanInteger(String otherValue) {
        if (otherValue == null) {
            throw new TtcnError(MessageFormat.format("Unexpected error when converting `{0}'' to integer", otherValue));
        }
        this.boundFlag = true;
        if (!this.from_string(otherValue)) {
            throw new TtcnError(MessageFormat.format("Unexpected error when converting `{0}'' to integer", otherValue));
        }
    }

    @Override
    public void clean_up() {
        if (!this.nativeFlag) {
            this.openSSL = null;
        }
        this.boundFlag = false;
    }

    public TitanInteger operator_assign(int otherValue) {
        this.clean_up();
        this.boundFlag = true;
        if (otherValue == Integer.MIN_VALUE) {
            this.nativeFlag = false;
            this.openSSL = BigInteger.valueOf(otherValue);
        } else {
            this.nativeFlag = true;
            this.nativeInt = otherValue;
        }
        return this;
    }

    public TitanInteger operator_assign(BigInteger otherValue) {
        this.clean_up();
        this.boundFlag = true;
        this.nativeFlag = false;
        this.openSSL = otherValue;
        return this;
    }

    public TitanInteger operator_assign(TitanInteger otherValue) {
        otherValue.must_bound("Assignment of an unbound integer value.");
        if (otherValue != this) {
            this.clean_up();
            this.boundFlag = true;
            this.nativeFlag = otherValue.nativeFlag;
            if (this.nativeFlag) {
                this.nativeInt = otherValue.nativeInt;
            } else {
                this.openSSL = otherValue.openSSL;
            }
        }
        return this;
    }

    @Override
    public TitanInteger operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanInteger) {
            return this.operator_assign((TitanInteger)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", otherValue));
    }

    public TitanInteger add() {
        this.must_bound("Unbound integer operand of unary + operator.");
        if (this.nativeFlag) {
            return new TitanInteger(this.nativeInt);
        }
        return new TitanInteger(this.openSSL);
    }

    public TitanInteger sub() {
        this.must_bound("Unbound integer operand of unary - operator (negation).");
        if (this.nativeFlag) {
            long temp = (long)this.nativeInt * -1L;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        return new TitanInteger(this.openSSL.negate());
    }

    public TitanInteger add(int other_value) {
        this.must_bound("Unbound left operand of integer addition.");
        if (this.nativeFlag) {
            long temp = (long)this.nativeInt + (long)other_value;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger other_int = BigInteger.valueOf(other_value);
        return new TitanInteger(this.openSSL.add(other_int));
    }

    public TitanInteger add(BigInteger other_value) {
        this.must_bound("Unbound left operand of integer addition.");
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.add(other_value));
        }
        return new TitanInteger(this.openSSL.add(other_value));
    }

    public TitanInteger add(TitanInteger other_value) {
        this.must_bound("Unbound left operand of integer addition.");
        other_value.must_bound("Unbound right operand of integer addition.");
        if (this.nativeFlag) {
            if (other_value.nativeFlag) {
                long temp = (long)this.nativeInt + (long)other_value.nativeInt;
                if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                    return new TitanInteger((int)temp);
                }
                return new TitanInteger(BigInteger.valueOf(temp));
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.add(other_value.openSSL));
        }
        if (other_value.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(other_value.nativeInt);
            return new TitanInteger(this.openSSL.add(other_int));
        }
        return new TitanInteger(this.openSSL.add(other_value.openSSL));
    }

    public TitanInteger sub(int other_value) {
        this.must_bound("Unbound left operand of integer subtraction. ");
        if (this.nativeFlag) {
            long temp = (long)this.nativeInt - (long)other_value;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger other_int = BigInteger.valueOf(other_value);
        return new TitanInteger(this.openSSL.subtract(other_int));
    }

    public TitanInteger sub(BigInteger other_value) {
        this.must_bound("Unbound left operand of integer subtraction. ");
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.subtract(other_value));
        }
        return new TitanInteger(this.openSSL.subtract(other_value));
    }

    public TitanInteger sub(TitanInteger other_value) {
        this.must_bound("Unbound left operand of integer subtraction. ");
        other_value.must_bound("Unbound right operand of integer subtraction. ");
        if (this.nativeFlag) {
            if (other_value.nativeFlag) {
                long temp = (long)this.nativeInt - (long)other_value.nativeInt;
                if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                    return new TitanInteger((int)temp);
                }
                return new TitanInteger(BigInteger.valueOf(temp));
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.subtract(other_value.openSSL));
        }
        if (other_value.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(other_value.nativeInt);
            return new TitanInteger(this.openSSL.subtract(other_int));
        }
        return new TitanInteger(this.openSSL.subtract(other_value.openSSL));
    }

    public TitanInteger mul(int other_value) {
        this.must_bound("Unbound left operand of integer multiplication.");
        if (this.nativeFlag && this.nativeInt == 0 || other_value == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            long temp = (long)this.nativeInt * (long)other_value;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger other_int = BigInteger.valueOf(other_value);
        return new TitanInteger(this.openSSL.multiply(other_int));
    }

    public TitanInteger mul(BigInteger other_value) {
        this.must_bound("Unbound left operand of integer multiplication.");
        if (this.nativeFlag && this.nativeInt == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.multiply(other_value));
        }
        return new TitanInteger(this.openSSL.multiply(other_value));
    }

    public TitanInteger mul(TitanInteger other_value) {
        this.must_bound("Unbound left operand of integer multiplication.");
        other_value.must_bound("Unbound right operand of integer multiplication.");
        if (this.nativeFlag && this.nativeInt == 0 || other_value.nativeFlag && other_value.nativeInt == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            if (other_value.nativeFlag) {
                long temp = (long)this.nativeInt * (long)other_value.nativeInt;
                if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                    return new TitanInteger((int)temp);
                }
                return new TitanInteger(BigInteger.valueOf(temp));
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.multiply(other_value.openSSL));
        }
        if (other_value.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(other_value.nativeInt);
            return new TitanInteger(this.openSSL.multiply(other_int));
        }
        return new TitanInteger(this.openSSL.multiply(other_value.openSSL));
    }

    public TitanInteger div(int other_value) {
        this.must_bound("Unbound left operand of integer division.");
        if (other_value == 0) {
            throw new TtcnError("Integer division by zero.");
        }
        if (this.nativeFlag && this.nativeInt == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            long temp = (long)this.nativeInt / (long)other_value;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger other_value_int = BigInteger.valueOf(other_value);
        return new TitanInteger(this.openSSL.divide(other_value_int));
    }

    public TitanInteger div(BigInteger other_value) {
        this.must_bound("Unbound left operand of integer division.");
        if (other_value.equals(BigInteger.ZERO)) {
            throw new TtcnError("Integer division by zero.");
        }
        if (this.nativeFlag && this.nativeInt == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.divide(other_value));
        }
        return new TitanInteger(this.openSSL.divide(other_value));
    }

    public TitanInteger div(TitanInteger other_value) {
        this.must_bound("Unbound left operand of integer division.");
        other_value.must_bound("Unbound right operand of integer division.");
        if (other_value.operator_equals(0)) {
            throw new TtcnError("Integer division by zero.");
        }
        if (this.nativeFlag && this.nativeInt == 0) {
            return new TitanInteger(0);
        }
        if (this.nativeFlag) {
            if (other_value.nativeFlag) {
                long temp = (long)this.nativeInt / (long)other_value.nativeInt;
                if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                    return new TitanInteger((int)temp);
                }
                return new TitanInteger(BigInteger.valueOf(temp));
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return new TitanInteger(this_int.divide(other_value.openSSL));
        }
        if (other_value.nativeFlag) {
            BigInteger other_value_int = BigInteger.valueOf(other_value.nativeInt);
            return new TitanInteger(this.openSSL.divide(other_value_int));
        }
        return new TitanInteger(this.openSSL.divide(other_value.openSSL));
    }

    public TitanInteger rem(int other_value) {
        this.must_bound("Unbound left operand of rem operator ");
        if (other_value == 0) {
            throw new TtcnError("The right operand of rem operator is zero.");
        }
        if (this.nativeFlag) {
            return new TitanInteger(this.nativeInt - other_value * (this.nativeInt / other_value));
        }
        return new TitanInteger(this.openSSL.remainder(BigInteger.valueOf(other_value)));
    }

    public TitanInteger rem(BigInteger other_value) {
        this.must_bound("Unbound left operand of rem operator ");
        if (other_value.equals(BigInteger.ZERO)) {
            throw new TtcnError("The right operand of rem operator is zero.");
        }
        if (this.nativeFlag) {
            return new TitanInteger(BigInteger.valueOf(this.nativeInt).remainder(other_value));
        }
        return new TitanInteger(this.openSSL.remainder(other_value));
    }

    public TitanInteger rem(TitanInteger other_value) {
        this.must_bound("Unbound left operand of rem operator ");
        other_value.must_bound("Unbound right operand of rem operator");
        return this.sub(other_value.mul(this.div(other_value)));
    }

    public TitanInteger mod(int other_value) {
        this.must_bound("Unbound left operand of mod operator.");
        int rightValueAbs = other_value;
        if (other_value < 0) {
            rightValueAbs = -1 * other_value;
        } else if (other_value == 0) {
            throw new TtcnError("The right operand of mod operator is zero");
        }
        if (this.is_greater_than(0)) {
            return this.rem(other_value);
        }
        TitanInteger result = this.rem(rightValueAbs);
        if (result.operator_equals(0)) {
            return result;
        }
        return result.add(rightValueAbs);
    }

    public TitanInteger mod(BigInteger other_value) {
        this.must_bound("Unbound left operand of mod operator.");
        BigInteger rightValueAbs = other_value;
        int comparision = other_value.compareTo(BigInteger.ZERO);
        if (comparision == -1) {
            rightValueAbs = rightValueAbs.negate();
        } else if (comparision == 0) {
            throw new TtcnError("The right operand of mod operator is zero");
        }
        if (this.is_greater_than(0)) {
            return this.rem(other_value);
        }
        TitanInteger result = this.rem(rightValueAbs);
        if (result.operator_equals(0)) {
            return result;
        }
        return result.add(rightValueAbs);
    }

    public TitanInteger mod(TitanInteger other_value) {
        this.must_bound("Unbound left operand of mod operator.");
        other_value.must_bound("Unbound right operand of mod operator");
        TitanInteger rightValueAbs = new TitanInteger(other_value);
        if (other_value.is_less_than(0)) {
            rightValueAbs = rightValueAbs.mul(-1);
        } else if (other_value.operator_equals(0)) {
            throw new TtcnError("The right operand of mod operator is zero");
        }
        if (this.is_greater_than(0)) {
            return this.rem(other_value);
        }
        TitanInteger result = this.rem(rightValueAbs);
        if (result.operator_equals(0)) {
            return new TitanInteger(0);
        }
        return new TitanInteger(rightValueAbs.add(result));
    }

    public boolean operator_equals(int otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (this.nativeFlag) {
            return this.nativeInt == otherValue;
        }
        BigInteger other_int = BigInteger.valueOf(otherValue);
        return this.openSSL.equals(other_int);
    }

    public boolean operator_equals(BigInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (!this.nativeFlag) {
            return this.openSSL.equals(otherValue);
        }
        BigInteger local_int = BigInteger.valueOf(this.nativeInt);
        return local_int.equals(otherValue);
    }

    public boolean operator_equals(TitanInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        otherValue.must_bound("Unbound right operand of integer comparison.");
        if (this.nativeFlag) {
            if (otherValue.nativeFlag) {
                return this.nativeInt == otherValue.nativeInt;
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return this_int.equals(otherValue.openSSL);
        }
        if (otherValue.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(otherValue.nativeInt);
            return this.openSSL.equals(other_int);
        }
        return this.openSSL.equals(otherValue.openSSL);
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanInteger) {
            return this.operator_equals((TitanInteger)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to integer", otherValue));
    }

    public boolean operator_not_equals(int otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(BigInteger otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanInteger otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean is_less_than(int otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (this.nativeFlag) {
            return this.nativeInt < otherValue;
        }
        BigInteger other_int = BigInteger.valueOf(otherValue);
        return -1 == this.openSSL.compareTo(other_int);
    }

    public boolean is_less_than(BigInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return -1 == this_int.compareTo(otherValue);
        }
        return -1 == this.openSSL.compareTo(otherValue);
    }

    public boolean is_less_than(TitanInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        otherValue.must_bound("Unbound right operand of integer comparison.");
        if (this.nativeFlag) {
            if (otherValue.nativeFlag) {
                return this.nativeInt < otherValue.nativeInt;
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return -1 == this_int.compareTo(otherValue.openSSL);
        }
        if (otherValue.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(otherValue.nativeInt);
            return -1 == this.openSSL.compareTo(other_int);
        }
        return -1 == this.openSSL.compareTo(otherValue.openSSL);
    }

    public boolean is_greater_than(int otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (this.nativeFlag) {
            return this.nativeInt > otherValue;
        }
        BigInteger other_int = BigInteger.valueOf(otherValue);
        return 1 == this.openSSL.compareTo(other_int);
    }

    public boolean is_greater_than(BigInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        if (this.nativeFlag) {
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return 1 == this_int.compareTo(otherValue);
        }
        return 1 == this.openSSL.compareTo(otherValue);
    }

    public boolean is_greater_than(TitanInteger otherValue) {
        this.must_bound("Unbound left operand of integer comparison.");
        otherValue.must_bound("Unbound right operand of integer comparison.");
        if (this.nativeFlag) {
            if (otherValue.nativeFlag) {
                return this.nativeInt > otherValue.nativeInt;
            }
            BigInteger this_int = BigInteger.valueOf(this.nativeInt);
            return 1 == this_int.compareTo(otherValue.openSSL);
        }
        if (otherValue.nativeFlag) {
            BigInteger other_int = BigInteger.valueOf(otherValue.nativeInt);
            return 1 == this.openSSL.compareTo(other_int);
        }
        return 1 == this.openSSL.compareTo(otherValue.openSSL);
    }

    public boolean is_less_than_or_equal(int otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_less_than_or_equal(BigInteger otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_less_than_or_equal(TitanInteger otherValue) {
        return !this.is_greater_than(otherValue);
    }

    public boolean is_greater_than_or_equal(int otherValue) {
        return !this.is_less_than(otherValue);
    }

    public boolean is_greater_than_or_equal(BigInteger otherValue) {
        return !this.is_less_than(otherValue);
    }

    public boolean is_greater_than_or_equal(TitanInteger otherValue) {
        return !this.is_less_than(otherValue);
    }

    public boolean is_native() {
        return this.nativeFlag;
    }

    @Override
    public boolean is_bound() {
        return this.boundFlag;
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_value() {
        return this.boundFlag;
    }

    public String toString() {
        if (!this.boundFlag) {
            return "<unbound>";
        }
        return this.get_BigInteger().toString();
    }

    @Override
    public void log() {
        if (this.boundFlag) {
            if (this.nativeFlag) {
                TTCN_Logger.log_event("%d", this.nativeInt);
            } else {
                TTCN_Logger.log_event("%s", this.openSSL.toString());
            }
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    public int get_int() {
        this.must_bound("Using the value of an unbound integer variable.");
        if (!this.nativeFlag) {
            throw new TtcnError("Invalid conversion of a large integer value.");
        }
        return this.nativeInt;
    }

    public long get_long() {
        this.must_bound("Using the value of an unbound integer variable.");
        if (this.nativeFlag) {
            return this.nativeInt;
        }
        return this.openSSL.longValue();
    }

    public BigInteger get_BigInteger() {
        this.must_bound("Using the value of an unbound integer variable.");
        if (this.nativeFlag) {
            return BigInteger.valueOf(this.nativeInt);
        }
        return this.openSSL;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound integer value.");
        text_buf.push_int(this);
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.operator_assign(text_buf.pull_int());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_BER: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While BER-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.ber == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No BER descriptor available for type '%s'.", p_td.name);
                    }
                    BER.ASN_BER_TLV tlv = this.BER_encode_TLV(p_td, flavour);
                    tlv.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_ANY, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_BER: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While BER-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.ber == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No BER descriptor available for type '%s'.", p_td.name);
                    }
                    BER.ASN_BER_TLV tlv = new BER.ASN_BER_TLV();
                    this.BER_decode_str2TLV(p_buf, tlv, flavour);
                    this.BER_decode_TLV(p_td, tlv, flavour);
                    if (!tlv.isComplete) break;
                    p_buf.increase_pos(tlv.getTlen() + tlv.getLlen() + tlv.getVlen());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound integer value.", new Object[0]);
            return -1;
        }
        StringBuilder tmp_str = new StringBuilder();
        if (this.nativeFlag) {
            tmp_str.append(this.nativeInt);
        } else {
            tmp_str.append(this.openSSL.toString());
        }
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER, tmp_str.toString());
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_NUMBER == token.get()) {
            if (!this.from_string(value.substring(0, value_len.get())) || value_len.get() != this.get_nof_digits() + ('-' == value.charAt(0) ? 1 : 0)) {
                if (!p_silent) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "number", "integer");
                }
                this.boundFlag = false;
                return -2;
            }
        } else {
            this.boundFlag = false;
            return -1;
        }
        this.boundFlag = true;
        return dec_len;
    }

    private int get_nof_digits() {
        int digits = 0;
        if (this.nativeFlag) {
            int x = this.nativeInt;
            if (x == 0) {
                return 1;
            }
            if (x < 0) {
                x = -x;
            }
            while (x > 0) {
                ++digits;
                x /= 10;
            }
        } else {
            BigInteger x = this.openSSL;
            if (x.compareTo(BigInteger.ZERO) == 0) {
                return 1;
            }
            if (x.compareTo(BigInteger.ZERO) < 0) {
                x = x.negate();
            }
            while (x.compareTo(BigInteger.ZERO) > 0) {
                ++digits;
                x = x.divide(BigInteger.TEN);
            }
        }
        return digits;
    }

    public static TitanInteger add(int int_value, TitanInteger other_value) {
        other_value.must_bound("Unbound right operand of integer addition.");
        if (other_value.nativeFlag) {
            long temp = (long)int_value + (long)other_value.nativeInt;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger first_int = BigInteger.valueOf(int_value);
        return new TitanInteger(first_int.add(other_value.openSSL));
    }

    public static TitanInteger sub(int int_value, TitanInteger other_value) {
        other_value.must_bound("Unbound right operand of integer subtraction.");
        if (other_value.nativeFlag) {
            long temp = (long)int_value - (long)other_value.nativeInt;
            if (temp > Integer.MIN_VALUE && temp < Integer.MAX_VALUE) {
                return new TitanInteger((int)temp);
            }
            return new TitanInteger(BigInteger.valueOf(temp));
        }
        BigInteger first_int = BigInteger.valueOf(int_value);
        return new TitanInteger(first_int.subtract(other_value.openSSL));
    }

    public static TitanInteger mul(int int_value, TitanInteger other_value) {
        return new TitanInteger(int_value).mul(other_value);
    }

    public static TitanInteger div(int int_value, TitanInteger other_value) {
        return new TitanInteger(int_value).div(other_value);
    }

    public static TitanInteger rem(int left_value, int right_value) {
        if (right_value == 0) {
            throw new TtcnError("The right operand of rem operator is zero.");
        }
        return new TitanInteger(left_value - right_value * (left_value / right_value));
    }

    public static TitanInteger rem(TitanInteger left_value, TitanInteger right_value) {
        left_value.must_bound("Unbound left operand of rem operator ");
        right_value.must_bound("Unbound right operand of rem operator");
        return left_value.sub(right_value.mul(left_value.div(right_value)));
    }

    public static TitanInteger rem(TitanInteger left_value, int right_value) {
        return left_value.rem(right_value);
    }

    public static TitanInteger rem(int left_value, TitanInteger right_value) {
        return TitanInteger.rem(new TitanInteger(left_value), right_value);
    }

    public static TitanInteger mod(int left_value, int right_value) {
        if (right_value < 0) {
            right_value *= -1;
        } else if (right_value == 0) {
            throw new TtcnError("The right operand of mod operator is zero.");
        }
        if (left_value > 0) {
            return TitanInteger.rem(left_value, right_value);
        }
        int result = TitanInteger.rem((int)left_value, (int)right_value).nativeInt;
        if (result == 0) {
            return new TitanInteger(0);
        }
        return new TitanInteger(right_value + result);
    }

    public static TitanInteger mod(TitanInteger left_value, TitanInteger right_value) {
        left_value.must_bound("Unbound left operand of mod operator.");
        right_value.must_bound("Unbound right operand of mod operator");
        TitanInteger rightValueAbs = new TitanInteger(right_value);
        if (right_value.is_less_than(0)) {
            rightValueAbs = rightValueAbs.mul(-1);
        } else if (right_value.operator_equals(0)) {
            throw new TtcnError("The right operand of mod operator is zero");
        }
        if (left_value.is_greater_than(0)) {
            return TitanInteger.rem(left_value, right_value);
        }
        TitanInteger result = TitanInteger.rem(left_value, rightValueAbs);
        if (result.operator_equals(0)) {
            return new TitanInteger(0);
        }
        return rightValueAbs.add(result);
    }

    public static TitanInteger mod(TitanInteger left_value, int right_value) {
        return left_value.mod(right_value);
    }

    public static TitanInteger mod(int left_value, TitanInteger right_value) {
        return TitanInteger.mod(new TitanInteger(left_value), right_value);
    }

    public static boolean operator_equals(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).operator_equals(otherValue);
    }

    public static boolean operator_not_equals(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).operator_not_equals(otherValue);
    }

    public static boolean is_less_than(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).is_less_than(otherValue);
    }

    public static boolean is_greater_than(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).is_greater_than(otherValue);
    }

    public static boolean is_less_than_or_equal(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).is_less_than_or_equal(otherValue);
    }

    public static boolean is_greater_than_or_equal(int intValue, TitanInteger otherValue) {
        return new TitanInteger(intValue).is_greater_than_or_equal(otherValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        if (!this.nativeFlag) {
            return this.RAW_encode_openssl(p_td, myleaf);
        }
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext();
        try {
            int length;
            boolean neg_sgbit;
            int value = this.get_int();
            boolean bl = neg_sgbit = value < 0 && p_td.raw.comp == RAW.raw_sign_t.SG_SG_BIT;
            if (!this.is_bound()) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
                value = 0;
                neg_sgbit = false;
            }
            if (value == Integer.MIN_VALUE) {
                TitanInteger big_value = new TitanInteger(BigInteger.valueOf(value));
                int n = big_value.RAW_encode_openssl(p_td, myleaf);
                return n;
            }
            if (value < 0 && p_td.raw.comp == RAW.raw_sign_t.SG_NO) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_SIGN_ERR, "Unsigned encoding of a negative number: %s", p_td.name);
                value = -value;
            }
            if (neg_sgbit) {
                value = -value;
            }
            int val_bits = 0;
            int len_bits = 0;
            if (p_td.raw.fieldlength == -1) {
                val_bits = p_td.raw.comp != RAW.raw_sign_t.SG_NO ? 1 : 0;
                int v2 = value;
                if (v2 < 0 && p_td.raw.comp == RAW.raw_sign_t.SG_2COMPL) {
                    v2 ^= 0xFFFFFFFF;
                }
                do {
                    ++val_bits;
                } while ((v2 >>= 1) != 0);
                len_bits = 1 + val_bits / 8;
                if (val_bits % 8 + len_bits % 8 > 8) {
                    ++len_bits;
                }
                length = (len_bits + val_bits + 7) / 8;
                if (len_bits % 8 == 0 && val_bits % 8 != 0) {
                    ++len_bits;
                    ++length;
                }
            } else {
                length = (p_td.raw.fieldlength + 7) / 8;
                int min_bits = RAW.min_bits(value);
                if (p_td.raw.comp == RAW.raw_sign_t.SG_SG_BIT) {
                    ++min_bits;
                }
                if (min_bits > p_td.raw.fieldlength) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are insufficient bits to encode '%s': ", p_td.name);
                    value = 0;
                }
            }
            byte[] bc = new byte[length];
            myleaf.data_array = bc;
            if (p_td.raw.fieldlength == -1) {
                int mask;
                int i = 0;
                val_bits = length * 8 - len_bits;
                do {
                    bc[i] = (byte)(value & INTX_MASKS[val_bits > 8 ? 8 : val_bits]);
                    ++i;
                    value >>= 8;
                } while ((val_bits -= 8) > 0);
                if (neg_sgbit) {
                    mask = 128 >> len_bits % 8;
                    int n = i - 1;
                    bc[n] = (byte)(bc[n] | mask);
                }
                --len_bits;
                if (val_bits != 0) {
                    --i;
                } else {
                    bc[i] = 0;
                }
                mask = 128;
                for (int j = 0; j < len_bits % 8; ++j) {
                    int n = i;
                    bc[n] = (byte)(bc[n] | mask);
                    mask >>= 1;
                }
                if (len_bits % 8 > 0 || val_bits != 0) {
                    ++i;
                }
                while (len_bits >= 8) {
                    bc[i] = -1;
                    ++i;
                    len_bits -= 8;
                }
                myleaf.length = length * 8;
            } else {
                for (int a = 0; a < length; ++a) {
                    bc[a] = (byte)(value & 0xFF);
                    value >>= 8;
                }
                if (neg_sgbit) {
                    int mask = 1 << (p_td.raw.fieldlength - 1) % 8;
                    int n = length - 1;
                    bc[n] = (byte)(bc[n] | mask);
                }
                myleaf.length = p_td.raw.fieldlength;
            }
            myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        }
        finally {
            errorContext.leave_context();
        }
        return myleaf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RAW_encode_openssl(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        byte[] bc = null;
        int length = 0;
        int val_bits = 0;
        int len_bits = 0;
        BigInteger D = new BigInteger(this.openSSL.toString());
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext();
        try {
            boolean twos_compl;
            boolean neg_sgbit;
            boolean bl = neg_sgbit = D.signum() == -1 && p_td.raw.comp == RAW.raw_sign_t.SG_SG_BIT;
            if (!this.is_bound()) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
                neg_sgbit = false;
            }
            if (D.signum() == -1 && p_td.raw.comp == RAW.raw_sign_t.SG_NO) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_SIGN_ERR, "Unsigned encoding of a negative number: %s", p_td.name);
                D = D.negate();
                neg_sgbit = false;
            }
            if (p_td.raw.fieldlength == -1) {
                val_bits = D.bitLength();
                if (val_bits % 8 + (len_bits = 1 + val_bits / 8) % 8 > 8) {
                    ++len_bits;
                }
                length = (len_bits + val_bits + 7) / 8;
                if (len_bits % 8 == 0 && val_bits % 8 != 0) {
                    ++len_bits;
                    ++length;
                }
            } else {
                length = (p_td.raw.fieldlength + 7) / 8;
                int min_bits = RAW.min_bits(D);
                if (min_bits > p_td.raw.fieldlength) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are insufficient bits to encode '%s':", p_td.name);
                    neg_sgbit = false;
                }
            }
            if (length > 4) {
                myleaf.data_array = bc = new byte[length];
            } else {
                bc = myleaf.data_array;
            }
            boolean bl2 = twos_compl = D.signum() == -1 && !neg_sgbit;
            if (p_td.raw.fieldlength == -1) {
                int mask;
                int i = 0;
                val_bits = length * 8 - len_bits;
                byte[] tmp = neg_sgbit ? D.abs().toByteArray() : D.toByteArray();
                int num_bytes = tmp.length;
                do {
                    bc[i] = (byte)((num_bytes - i > 0 ? tmp[num_bytes - (i + 1)] : (twos_compl ? 255 : 0)) & INTX_MASKS[val_bits > 8 ? 8 : val_bits] & 0xFF);
                    ++i;
                } while ((val_bits -= 8) > 0);
                if (neg_sgbit) {
                    mask = 128 >> len_bits % 8;
                    int n = i - 1;
                    bc[n] = (byte)(bc[n] | mask);
                }
                --len_bits;
                if (val_bits != 0) {
                    --i;
                } else {
                    bc[i] = 0;
                }
                mask = 128;
                for (int j = 0; j < len_bits % 8; ++j) {
                    int n = i;
                    bc[n] = (byte)(bc[n] | mask);
                    mask >>= 1;
                }
                if (len_bits % 8 > 0 || val_bits != 0) {
                    ++i;
                }
                while (len_bits >= 8) {
                    bc[i] = -1;
                    ++i;
                    len_bits -= 8;
                }
                myleaf.length = length * 8;
            } else {
                byte[] tmp = twos_compl ? D.toByteArray() : D.abs().toByteArray();
                int num_bytes = tmp.length;
                for (int a = 0; a < length; ++a) {
                    bc[a] = twos_compl && num_bytes - 1 < a ? -1 : (byte)((num_bytes - a > 0 ? tmp[num_bytes - (a + 1)] : 0) & 0xFF);
                }
                if (neg_sgbit) {
                    int mask = 1 << (p_td.raw.fieldlength - 1) % 8;
                    int n = length - 1;
                    bc[n] = (byte)(bc[n] | mask);
                }
                myleaf.length = p_td.raw.fieldlength;
            }
            myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        }
        finally {
            errorContext.leave_context();
        }
        return myleaf.length;
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext();
        try {
            int mask;
            int n;
            int nof_unread_bits;
            boolean orders;
            this.boundFlag = false;
            int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
            limit -= prepaddlength;
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.csn1lh = p_td.raw.csn1lh;
            int decode_length = 0;
            int len_bits = 0;
            byte len_data = 0;
            int partial_octet_bits = 0;
            byte[] tmp_len_data = new byte[1];
            if (p_td.raw.fieldlength == -1) {
                block14: do {
                    if (8 > limit) {
                        if (!no_err) {
                            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are not enough bits in the buffer to decode the length of IntX type %s (needed: %d, found: %d).", p_td.name, len_bits + 8, len_bits + limit);
                        }
                        int n2 = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                        return n2;
                    }
                    limit -= 8;
                    nof_unread_bits = buff.unread_len_bit();
                    if (nof_unread_bits < 8) {
                        if (!no_err) {
                            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "There are not enough bits in the buffer to decode the length of IntX type %s (needed: %d, found: %d).", p_td.name, len_bits + 8, len_bits + nof_unread_bits);
                        }
                        n = -TTCN_EncDec.error_type.ET_INCOMPL_MSG.ordinal();
                        return n;
                    }
                    buff.get_b(8, tmp_len_data, cp, top_bit_ord);
                    mask = 128;
                    len_data = tmp_len_data[0];
                    do {
                        ++len_bits;
                        if ((tmp_len_data[0] & mask) != 0) {
                            mask >>= 1;
                            continue;
                        }
                        partial_octet_bits = (8 - len_bits % 8) % 8;
                        decode_length = 8 * (len_bits - 1);
                        continue block14;
                    } while (len_bits % 8 != 0);
                } while (decode_length == 0 && partial_octet_bits == 0);
            } else {
                decode_length = p_td.raw.fieldlength;
            }
            if (decode_length > limit) {
                if (!no_err) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There are not enough bits in the buffer to decode%s type %s (needed: %d, found: %d).", p_td.raw.fieldlength == -1 ? " the value of IntX" : "", p_td.name, decode_length, limit);
                }
                if (no_err || p_td.raw.fieldlength == -1) {
                    nof_unread_bits = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return nof_unread_bits;
                }
                decode_length = limit;
            }
            if (decode_length > (nof_unread_bits = buff.unread_len_bit())) {
                if (!no_err) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "There are not enough bits in the buffer to decode %s type %s (needed: %d, found: %d).", p_td.raw.fieldlength == -1 ? " the value of IntX" : "", p_td.name, decode_length, nof_unread_bits);
                }
                if (no_err || p_td.raw.fieldlength == -1) {
                    mask = TTCN_EncDec.error_type.ET_INCOMPL_MSG.ordinal();
                    return mask;
                }
                decode_length = nof_unread_bits;
            }
            this.clean_up();
            if (decode_length < 0) {
                mask = -1;
                return mask;
            }
            if (decode_length == 0 && partial_octet_bits == 0) {
                this.boundFlag = true;
                this.nativeFlag = true;
                this.nativeInt = 0;
            } else {
                int tmp = 0;
                boolean twos_compl = false;
                byte[] data = new byte[(decode_length + partial_octet_bits + 7) / 8];
                buff.get_b(decode_length, data, cp, top_bit_ord);
                if (partial_octet_bits != 0) {
                    data[decode_length / 8] = len_data;
                    decode_length += partial_octet_bits;
                }
                int end_pos = decode_length;
                int idx = (end_pos - 1) / 8;
                boolean negativ_num = false;
                switch (p_td.raw.comp) {
                    case SG_2COMPL: {
                        if ((data[idx] >> (end_pos - 1) % 8 & 1) == 0) break;
                        tmp = -1;
                        twos_compl = true;
                        break;
                    }
                    case SG_NO: {
                        break;
                    }
                    case SG_SG_BIT: {
                        negativ_num = (data[idx] >> (end_pos - 1) % 8 & 1) != 0;
                        --end_pos;
                        break;
                    }
                }
                if (end_pos < 9) {
                    tmp <<= end_pos;
                    tmp |= data[0] & RAW.BitMaskTable[end_pos];
                } else {
                    idx = (end_pos - 1) / 8;
                    tmp <<= (end_pos - 1) % 8 + 1;
                    tmp |= data[idx--] & RAW.BitMaskTable[(end_pos - 1) % 8 + 1];
                    if (decode_length > 31) {
                        boolean pad;
                        BigInteger D = BigInteger.valueOf(tmp);
                        boolean bl3 = pad = tmp == 0;
                        while (idx >= 0) {
                            if (pad && data[idx] != 0) {
                                D = BigInteger.valueOf(data[idx] & 0xFF);
                                pad = false;
                            } else if (!pad) {
                                D = D.shiftLeft(8);
                                D = D.add(BigInteger.valueOf(data[idx] & 0xFF));
                            }
                            --idx;
                        }
                        if (twos_compl) {
                            BigInteger D_tmp = BigInteger.ZERO;
                            D = D.subtract(D_tmp);
                        } else if (negativ_num) {
                            D = D.negate();
                        }
                        if (D.bitLength() > 31) {
                            this.boundFlag = true;
                            this.nativeFlag = false;
                            this.openSSL = D;
                        } else {
                            this.boundFlag = true;
                            this.nativeFlag = true;
                            this.nativeInt = D.intValue();
                        }
                        this.boundFlag = true;
                        int n3 = (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength + len_bits;
                        return n3;
                    }
                    while (idx >= 0) {
                        tmp <<= 8;
                        tmp |= data[idx] & 0xFF;
                        --idx;
                    }
                }
                this.boundFlag = true;
                this.nativeFlag = true;
                this.nativeInt = negativ_num ? -tmp : tmp;
            }
            this.boundFlag = true;
            n = (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength + len_bits;
            return n;
        }
        finally {
            errorContext.leave_context();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "integer value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Integer: {
                this.operator_assign(param.get_integer());
                break;
            }
            case MP_Expression: {
                switch (param.get_expr_type()) {
                    case EXPR_NEGATE: {
                        TitanInteger operand = new TitanInteger();
                        operand.set_param(param.get_operand1());
                        this.operator_assign(operand.sub());
                        break block0;
                    }
                    case EXPR_ADD: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.add(operand2));
                        break block0;
                    }
                    case EXPR_SUBTRACT: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.sub(operand2));
                        break block0;
                    }
                    case EXPR_MULTIPLY: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.mul(operand2));
                        break block0;
                    }
                    case EXPR_DIVIDE: {
                        TitanInteger operand1 = new TitanInteger();
                        TitanInteger operand2 = new TitanInteger();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        if (operand2.operator_equals(0)) {
                            param.error("Integer division by zero.", new Object[0]);
                        }
                        this.operator_assign(operand1.div(operand2));
                        break block0;
                    }
                }
                param.expr_type_error("an integer");
                break;
            }
            default: {
                param.type_error("integer value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.boundFlag) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Integer(this);
    }

    @Override
    public BER.ASN_BER_TLV BER_encode_chk_bound(boolean isBound) {
        if (!isBound) {
            BER.ASN_BER_TLV newTlv = new BER.ASN_BER_TLV(0, null);
            return newTlv;
        }
        return null;
    }

    public BER.ASN_BER_TLV BER_encode_TLV(Base_Type.TTCN_Typedescriptor p_td, int coding) {
        BER.ASN_BER_TLV newTlv = this.BER_encode_chk_bound(this.is_bound());
        if (newTlv == null) {
            newTlv = this.nativeFlag ? this.BER_encode_TLV_Integer(p_td, this.nativeFlag, this.nativeInt, null) : this.BER_encode_TLV_Integer(p_td, this.nativeFlag, 0, this.openSSL);
        }
        newTlv = newTlv.ASN_BER_V2TLV(p_td, coding);
        return newTlv;
    }

    public boolean BER_decode_TLV(Base_Type.TTCN_Typedescriptor p_td, BER.ASN_BER_TLV p_tlv, int L_form) {
        TitanInteger tmp;
        this.boundFlag = false;
        BER.ASN_BER_TLV strippedTlv = new BER.ASN_BER_TLV();
        Map<Boolean, TitanInteger> p = this.BER_decode_TLV_Integer(strippedTlv = this.BER_decode_strip_tags(p_td.ber, p_tlv, L_form, strippedTlv), L_form, tmp = new TitanInteger());
        Iterator<Map.Entry<Boolean, TitanInteger>> iterator = p.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Boolean, TitanInteger> me = iterator.next();
            boolean returnVal = me.getKey();
            tmp = me.getValue();
            if (tmp.is_native()) {
                this.nativeFlag = true;
                this.nativeInt = strippedTlv.getVstr()[0] >= 0 && tmp.nativeInt < 0 ? -tmp.nativeInt : tmp.nativeInt;
            } else {
                this.nativeFlag = false;
                if (strippedTlv.getVstr()[0] < 0 && tmp.openSSL.compareTo(BigInteger.ZERO) < 0) {
                    this.openSSL = tmp.openSSL.negate();
                }
                this.openSSL = tmp.openSSL;
            }
            if (returnVal) {
                this.boundFlag = true;
            }
            return returnVal;
        }
        return false;
    }

    public TitanInteger convert_to_Integer(Base_Type.TTCN_Typedescriptor p_td) {
        return this;
    }
}

