/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.fieldordering;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

class ChangeCreator {
    private final IFile selectedFile;
    private Change change;

    ChangeCreator(IFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        DefinitionVisitor vis = new DefinitionVisitor();
        module.accept((ASTVisitor)vis);
        NavigableSet nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        if (nodes.isEmpty()) {
            return tfc;
        }
        String fileContents = ChangeCreator.loadFileContent(toVisit);
        for (ILocateableNode node : nodes) {
            if (node instanceof Sequence_Value) {
                ChangeCreator.orderSequence_Value(fileContents, (Sequence_Value)node, rootEdit);
                continue;
            }
            if (!(node instanceof SequenceOf_Value)) continue;
            ChangeCreator.orderSequenceOf_Value(fileContents, (SequenceOf_Value)node, rootEdit);
        }
        if (!rootEdit.hasChildren()) {
            return null;
        }
        return tfc;
    }

    private static void orderSequence_Value(String fileContents, Sequence_Value sequence_Value, MultiTextEdit rootEdit) {
        TTCN3_Sequence_Type sequenceType;
        Identifier identifier;
        int i;
        TTCN3_Set_Type setType;
        if (sequence_Value.getNofComponents() == 0) {
            return;
        }
        if (sequence_Value.getSeqValueByIndex(0) == null) {
            return;
        }
        IType type = sequence_Value.getMyGovernor();
        if (!(type instanceof Referenced_Type)) {
            return;
        }
        IType refType = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        StringBuilder builder = new StringBuilder();
        ArrayList<Identifier> fieldNamesOrdered = new ArrayList<Identifier>();
        if (refType instanceof TTCN3_Set_Type) {
            setType = (TTCN3_Set_Type)refType;
            for (i = 0; i < setType.getNofComponents(); ++i) {
                identifier = setType.getComponentIdentifierByIndex(i);
                fieldNamesOrdered.add(identifier);
            }
        } else if (refType instanceof TTCN3_Sequence_Type) {
            sequenceType = (TTCN3_Sequence_Type)refType;
            for (i = 0; i < sequenceType.getNofComponents(); ++i) {
                identifier = sequenceType.getComponentIdentifierByIndex(i);
                fieldNamesOrdered.add(identifier);
            }
        } else if (refType instanceof ASN1_Set_Type) {
            setType = (ASN1_Set_Type)refType;
            for (i = 0; i < setType.getNofComponents(); ++i) {
                identifier = setType.getComponentIdentifierByIndex(i);
                fieldNamesOrdered.add(identifier);
            }
        } else if (refType instanceof ASN1_Sequence_Type) {
            sequenceType = (ASN1_Sequence_Type)refType;
            for (i = 0; i < sequenceType.getNofComponents(); ++i) {
                identifier = sequenceType.getComponentIdentifierByIndex(i);
                fieldNamesOrdered.add(identifier);
            }
        }
        boolean isFirst = true;
        for (i = 0; i < fieldNamesOrdered.size(); ++i) {
            identifier = (Identifier)fieldNamesOrdered.get(i);
            NamedValue componentByName = sequence_Value.getComponentByName(identifier);
            if (componentByName == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(",\n");
            }
            IValue value = componentByName.getValue();
            int start = value.getLocation().getOffset();
            int end = value.getLocation().getEndOffset();
            builder.append(identifier.getDisplayName()).append(" := ").append(fileContents.substring(start, end));
        }
        int seqStartOffset = sequence_Value.getLocation().getOffset() + 1;
        int seqEndOffset = sequence_Value.getLocation().getEndOffset() - 1;
        ReplaceEdit newEdit = new ReplaceEdit(seqStartOffset, seqEndOffset - seqStartOffset, builder.toString());
        try {
            rootEdit.addChild((TextEdit)newEdit);
        }
        catch (MalformedTreeException malformedTreeException) {
            // empty catch block
        }
    }

    private static void orderSequenceOf_Value(String fileContents, SequenceOf_Value sequenceOf_Value, MultiTextEdit rootEdit) {
        if (!sequenceOf_Value.isIndexed()) {
            return;
        }
        if (sequenceOf_Value.getNofComponents() == 0) {
            return;
        }
        Long maxIndex = ChangeCreator.getIndexUpperBound(sequenceOf_Value);
        if (maxIndex == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (long i = 0L; i < maxIndex; ++i) {
            long realIndex = i + 1L;
            IValue indexedValueByRealIndex = sequenceOf_Value.getValues().getIndexedValueByRealIndex((int)realIndex);
            if (indexedValueByRealIndex == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            int start = indexedValueByRealIndex.getLocation().getOffset();
            int end = indexedValueByRealIndex.getLocation().getEndOffset();
            builder.append('[').append(realIndex).append("] := ").append(fileContents.substring(start, end));
        }
        int seqStartOffset = sequenceOf_Value.getLocation().getOffset() + 1;
        int seqEndOffset = sequenceOf_Value.getLocation().getEndOffset() - 1;
        rootEdit.addChild((TextEdit)new ReplaceEdit(seqStartOffset, seqEndOffset - seqStartOffset, builder.toString()));
    }

    private static Long getIndexUpperBound(SequenceOf_Value sequenceOf_Value) {
        long result = 0L;
        for (int i = 0; i < sequenceOf_Value.getNofComponents(); ++i) {
            IValue indexByIndex = sequenceOf_Value.getIndexByIndex(i);
            if (indexByIndex.getValuetype() != IValue.Value_type.INTEGER_VALUE) {
                return null;
            }
            long value = ((Integer_Value)indexByIndex).getValue();
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    private static String loadFileContent(IFile toLoad) {
        StringBuilder fileContents;
        try {
            InputStream is = toLoad.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, toLoad.getCharset()));
            fileContents = new StringBuilder();
            char[] buff = new char[1024];
            while (br.ready()) {
                int len = br.read(buff);
                fileContents.append(buff, 0, len);
            }
            br.close();
        }
        catch (IOException e) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (IOException) for file: " + toLoad.getName()));
            return null;
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (CoreException) for file: " + toLoad.getName()));
            return null;
        }
        return fileContents.toString();
    }

    private static class LocationComparator
    implements Comparator<ILocateableNode> {
        private LocationComparator() {
        }

        @Override
        public int compare(ILocateableNode arg0, ILocateableNode arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = arg0.getLocation().getOffset();
            return o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (o0 == o1 ? 0 : 1);
        }
    }

    private static class DefinitionVisitor
    extends ASTVisitor {
        private final NavigableSet<ILocateableNode> locations = new TreeSet<ILocateableNode>(new LocationComparator());

        DefinitionVisitor() {
        }

        private NavigableSet<ILocateableNode> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Sequence_Value) {
                if (this.needsOrdering((Sequence_Value)node)) {
                    this.locations.add((ILocateableNode)((Sequence_Value)node));
                }
            } else if (node instanceof SequenceOf_Value && this.needsOrdering((SequenceOf_Value)node)) {
                this.locations.add((ILocateableNode)((SequenceOf_Value)node));
            }
            return 3;
        }

        private boolean needsOrdering(Sequence_Value sequence_Value) {
            IType type = sequence_Value.getMyGovernor();
            if (!(type instanceof Referenced_Type)) {
                return false;
            }
            if (sequence_Value.getNofComponents() == 0) {
                return false;
            }
            if (sequence_Value.getSeqValueByIndex(0) == null) {
                return false;
            }
            IType refType = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            if (refType instanceof TTCN3_Set_Type) {
                TTCN3_Set_Type setType = (TTCN3_Set_Type)refType;
                boolean inOrder = true;
                int typeIndex = 0;
                for (int i = 0; i < sequence_Value.getNofComponents(); ++i) {
                    NamedValue namedValue = sequence_Value.getSeqValueByIndex(i);
                    boolean found = false;
                    while (typeIndex < setType.getNofComponents()) {
                        Identifier identifier = setType.getComponentIdentifierByIndex(typeIndex);
                        ++typeIndex;
                        if (!identifier.equals((Object)namedValue.getName())) continue;
                        found = true;
                        break;
                    }
                    inOrder = found;
                }
                return !inOrder;
            }
            if (refType instanceof TTCN3_Sequence_Type) {
                TTCN3_Sequence_Type sequenceType = (TTCN3_Sequence_Type)refType;
                boolean inOrder = true;
                int typeIndex = 0;
                for (int i = 0; i < sequence_Value.getNofComponents() && inOrder; ++i) {
                    NamedValue namedValue = sequence_Value.getSeqValueByIndex(i);
                    boolean found = false;
                    while (typeIndex < sequenceType.getNofComponents()) {
                        Identifier identifier = sequenceType.getComponentIdentifierByIndex(typeIndex);
                        ++typeIndex;
                        if (!identifier.equals((Object)namedValue.getName())) continue;
                        found = true;
                        break;
                    }
                    inOrder = found;
                }
                return !inOrder;
            }
            if (refType instanceof ASN1_Set_Type) {
                ASN1_Set_Type setType = (ASN1_Set_Type)refType;
                boolean inOrder = true;
                int typeIndex = 0;
                for (int i = 0; i < sequence_Value.getNofComponents() && inOrder; ++i) {
                    NamedValue namedValue = sequence_Value.getSeqValueByIndex(i);
                    boolean found = false;
                    while (typeIndex < setType.getNofComponents()) {
                        Identifier identifier = setType.getComponentIdentifierByIndex(typeIndex);
                        ++typeIndex;
                        if (!identifier.equals((Object)namedValue.getName())) continue;
                        found = true;
                        break;
                    }
                    inOrder = found;
                }
                return !inOrder;
            }
            if (refType instanceof ASN1_Sequence_Type) {
                ASN1_Sequence_Type sequenceType = (ASN1_Sequence_Type)refType;
                boolean inOrder = true;
                int typeIndex = 0;
                for (int i = 0; i < sequence_Value.getNofComponents() && inOrder; ++i) {
                    NamedValue namedValue = sequence_Value.getSeqValueByIndex(i);
                    boolean found = false;
                    while (typeIndex < sequenceType.getNofComponents()) {
                        Identifier identifier = sequenceType.getComponentIdentifierByIndex(typeIndex);
                        ++typeIndex;
                        if (!identifier.equals((Object)namedValue.getName())) continue;
                        found = true;
                        break;
                    }
                    inOrder = found;
                }
                return !inOrder;
            }
            return false;
        }

        private boolean needsOrdering(SequenceOf_Value sequenceOf_Value) {
            if (!sequenceOf_Value.isIndexed()) {
                return false;
            }
            if (sequenceOf_Value.getNofComponents() == 0) {
                return false;
            }
            int lastIndex = -1;
            for (int i = 0; i < sequenceOf_Value.getNofComponents(); ++i) {
                IValue index = sequenceOf_Value.getIndexByIndex(i);
                if (!(index instanceof Integer_Value)) {
                    return false;
                }
                int currentIndex = ((Integer_Value)index).intValue();
                if (currentIndex <= lastIndex) {
                    return true;
                }
                lastIndex = currentIndex;
            }
            return false;
        }
    }
}

