/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.function.ExtractToFunctionRefactoring;
import org.eclipse.titanium.refactoring.function.ExtractToFunctionWizard;

public class ExtractToFunctionAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Utils.updateASTForProjectActiveInEditor("ExtractToFunction");
        ExtractToFunctionRefactoring refactoring = new ExtractToFunctionRefactoring();
        refactoring.findSelection();
        if (!refactoring.isSelectionValid()) {
            ErrorReporter.logError((String)"ExtractToFunctionAction: Invalid selection! ");
            return null;
        }
        Activator.getDefault().pauseHandlingResourceChanges();
        try {
            WorkspaceJob job1 = refactoring.createFunction();
            job1.join();
            if (!job1.getResult().isOK()) {
                return null;
            }
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
        }
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            return null;
        }
        ExtractToFunctionWizard wiz = new ExtractToFunctionWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"ExtractToFunctionAction: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        IFile selectedFile = refactoring.getSelectedFile();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)selectedFile.getProject());
        projectSourceParser.reportOutdating(selectedFile);
        projectSourceParser.analyzeAll();
        Activator.getDefault().resumeHandlingResourceChanges();
        return null;
    }
}

