/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.modulepar;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.refactoring.modulepar.ExtractModuleParHeadless;

public class ExtractModuleParHeadlessRunner
implements IApplication {
    public Object start(IApplicationContext context) {
        Map<String, String> args;
        String[] cmdArguments = (String[])context.getArguments().get("application.args");
        try {
            args = this.processArgs(cmdArguments);
        }
        catch (ArgumentException e) {
            ErrorReporter.logError((String)e.getMessage());
            return -1;
        }
        String sourceProjName = args.get("in");
        String targetProjName = args.get("out");
        boolean save = args.get("save") != null;
        IProject sourceProj = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProjName);
        if (sourceProj == null || !sourceProj.exists()) {
            ErrorReporter.logError((String)("ExtractModuleParHeadless: Source project is not exist: " + sourceProjName));
            return -1;
        }
        IProject targetProj = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjName);
        if (targetProj.exists()) {
            ErrorReporter.logError((String)("ExtractModuleParHeadless: Output project is already exist: " + targetProjName));
            return -1;
        }
        ExtractModuleParHeadless headless = new ExtractModuleParHeadless();
        String location = args.get("location");
        if (location != null) {
            try {
                File d = new File(location);
                if (!d.exists()) {
                    try {
                        d.mkdirs();
                    }
                    catch (Exception e) {
                        throw new Exception("Could not create the parent folder of the project: " + d.getAbsolutePath());
                    }
                } else if (!d.isDirectory()) {
                    throw new Exception("Provided location must be a directory.");
                }
                File f = new File(location, targetProjName);
                if (f.exists()) {
                    throw new Exception("Project folder is already exist: " + f.getAbsolutePath());
                }
                headless.setLocation(f.toURI());
            }
            catch (URISyntaxException e) {
                ErrorReporter.logError((String)"ExtractModuleParHeadless: Location parameter is not a valid URI.");
                return -1;
            }
            catch (Exception e) {
                ErrorReporter.logError((String)("ExtractModuleParHeadless: " + e.getMessage()));
                return -1;
            }
        }
        headless.run(sourceProj, targetProjName, save);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private Map<String, String> processArgs(String[] cliArgs) throws ArgumentException {
        HashMap<String, String> arguments = new HashMap<String, String>(cliArgs.length);
        for (int i = 0; i < cliArgs.length; ++i) {
            String arg = cliArgs[i];
            if ("-save".equals(arg)) {
                arguments.put("save", "save");
                continue;
            }
            if (!"-in".equals(arg) && !"-out".equals(arg) && !"-location".equals(arg)) continue;
            if (++i == cliArgs.length) {
                throw new ArgumentException("Missing argument parameter of " + cliArgs[i - 1]);
            }
            arguments.put(cliArgs[i - 1].substring(1), cliArgs[i]);
        }
        if (!arguments.containsKey("in") || ((String)arguments.get("in")).length() == 0) {
            throw new ArgumentException("Error, missing mandatory argument: -in");
        }
        if (!arguments.containsKey("out") || ((String)arguments.get("out")).length() == 0) {
            throw new ArgumentException("Error, missing mandatory argument: -out");
        }
        return arguments;
    }

    private class ArgumentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ArgumentException(String message) {
            super(message);
        }
    }
}

