/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.definitions.SpecialASN1Module;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PropertyBody;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.CodeMiningMaps;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Assignment
extends ASTNode
implements IOutlineElement,
ILocateableNode,
IReferenceChainElement,
IReferencingElement {
    protected static final String GLOBALLY_UNUSED = "The {0} seems to be never used globally";
    protected static final String LOCALLY_UNUSED = "The {0} seems to be never used locally";
    protected Identifier identifier;
    protected Location location;
    protected Group parentGroup;
    protected CompilationTimeStamp lastTimeChecked;
    protected boolean isErroneous;
    @Deprecated
    protected boolean isUsed;
    private boolean canBeCheckRoot = true;
    protected VisibilityModifier visibility;
    protected Location visibilityLocation;
    private Set<Reference> references = new HashSet<Reference>();

    public Assignment(Identifier identifier) {
        this.identifier = identifier;
        this.isErroneous = false;
        this.isUsed = false;
        this.location = NULL_Location.INSTANCE;
    }

    public synchronized void addReference(Reference reference) {
        this.references.add(reference);
    }

    public int getReferenceCount() {
        int count = 0;
        for (Reference ref : this.references) {
            if (ref.getLastTimeChecked() != this.lastTimeChecked) continue;
            ++count;
        }
        return count;
    }

    public final CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    public final boolean isCheckRoot() {
        return this.canBeCheckRoot;
    }

    public final void checkRoot() {
        this.canBeCheckRoot = true;
    }

    public final void notCheckRoot() {
        this.canBeCheckRoot = false;
    }

    public final boolean getIsErroneous() {
        return this.isErroneous;
    }

    public abstract String getGenName();

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public final Location getChainLocation() {
        return this.location;
    }

    @Override
    public final String chainedDescription() {
        return this.getFullName();
    }

    @Deprecated
    public final void setUsed() {
        this.isUsed = true;
    }

    @Deprecated
    public boolean isUsed() {
        return this.isUsed;
    }

    public boolean isLocal() {
        return false;
    }

    public final void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    public final Group getParentGroup() {
        return this.parentGroup;
    }

    public abstract Assignment_type getAssignmentType();

    @Override
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public Object[] getOutlineChildren() {
        return new Object[0];
    }

    @Override
    public String getOutlineText() {
        return "";
    }

    @Override
    public int category() {
        return this.getAssignmentType().ordinal() * IType.Type_type.values().length;
    }

    public abstract String getAssignmentName();

    public String getProposalDescription() {
        return "basic assignment";
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder(this.getAssignmentName());
        builder.append(" `").append(this.getFullName()).append('\'');
        return builder.toString();
    }

    public ISetting getSetting(CompilationTimeStamp timestamp) {
        return null;
    }

    public IType getType(CompilationTimeStamp timestamp) {
        return null;
    }

    public abstract void check(CompilationTimeStamp var1);

    public abstract void check(CompilationTimeStamp var1, IReferenceChain var2);

    public void postCheck() {
    }

    public abstract void addProposal(ProposalCollector var1, int var2);

    public abstract void addDeclaration(DeclarationCollector var1, int var2);

    public abstract boolean shouldMarkOccurrences();

    @Override
    public Declaration getDeclaration() {
        return Declaration.createInstance(this);
    }

    public VisibilityModifier getVisibility() {
        return this.visibility;
    }

    public String getGenNameFromScope(JavaGenData aData, StringBuilder source, String prefix) {
        if (this.myScope == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous setting `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        StringBuilder returnValue = new StringBuilder();
        Module myModule = this.myScope.getModuleScopeGen();
        Module generatedModule = aData.getModuleScope();
        if (!myModule.equals(aData.getModuleScope()) && !SpecialASN1Module.isSpecAsss(myModule)) {
            returnValue.append(myModule.getName()).append('.');
            if (myModule.getProject() != generatedModule.getProject()) {
                aData.addInterModuleImport(myModule.getName());
            }
        }
        if (prefix != null) {
            returnValue.append(prefix);
        }
        returnValue.append(this.getGenName());
        switch (this.getAssignmentType()) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_TEMP_IN: {
                FormalParameter formalParameter = (FormalParameter)this;
                if (formalParameter.getEvaluationType() == FormalParameter.parameterEvaluationType.NORMAL_EVAL || prefix != null) break;
                returnValue.append(".evaluate()");
                break;
            }
        }
        return returnValue.toString();
    }

    public abstract void generateCode(JavaGenData var1, boolean var2);

    public boolean isProperty() {
        return false;
    }

    public boolean isAbstract() {
        ErrorReporter.INTERNAL_ERROR((String)"Assignment::isAbstract()");
        return false;
    }

    public boolean isFinal() {
        ErrorReporter.INTERNAL_ERROR((String)"Assignment::isFinal()");
        return false;
    }

    public PropertyBody getPropertyBody() {
        ErrorReporter.INTERNAL_ERROR((String)"Assignment::getPropertyBody()");
        return null;
    }

    public boolean isInternal() {
        return false;
    }

    protected void removeSyntaxDecoration() {
        AstSyntaxHighlightTokens.removeSyntaxDecoration(this.location);
    }

    protected void removeMining() {
        CodeMiningMaps.removeCodeMining(CodeMiningMaps.CodeMiningType.Content, this.location);
    }

    public static enum Assignment_type {
        A_TYPE,
        A_ALTSTEP,
        A_CONST,
        A_EXT_CONST,
        A_FUNCTION,
        A_FUNCTION_RVAL,
        A_FUNCTION_RTEMP,
        A_EXT_FUNCTION,
        A_EXT_FUNCTION_RVAL,
        A_EXT_FUNCTION_RTEMP,
        A_MODULEPAR,
        A_MODULEPAR_TEMPLATE,
        A_PORT,
        A_VAR,
        A_TEMPLATE,
        A_VAR_TEMPLATE,
        A_TIMER,
        A_TESTCASE,
        A_CONSTRUCTOR,
        A_PAR_VAL,
        A_PAR_VAL_IN,
        A_PAR_VAL_OUT,
        A_PAR_VAL_INOUT,
        A_PAR_TEMP_IN,
        A_PAR_TEMP_OUT,
        A_PAR_TEMP_INOUT,
        A_PAR_TIMER,
        A_PAR_PORT,
        A_UNDEF,
        A_VS,
        A_OC,
        A_OBJECT,
        A_OS;


        public final boolean semanticallyEquals(Assignment_type other) {
            if (this == A_PAR_VAL || this == A_PAR_VAL_IN) {
                return other == A_PAR_VAL || other == A_PAR_VAL_IN;
            }
            return this == other;
        }
    }
}

