/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.All_From_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Template_List
extends CompositeTemplate {
    private boolean hasPermutation = false;
    private SequenceOf_Value asValue = null;
    private TTCN3Template converted = null;

    public Template_List(ListOfTemplates templates) {
        super(templates);
        int size = templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!ITTCN3Template.Template_type.PERMUTATION_MATCH.equals((Object)templates.getTemplateByIndex(i).getTemplatetype())) continue;
            this.hasPermutation = true;
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous value list notation";
        }
        return "value list notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            builder.append(template.createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public boolean hasAllFrom() {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!ITTCN3Template.Template_type.ALL_FROM.equals((Object)this.templates.getTemplateByIndex(i).getTemplatetype())) continue;
            return true;
        }
        return false;
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        switch (newType) {
            case NAMED_TEMPLATE_LIST: {
                this.converted = Named_Template_List.convert(timestamp, this);
                return this.converted;
            }
        }
        return super.setTemplatetype(timestamp, newType);
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.converted == null || this.converted.getIsErroneous(timestamp)) {
            return this;
        }
        return this.converted.getTemplateReferencedLast(timestamp, referenceChain);
    }

    @Override
    protected ITTCN3Template getReferencedArrayTemplate(CompilationTimeStamp timestamp, IValue arrayIndex, IReferenceChain referenceChain, boolean silent) {
        TTCN3Template returnValue;
        IValue indexValue = arrayIndex.setLoweridToReference(timestamp);
        if ((indexValue = indexValue.getValueRefdLast(timestamp, referenceChain)).getIsErroneous(timestamp)) {
            return null;
        }
        long index = 0L;
        if (!indexValue.isUnfoldable(timestamp)) {
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                if (!silent) {
                    arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                }
                return null;
            }
        } else {
            return null;
        }
        index = ((Integer_Value)indexValue).getValue();
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (index < 0L) {
                    if (!silent) {
                        String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `sequence of'' type `{1}''", index, tempType.getTypename());
                        arrayIndex.getLocation().reportSemanticError(message);
                    }
                    return null;
                }
                int nofElements = this.getNofTemplates();
                if (index < (long)nofElements) break;
                if (!silent) {
                    String message = MessageFormat.format("Index overflow in a template of `sequence of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                    arrayIndex.getLocation().reportSemanticError(message);
                }
                return null;
            }
            case TYPE_SET_OF: {
                if (index < 0L) {
                    if (!silent) {
                        String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `set of'' type `{1}''", index, tempType.getTypename());
                        arrayIndex.getLocation().reportSemanticError(message);
                    }
                    return null;
                }
                int nofElements = this.getNofTemplates();
                if (index < (long)nofElements) break;
                if (!silent) {
                    String message = MessageFormat.format("Index overflow in a template of `set of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                    arrayIndex.getLocation().reportSemanticError(message);
                }
                return null;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)tempType).getDimension();
                dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (!dimension.getIsErroneous(timestamp)) {
                    if ((index -= dimension.getOffset()) >= 0L && index < (long)this.getNofTemplates()) break;
                    if (!silent) {
                        arrayIndex.getLocation().reportSemanticError(MessageFormat.format("The index value {0} is outside the array indexable range", index + dimension.getOffset()));
                    }
                    return null;
                }
                return null;
            }
            default: {
                if (!silent) {
                    String message = MessageFormat.format("Invalid array element reference: type `{0}'' cannot be indexed", tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                }
                return null;
            }
        }
        if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)(returnValue = this.getTemplateByIndex((int)index)).getTemplatetype())) {
            if (this.baseTemplate != null) {
                return this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain).getReferencedArrayTemplate(timestamp, indexValue, referenceChain, silent);
            }
            return null;
        }
        return returnValue;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.templates.getTemplateByIndex(i).isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        if (this.converted != null) {
            return this.converted.getValue();
        }
        Values values = new Values(false);
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            values.addValue(this.templates.getTemplateByIndex(i).getValue());
        }
        this.asValue = new SequenceOf_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        this.asValue.setMyGovernor(this.getMyGovernor());
        return this.asValue;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.templates.getTemplateByIndex(i).checkExpressionSelfReferenceTemplate(timestamp, lhs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.templates.getTemplateByIndex(i).checkSpecificValue(timestamp, true);
        }
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)typeType) || IType.Type_type.TYPE_SET_OF.equals((Object)typeType)) {
            int nofTemplatesGood = this.getNofTemplatesNotAnyornone(timestamp);
            boolean hasAnyOrNone = this.templateContainsAnyornone();
            this.lengthRestriction.checkNofElements(timestamp, nofTemplatesGood, hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        boolean needsRuntimeCheck = false;
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.templates.getTemplateByIndex(i).checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) continue;
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    public ITTCN3Template getReferencedSetSequenceFieldTemplate(CompilationTimeStamp timestamp, Identifier fieldIdentifier, Reference reference, IReferenceChain referenceChain, boolean silent) {
        if (this.converted != null) {
            return this.converted.getReferencedSetSequenceFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain, silent);
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.lengthRestriction != null) {
            this.lengthRestriction.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.templates != null) {
            this.templates.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.asValue == null || this.asValue.accept(v);
    }

    @Override
    public void setGenNamePrefix(String prefix) {
        super.setGenNamePrefix(prefix);
        if (this.converted != null) {
            this.converted.setGenNamePrefix(prefix);
            return;
        }
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            this.templates.getTemplateByIndex(i).setGenNamePrefix(prefix);
        }
    }

    @Override
    public void setGenNameRecursive(String parameterGenName) {
        super.setGenNameRecursive(parameterGenName);
        if (this.converted != null) {
            this.converted.setGenNameRecursive(parameterGenName);
            return;
        }
        if (this.myGovernor == null) {
            return;
        }
        IType type = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        long offset = 0L;
        if (IType.Type_type.TYPE_ARRAY.equals((Object)type.getTypetype())) {
            offset = ((Array_Type)type).getDimension().getOffset();
        }
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            StringBuilder embeddedName = new StringBuilder(parameterGenName);
            embeddedName.append('[').append(offset + (long)i).append(']');
            this.templates.getTemplateByIndex(i).setGenNameRecursive(embeddedName.toString());
        }
    }

    @Override
    protected String getNameForStringRep() {
        return "";
    }

    @Override
    public boolean needsTemporaryReference() {
        if (this.converted != null) {
            return this.converted.needsTemporaryReference();
        }
        if (this.lengthRestriction != null || this.isIfpresent) {
            return true;
        }
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            if (template.getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_NOTUSED) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.converted != null) {
            return this.converted.hasSingleExpression();
        }
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        return this.templates.getNofTemplates() == 0;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        if (this.converted != null) {
            return this.converted.getSingleExpression(aData, castIsNeeded);
        }
        if (this.templates.getNofTemplates() != 0) {
            ErrorReporter.INTERNAL_ERROR((String)("INTERNAL ERROR: Can not generate single expression for template list `" + this.getFullName() + "''"));
            return new StringBuilder("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
        }
        aData.addBuiltinTypeImport("TitanNull_Type");
        if (this.myGovernor == null) {
            return new StringBuilder("TitanNull_Type.NULL_VALUE");
        }
        StringBuilder result = new StringBuilder();
        String genName = this.myGovernor.getGenNameTemplate(aData, result);
        result.append(MessageFormat.format("new {0}(TitanNull_Type.NULL_VALUE)", genName));
        return result;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        if (this.lengthRestriction == null && !this.isIfpresent && templateRestriction == TemplateRestriction.Restriction_type.TR_NONE && this.hasSingleExpression()) {
            expression.expression.append((CharSequence)this.getSingleExpression(aData, true));
            return;
        }
        if (this.asValue != null) {
            this.asValue.generateCodeExpression(aData, expression, true);
            return;
        }
        if (this.converted != null) {
            this.converted.generateCodeExpression(aData, expression, templateRestriction);
            return;
        }
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        String genName = governor.getGenNameTemplate(aData, expression.expression);
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", genName, tempId));
        this.setGenNameRecursive(tempId);
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.asValue != null) {
            this.asValue.reArrangeInitCode(aData, source, usageModule);
            return;
        }
        if (this.converted != null) {
            this.converted.reArrangeInitCode(aData, source, usageModule);
            return;
        }
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            this.templates.getTemplateByIndex(i).reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        String ofTypeName;
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.asValue != null) {
            this.asValue.generateCodeInit(aData, source, name);
            return;
        }
        if (this.converted != null) {
            this.converted.generateCodeInit(aData, source, name);
            return;
        }
        if (this.myGovernor == null) {
            return;
        }
        if (this.templates.getNofTemplates() == 0) {
            aData.addBuiltinTypeImport("TitanNull_Type");
            source.append(MessageFormat.format("{0}.operator_assign(TitanNull_Type.NULL_VALUE);\n", name));
            if (this.lengthRestriction != null) {
                if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                    this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
                }
                this.lengthRestriction.generateCodeInit(aData, source, name);
            }
            if (this.isIfpresent) {
                source.append(name);
                source.append(".set_ifPresent();\n");
            }
            return;
        }
        IType typeLast = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        long indexOffset = 0L;
        if (typeLast.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
            indexOffset = ((Array_Type)typeLast).getDimension().getOffset();
        }
        switch (typeLast.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                ofTypeName = ((SequenceOf_Type)typeLast).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_SET_OF: {
                ofTypeName = ((SetOf_Type)typeLast).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_ARRAY: {
                ofTypeName = ((Array_Type)typeLast).getElementType().getGenNameTemplate(aData, source);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing template list `" + this.getFullName() + "''"));
                return;
            }
        }
        if (this.hasPermutation || this.hasAllFrom()) {
            long fixedPart = 0L;
            StringBuilder preamble = new StringBuilder();
            StringBuilder setSize = new StringBuilder();
            StringBuilder body = new StringBuilder();
            String counter = aData.getTemporaryVariableName();
            body.append(MessageFormat.format("int {0} = {1};\n", counter, indexOffset));
            int size = this.templates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                if (template.getTemplatetype() == ITTCN3Template.Template_type.ALL_FROM) {
                    TTCN3Template subTemplate = ((All_From_Template)template).getAllFrom();
                    Reference reference = ((SpecificValue_Template)subTemplate).getReference();
                    Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    setSize.append(" + ");
                    ExpressionStruct referenceExpression = new ExpressionStruct();
                    reference.generateCode(aData, referenceExpression);
                    switch (assignment.getAssignmentType()) {
                        case A_CONST: 
                        case A_EXT_CONST: 
                        case A_MODULEPAR: 
                        case A_VAR: 
                        case A_PAR_VAL: 
                        case A_PAR_VAL_IN: 
                        case A_PAR_VAL_OUT: 
                        case A_PAR_VAL_INOUT: 
                        case A_FUNCTION_RVAL: 
                        case A_EXT_FUNCTION_RVAL: {
                            if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                            referenceExpression.expression.append(".get()");
                            break;
                        }
                    }
                    setSize.append((CharSequence)referenceExpression.expression);
                    if (referenceExpression.preamble.length() > 0) {
                        preamble.append((CharSequence)referenceExpression.preamble);
                    }
                    setSize.append(".n_elem()");
                    body.append(MessageFormat.format("for (int i_i = 0, i_lim = {0}.n_elem(); i_i < i_lim; ++i_i ) '{'\n", referenceExpression.expression));
                    String embeddedName = MessageFormat.format("{0}.get_at({1} + i_i)", name, counter);
                    ((All_From_Template)template).generateCodeInitAllFrom(aData, body, embeddedName, referenceExpression.expression);
                    body.append("}\n");
                    body.append(MessageFormat.format("{0} += {1}.n_elem();\n", counter, referenceExpression.expression));
                    continue;
                }
                if (template.getTemplatetype() == ITTCN3Template.Template_type.PERMUTATION_MATCH) {
                    int numPermutations = ((PermutationMatch_Template)template).getNofTemplates();
                    String permutationStart = aData.getTemporaryVariableName();
                    body.append(MessageFormat.format("int {0} = {1};\n", permutationStart, counter));
                    for (int j = 0; j < numPermutations; ++j) {
                        TTCN3Template template2 = ((PermutationMatch_Template)template).getTemplateByIndex(j);
                        if (template2.getTemplatetype() == ITTCN3Template.Template_type.ALL_FROM) {
                            TTCN3Template subTemplate = ((All_From_Template)template2).getAllFrom();
                            Reference reference = ((SpecificValue_Template)subTemplate).getReference();
                            Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                            setSize.append(" + ");
                            ExpressionStruct referenceExpression = new ExpressionStruct();
                            reference.generateConstRef(aData, referenceExpression);
                            switch (assignment.getAssignmentType()) {
                                case A_CONST: 
                                case A_EXT_CONST: 
                                case A_MODULEPAR: 
                                case A_VAR: 
                                case A_PAR_VAL: 
                                case A_PAR_VAL_IN: 
                                case A_PAR_VAL_OUT: 
                                case A_PAR_VAL_INOUT: 
                                case A_FUNCTION_RVAL: 
                                case A_EXT_FUNCTION_RVAL: {
                                    if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                                    referenceExpression.expression.append(".constGet()");
                                    break;
                                }
                            }
                            setSize.append((CharSequence)referenceExpression.expression);
                            if (referenceExpression.preamble.length() > 0) {
                                preamble.append((CharSequence)referenceExpression.preamble);
                            }
                            setSize.append(".n_elem()");
                            body.append(MessageFormat.format("for (int i_i = 0, i_lim = {0}.n_elem(); i_i < i_lim; ++i_i ) '{'\n", referenceExpression.expression));
                            String embeddedName = MessageFormat.format("{0}.get_at({1} + i_i)", name, counter);
                            ((All_From_Template)template2).generateCodeInitAllFrom(aData, body, embeddedName, referenceExpression.expression);
                            body.append("}\n");
                            body.append(MessageFormat.format("{0} += {1}.n_elem();\n", counter, referenceExpression.expression));
                            template2.lastTimeBuilt = aData.buildTimestamp;
                            continue;
                        }
                        ++fixedPart;
                        template2.generateCodeInitSeofElement(aData, body, name, counter, ofTypeName);
                        body.append(MessageFormat.format("{0}++;\n", counter));
                    }
                    body.append(MessageFormat.format("{0}.add_permutation({1}, {2} - 1);\n", name, permutationStart, counter));
                    template.lastTimeBuilt = aData.buildTimestamp;
                    continue;
                }
                ++fixedPart;
                template.generateCodeInitSeofElement(aData, body, name, counter, ofTypeName);
                body.append(MessageFormat.format("{0}++;\n", counter));
            }
            source.append((CharSequence)preamble);
            source.append(MessageFormat.format("{0}.set_size({1}", name, fixedPart));
            source.append((CharSequence)setSize);
            source.append(");\n");
            source.append((CharSequence)body);
        } else {
            int index = 0;
            int size = this.templates.getNofTemplates();
            block17: for (int i = 0; i < size; ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                switch (template.getTemplatetype()) {
                    case PERMUTATION_MATCH: {
                        PermutationMatch_Template actualTemplate = (PermutationMatch_Template)template;
                        int nofPermutatedTemplates = actualTemplate.getNofTemplates();
                        for (int j = 0; j < nofPermutatedTemplates; ++j) {
                            long ix = indexOffset + (long)index + (long)j;
                            TTCN3Template template2 = actualTemplate.getTemplateByIndex(j);
                            template2.generateCodeInitSeofElement(aData, source, name, Long.toString(ix), ofTypeName);
                        }
                        source.append(MessageFormat.format("{0}.add_permutation({1}, {2});\n", name, index, index + nofPermutatedTemplates - 1));
                        template.lastTimeBuilt = aData.buildTimestamp;
                        index += nofPermutatedTemplates;
                        continue block17;
                    }
                    case ALL_FROM: 
                    case TEMPLATE_NOTUSED: {
                        ++index;
                        continue block17;
                    }
                    default: {
                        template.generateCodeInitSeofElement(aData, source, name, Long.toString(indexOffset + (long)index), ofTypeName);
                        ++index;
                    }
                }
            }
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }
}

