/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EncvalueUnicharExpression
extends Expression_Value {
    private static final String OPERAND1_ERROR1 = "Cannot determine the type of the 1st operand of the `encvalue_unichar' operation";
    private static final String OPERAND1_ERROR2 = "The 1st operand of the `encvalue_unichar' operation cannot be encoded";
    private static final String OPERAND2_ERROR1 = "The 2nd operand of the `encvalue_unichar' operation should be a charstring value";
    private static final String OPERAND2_ERROR2 = "The 2nd operand of the `encvalue_unichar' can only be UTF-8, UTF-16, UTF-16LE, UTF-16BE, UTF-32, UTF-32LE or UTF-32BE";
    private static final String OPERAND3_ERROR1 = "The 3rd operand of the `encvalue_unichar' operation should be a (universal) charstring value";
    private static final String OPERAND4_ERROR1 = "The 4th operand of the `encvalue_unichar' operation should be a (universal) charstring value";
    private final TemplateInstance templateInstance1;
    private final Value serialization;
    private final Value encodingInfo;
    private final Value dynamicEncoding;

    public EncvalueUnicharExpression(TemplateInstance templateInstance1, Value serialization, Value encodingInfo, Value dynamicEncoding) {
        this.templateInstance1 = templateInstance1;
        this.serialization = serialization;
        this.encodingInfo = encodingInfo;
        this.dynamicEncoding = dynamicEncoding;
        if (templateInstance1 != null) {
            templateInstance1.setFullNameParent(this);
        }
        if (serialization != null) {
            serialization.setFullNameParent(this);
        }
        if (encodingInfo != null) {
            encodingInfo.setFullNameParent(this);
        }
        if (dynamicEncoding != null) {
            dynamicEncoding.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ENCVALUE_UNICHAR_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.templateInstance1 != null && this.templateInstance1.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs)) {
            return true;
        }
        if (this.serialization != null && this.serialization.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        if (this.encodingInfo != null && this.encodingInfo.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.dynamicEncoding != null && this.dynamicEncoding.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("encvalue_unichar(");
        builder.append(this.templateInstance1.createStringRepresentation());
        builder.append(", ");
        builder.append(this.serialization == null ? "null" : this.serialization.createStringRepresentation());
        builder.append(", ");
        builder.append(this.encodingInfo == null ? "null" : this.encodingInfo.createStringRepresentation());
        builder.append(", ");
        builder.append(this.dynamicEncoding == null ? "null" : this.dynamicEncoding.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance1 != null) {
            this.templateInstance1.setMyScope(scope);
        }
        if (this.serialization != null) {
            this.serialization.setMyScope(scope);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setMyScope(scope);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance1 != null) {
            this.templateInstance1.setCodeSection(codeSection);
        }
        if (this.serialization != null) {
            this.serialization.setCodeSection(codeSection);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setCodeSection(codeSection);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.serialization == child) {
            return builder.append(".<operand2>");
        }
        if (this.encodingInfo == child) {
            return builder.append(".<operand3>");
        }
        if (this.dynamicEncoding == child) {
            return builder.append(".<operand4>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UCHARSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType.Type_type tempType;
        if (this.templateInstance1 == null) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        ITTCN3Template template = this.templateInstance1.getTemplateBody();
        template.setMyGovernor(null);
        IType type = this.templateInstance1.getExpressionGovernor(timestamp, internalExpectation);
        if (type == null) {
            template = template.setLoweridToReference(timestamp);
            type = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (type == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance1.getLocation().reportSemanticError(OPERAND1_ERROR1);
            }
            this.setIsErroneous(true);
            return;
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance1, type, referenceChain, expectedValue);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        template.checkSpecificValue(timestamp, false);
        IType lastType = type.getTypeRefdLast(timestamp);
        boolean attributeValidationDisabled = false;
        try {
            String property = this.getLocation().getFile().getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableAttributeValidation"));
            attributeValidationDisabled = property != null && "true".equals(property);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        if (!attributeValidationDisabled) {
            type.checkCoding(timestamp, true, this.getMyScope().getModuleScope(), false, this.templateInstance1.getLocation());
        }
        switch (lastType.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_REFD_SPEC: 
            case TYPE_SELECTION: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERAND1_ERROR2);
                this.setIsErroneous(true);
                break;
            }
        }
        if (this.serialization != null) {
            this.serialization.setLoweridToReference(timestamp);
            tempType = this.serialization.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: {
                    String temp;
                    if (this.serialization.getValuetype() != IValue.Value_type.CHARSTRING_VALUE || "UTF-8".equals(temp = ((Charstring_Value)this.serialization).getValue()) || "UTF-16".equals(temp) || "UTF-16LE".equals(temp) || "UTF-16BE".equals(temp) || "UTF-32".equals(temp) || "UTF-32LE".equals(temp) || "UTF-32BE".equals(temp)) break;
                    this.location.reportSemanticError(OPERAND2_ERROR2);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(OPERAND2_ERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setLoweridToReference(timestamp);
            tempType = this.encodingInfo.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.location.reportSemanticError(OPERAND3_ERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setLoweridToReference(timestamp);
            tempType = this.dynamicEncoding.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    IValue lastValue = this.dynamicEncoding.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (this.dynamicEncoding.isUnfoldable(timestamp)) break;
                    boolean errorFound = false;
                    if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((UniversalCharstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    } else if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((Charstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    }
                    if (!errorFound) break;
                    this.dynamicEncoding.getLocation().reportSemanticError(MessageFormat.format("The encoding string does not match any encodings of type `{0}''", type.getTypename()));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(OPERAND4_ERROR1);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance1 != null) {
            this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.templateInstance1 != null) {
                referenceChain.markState();
                this.templateInstance1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.serialization != null) {
                referenceChain.markState();
                this.serialization.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.encodingInfo != null) {
                referenceChain.markState();
                this.encodingInfo.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.dynamicEncoding != null) {
                referenceChain.markState();
                this.dynamicEncoding.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance1 != null) {
            this.templateInstance1.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance1.getLocation());
        }
        if (this.serialization != null) {
            this.serialization.updateSyntax(reparser, false);
            reparser.updateLocation(this.serialization.getLocation());
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.updateSyntax(reparser, false);
            reparser.updateLocation(this.encodingInfo.getLocation());
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.updateSyntax(reparser, false);
            reparser.updateLocation(this.dynamicEncoding.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance1 != null) {
            this.templateInstance1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.serialization != null) {
            this.serialization.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance1 != null && !this.templateInstance1.accept(v)) {
            return false;
        }
        if (this.serialization != null && !this.serialization.accept(v)) {
            return false;
        }
        if (this.encodingInfo != null && !this.encodingInfo.accept(v)) {
            return false;
        }
        return this.dynamicEncoding == null || this.dynamicEncoding.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance1 != null) {
            this.templateInstance1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.serialization != null) {
            this.serialization.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        String v2_code;
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addCommonLibraryImport("AdditionalFunctions");
        boolean isValue = this.templateInstance1.getTemplateBody().isValue(CompilationTimeStamp.getBaseTimestamp());
        ExpressionStruct expression2 = new ExpressionStruct();
        if (isValue) {
            this.templateInstance1.getTemplateBody().getValue().generateCodeExpressionMandatory(aData, expression2, true);
        } else {
            this.templateInstance1.generateCode(aData, expression2, TemplateRestriction.Restriction_type.TR_NONE);
        }
        if (this.serialization == null) {
            v2_code = "\"UTF-8\"";
        } else if (this.serialization.getValuetype() == IValue.Value_type.CHARSTRING_VALUE) {
            String encoding = ((Charstring_Value)this.serialization).getValue();
            v2_code = MessageFormat.format("\"{0}\"", encoding);
        } else {
            ExpressionStruct tempExpression = new ExpressionStruct();
            this.serialization.generateCodeExpressionMandatory(aData, tempExpression, true);
            String tempID = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("final TitanCharString {0} = {1};\n", tempID, tempExpression.expression));
            expression.preamble.append(MessageFormat.format("if ({0}.operator_not_equals(\"UTF-8\") && {0}.operator_not_equals(\"UTF-16\") && {0}.operator_not_equals(\"UTF-16LE\") && {0}.operator_not_equals(\"UTF-16BE\") && {0}.operator_not_equals(\"UTF-32\") && {0}.operator_not_equals(\"UTF-32LE\") && {0}.operator_not_equals(\"UTF-32BE\")) '{'\n", tempID));
            expression.preamble.append(MessageFormat.format("throw new TtcnError(MessageFormat.format(\"decvalue_unichar: Invalid encoding parameter: '{'0'}'\", {0}));\n", tempID));
            expression.preamble.append("}\n");
            v2_code = tempID;
        }
        Scope scope = this.templateInstance1.getTemplateBody().getMyScope();
        IType governor = this.templateInstance1.getTemplateBody().getMyGovernor();
        if (expression2.preamble.length() > 0) {
            expression.postamble.append((CharSequence)expression2.preamble);
        }
        ExpressionStruct expression3 = new ExpressionStruct();
        if (this.dynamicEncoding == null) {
            expression3.expression.append(MessageFormat.format("{0}_default_coding", governor.getGenNameDefaultCoding(aData, expression.expression, scope)));
        } else {
            this.dynamicEncoding.generateCodeExpression(aData, expression3, true);
            if (expression3.preamble.length() > 0) {
                expression.preamble.append((CharSequence)expression3.preamble);
            }
        }
        String tempID = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("TitanOctetString {0} = new TitanOctetString();\n", tempID));
        expression.preamble.append(MessageFormat.format("{0}_encoder({1}{2}, {3}, {4});\n", governor.getGenNameCoder(aData, expression.expression, scope), expression2.expression, isValue ? "" : ".valueof()", tempID, expression3.expression));
        expression.expression.append(MessageFormat.format("AdditionalFunctions.oct2unichar({0}, {1})", tempID, v2_code));
        if (expression2.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression2.postamble);
        }
        if (expression3.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression3.postamble);
        }
    }
}

