/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.windows;

import java.util.Collection;
import javax.swing.JMenu;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.ComponentGraphGenerator;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.gui.windows.GraphEditor;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.ui.IFileEditorInput;

public class ComponentGraphEditor
extends GraphEditor {
    public static final String ID = "org.eclipse.titanium.graph.editors.ComponentGraphEditor";

    @Override
    protected void initWindow() {
        super.initWindow();
        LayoutEntry isom = Layouts.LAYOUT_ISOM.newInstance();
        isom.addActionListener(this.layoutListener);
        this.layoutGroup.add(isom);
        this.layoutMenu.add(isom);
        JMenu dagMenu = new JMenu("Directed layouts");
        this.layoutMenu.add(dagMenu);
        LayoutEntry tdag = Layouts.LAYOUT_TDAG.newInstance();
        tdag.setSelected(true);
        tdag.addActionListener(this.layoutListener);
        dagMenu.add(tdag);
        this.layoutGroup.add(tdag);
        LayoutEntry rtdag = Layouts.LAYOUT_RTDAG.newInstance();
        rtdag.addActionListener(this.layoutListener);
        dagMenu.add(rtdag);
        this.layoutGroup.add(rtdag);
    }

    @Override
    public void recolour(Collection<NodeDescriptor> nodeSet) {
        for (NodeDescriptor v : nodeSet) {
            v.setNodeColour(NodeColours.LIGHT_GREEN);
        }
    }

    @Override
    protected void initGeneratorAndHandler(Composite parent) {
        this.handler = new GraphHandler();
        this.generator = new ComponentGraphGenerator(((IFileEditorInput)this.getEditorInput()).getFile().getProject(), this.errorHandler);
    }
}

